/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.sql.impl.schema.DataConnectionStorage;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.schema.dataconnection.DataConnectionCatalogEntry;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class DataConnectionStorageTest
extends SimpleTestInClusterSupport {
    private DataConnectionStorage storage;

    @BeforeClass
    public static void setUpClass() {
        DataConnectionStorageTest.initialize((int)1, null);
    }

    @Before
    public void before() {
        this.storage = new DataConnectionStorage((NodeEngine)Accessors.getNodeEngineImpl((HazelcastInstance)DataConnectionStorageTest.instance()));
    }

    @Test
    public void when_put_then_isPresentInValues() {
        String name = DataConnectionStorageTest.randomName();
        this.storage.put(name, DataConnectionStorageTest.dataConnection(name, "type", false));
        Assertions.assertThat(this.storage.dataConnectionNames().stream().filter(m -> m.equals(name))).isNotEmpty();
    }

    @Test
    public void when_put_then_overridesPrevious() {
        String name = DataConnectionStorageTest.randomName();
        DataConnectionCatalogEntry originalDL = DataConnectionStorageTest.dataConnection(name, "type1", false);
        DataConnectionCatalogEntry updatedDL = DataConnectionStorageTest.dataConnection(name, "type2", true);
        this.storage.put(name, originalDL);
        this.storage.put(name, updatedDL);
        Assert.assertTrue((boolean)this.storage.allObjects().stream().noneMatch(dl -> dl.equals(originalDL)));
        Assert.assertTrue((boolean)this.storage.allObjects().stream().anyMatch(dl -> dl.equals(updatedDL)));
    }

    @Test
    public void when_putIfAbsent_then_doesNotOverride() {
        String name = DataConnectionStorageTest.randomName();
        Assertions.assertThat((boolean)this.storage.putIfAbsent(name, DataConnectionStorageTest.dataConnection(name, "type-1", true))).isTrue();
        Assertions.assertThat((boolean)this.storage.putIfAbsent(name, DataConnectionStorageTest.dataConnection(name, "type-2", false))).isFalse();
        Assert.assertTrue((boolean)this.storage.allObjects().stream().anyMatch(dl -> dl instanceof DataConnectionCatalogEntry && ((DataConnectionCatalogEntry)dl).type().equals("type-1")));
        Assert.assertTrue((boolean)this.storage.allObjects().stream().noneMatch(dl -> dl instanceof DataConnectionCatalogEntry && ((DataConnectionCatalogEntry)dl).type().equals("type-2")));
    }

    @Test
    public void when_removeMapping_then_isNotPresentInValues() {
        String name = DataConnectionStorageTest.randomName();
        this.storage.put(name, DataConnectionStorageTest.dataConnection(name, "type", false));
        Assertions.assertThat((boolean)this.storage.removeDataConnection(name)).isTrue();
        Assert.assertTrue((boolean)this.storage.dataConnectionNames().stream().noneMatch(dl -> dl.equals(name)));
    }

    private static DataConnectionCatalogEntry dataConnection(String name, String type, boolean shared) {
        return new DataConnectionCatalogEntry(name, type, shared, Collections.emptyMap());
    }
}

