/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.processors;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.function.ToLongFunctionEx;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.JetJoinInfo;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinP;
import com.hazelcast.jet.sql.impl.processors.StreamToStreamJoinPInnerTest;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.shaded.org.apache.calcite.rel.core.JoinRelType;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={QuickTest.class, ParallelJVMTest.class})
@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
public class StreamToStreamJoinPOuterTest
extends SqlTestSupport {
    private Map<Byte, ToLongFunctionEx<JetSqlRow>> leftExtractors = Collections.singletonMap((byte)0, (ToLongFunctionEx & Serializable)l -> (Long)l.getRow().get(0));
    private Map<Byte, ToLongFunctionEx<JetSqlRow>> rightExtractors = Collections.singletonMap((byte)1, (ToLongFunctionEx & Serializable)r -> (Long)r.getRow().get(0));
    private final Map<Byte, Map<Byte, Long>> postponeTimeMap = new HashMap<Byte, Map<Byte, Long>>();
    @Parameterized.Parameter
    public boolean isLeft;
    private byte ordinal0;
    private byte ordinal1;
    private JoinRelType joinType;

    @BeforeClass
    public static void beforeClass() {
        StreamToStreamJoinPOuterTest.initialize((int)1, null);
    }

    @Parameterized.Parameters(name="isLeft={0}")
    public static Object[] parameters() {
        return new Object[]{true, false};
    }

    @Before
    public void before() {
        if (this.isLeft) {
            this.ordinal0 = 0;
            this.ordinal1 = 1;
            this.joinType = JoinRelType.LEFT;
        } else {
            this.ordinal0 = 1;
            this.ordinal1 = 0;
            this.joinType = JoinRelType.RIGHT;
        }
    }

    @Test
    public void test_outerJoinRowsEmittedAfterWatermark() {
        this.postponeTimeMap.put((byte)0, Collections.singletonMap((byte)1, 1L));
        this.postponeTimeMap.put((byte)1, Collections.singletonMap((byte)0, 1L));
        SupplierEx<Processor> supplier = this.createProcessor(1, 1, false);
        TestSupport.verifyProcessor(supplier).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).outputChecker(StreamToStreamJoinPInnerTest.SAME_ITEMS_ANY_ORDER_EQUIVALENT_WMS).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)0, (Object)StreamToStreamJoinPOuterTest.wm((long)1L, (byte)0)), TestSupport.in((int)1, (Object)StreamToStreamJoinPOuterTest.wm((long)1L, (byte)1)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)0L, (byte)1)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)0L, (byte)0)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(3L)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(4L)), TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal1)), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(3L, null) : StreamToStreamJoinPOuterTest.jetRow(null, 3L))), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(4L, null) : StreamToStreamJoinPOuterTest.jetRow(null, 4L))), TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)1L, (byte)this.ordinal0)), TestSupport.processorAssertion(p -> Assert.assertEquals((long)0L, (long)(p.buffer[0].size() + p.buffer[1].size())))});
    }

    @Test
    public void test_rowContainsMultipleColumns() {
        this.postponeTimeMap.put((byte)0, Collections.singletonMap((byte)1, 0L));
        this.postponeTimeMap.put((byte)1, Collections.singletonMap((byte)0, 0L));
        TestSupport.verifyProcessor(this.isLeft ? this.createProcessor(1, 2, true) : this.createProcessor(2, 1, true)).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(3L)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(4L)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal0)), TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal1)), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(3L, null, null) : StreamToStreamJoinPOuterTest.jetRow(null, null, 3L))), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(4L, null, null) : StreamToStreamJoinPOuterTest.jetRow(null, null, 4L))), this.isLeft ? TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal1)) : TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal0)), this.isLeft ? TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal0)) : TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)6L, (byte)this.ordinal1)), TestSupport.processorAssertion(p -> Assert.assertEquals((long)0L, (long)(p.buffer[0].size() + p.buffer[1].size())))});
    }

    @Test
    public void test_nonLateItemOutOfLimit() {
        this.postponeTimeMap.put((byte)0, (Map<Byte, Long>)ImmutableMap.of((Object)1, (Object)1L));
        this.postponeTimeMap.put((byte)1, (Map<Byte, Long>)ImmutableMap.of((Object)0, (Object)1L));
        SupplierEx<Processor> supplier = this.createProcessor(1, 1, false);
        TestSupport.verifyProcessor(supplier).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.wm((long)10L, (byte)this.ordinal1)), TestSupport.processorAssertion(p -> Assert.assertEquals((Object)ImmutableMap.of((Object)this.ordinal0, (Object)9L, (Object)this.ordinal1, (Object)-9223372036854775807L), (Object)p.wmState)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(8L)), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(8L, null) : StreamToStreamJoinPOuterTest.jetRow(null, 8L))), TestSupport.processorAssertion(p -> Assert.assertEquals((long)0L, (long)(p.buffer[0].size() + p.buffer[1].size())))});
    }

    @Test
    public void test_nonLateItemOutOfLimit_hasMatchInBuffer() {
        this.postponeTimeMap.put((byte)0, Collections.singletonMap((byte)1, 0L));
        this.postponeTimeMap.put((byte)1, Collections.singletonMap((byte)0, 0L));
        ProcessorSupplier processorSupplier = ProcessorSupplier.of(this.createProcessor(1, 1, true));
        TestSupport.verifyProcessor((ProcessorSupplier)processorSupplier).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.jetRow(0L)), TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.wm((long)10L, (byte)this.ordinal1)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(0L)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.jetRow(0L, 0L)), TestSupport.processorAssertion(processor -> Assert.assertEquals((long)0L, (long)processor.buffer[this.ordinal0].size())), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(1L)), TestSupport.out((Object)(this.isLeft ? StreamToStreamJoinPOuterTest.jetRow(1L, null) : StreamToStreamJoinPOuterTest.jetRow(null, 1L)))});
    }

    @Test
    public void when_offLimitAccordingToWm1_and_lateAccordingToWm2_then_handleAsLate() {
        this.postponeTimeMap.put((byte)0, Collections.singletonMap((byte)2, 1L));
        this.postponeTimeMap.put((byte)1, Collections.emptyMap());
        this.postponeTimeMap.put((byte)2, Collections.singletonMap((byte)0, 1L));
        this.leftExtractors = new HashMap<Byte, ToLongFunctionEx<JetSqlRow>>();
        this.leftExtractors.put((byte)0, (ToLongFunctionEx<JetSqlRow>)(ToLongFunctionEx & Serializable)l -> (Long)l.getRow().get(0));
        this.leftExtractors.put((byte)1, (ToLongFunctionEx<JetSqlRow>)(ToLongFunctionEx & Serializable)l -> (Long)l.getRow().get(1));
        this.rightExtractors = Collections.singletonMap((byte)2, (ToLongFunctionEx & Serializable)r -> (Long)r.getRow().get(0));
        SupplierEx<Processor> supplier = this.createProcessor(2, 1, false);
        TestSupport.verifyProcessor(supplier).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)1, (Object)StreamToStreamJoinPOuterTest.wm((long)10L, (byte)2)), TestSupport.in((int)0, (Object)StreamToStreamJoinPOuterTest.wm((long)10L, (byte)1)), TestSupport.in((int)0, (Object)StreamToStreamJoinPOuterTest.wm((long)10L, (byte)0)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)9L, (byte)2)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.wm((long)9L, (byte)0)), TestSupport.in((int)0, (Object)StreamToStreamJoinPOuterTest.jetRow(0L, 0L))});
    }

    @Test
    public void test_matchingRowAlreadyInBuffer() {
        this.postponeTimeMap.put((byte)0, Collections.singletonMap((byte)1, 0L));
        this.postponeTimeMap.put((byte)1, Collections.singletonMap((byte)0, 0L));
        SupplierEx<Processor> supplier = this.createProcessor(1, 1, true);
        TestSupport.verifyProcessor(supplier).hazelcastInstance(StreamToStreamJoinPOuterTest.instance()).cooperativeTimeout(0L).expectExactOutput(new TestSupport.TestEvent[]{TestSupport.in((int)this.ordinal1, (Object)StreamToStreamJoinPOuterTest.jetRow(42L)), TestSupport.in((int)this.ordinal0, (Object)StreamToStreamJoinPOuterTest.jetRow(42L)), TestSupport.out((Object)StreamToStreamJoinPOuterTest.jetRow(42L, 42L))});
    }

    private SupplierEx<Processor> createProcessor(int leftColumnCount, int rightColumnCount, boolean assumeEquiJoin) {
        Expression<Boolean> condition = StreamToStreamJoinPInnerTest.createConditionFromPostponeTimeMap(this.postponeTimeMap, new int[0]);
        int[] equiJoinIndices = new int[assumeEquiJoin ? 1 : 0];
        JetJoinInfo joinInfo = new JetJoinInfo(this.joinType, equiJoinIndices, equiJoinIndices, condition, condition);
        return (SupplierEx & Serializable)() -> new StreamToStreamJoinP(joinInfo, this.leftExtractors, this.rightExtractors, this.postponeTimeMap, Tuple2.tuple2((Object)leftColumnCount, (Object)rightColumnCount));
    }
}

