/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.parse;

import com.hazelcast.config.Config;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.OptimizerContext;
import com.hazelcast.jet.sql.impl.TestTableResolver;
import com.hazelcast.jet.sql.impl.validate.operators.special.HazelcastUdtObjectToJsonFunction;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ParserOperationsTest
extends SqlTestSupport {
    private OptimizerContext context;

    @BeforeClass
    public static void beforeClass() {
        ParserOperationsTest.initialize((int)1, (Config)ParserOperationsTest.smallInstanceConfig());
    }

    @Before
    public void before() {
        this.context = ParserOperationsTest.createContext();
    }

    @Test
    public void testSelectColumn() {
        this.checkSuccess("SELECT a, b FROM t");
    }

    @Test
    public void testSelectLiteral() {
        this.checkSuccess("SELECT 1 FROM t");
    }

    @Test
    public void testSelectAs() {
        this.checkSuccess("SELECT a a_alias FROM t t_alias");
    }

    @Test
    public void testSelectFromDerivedTable() {
        this.checkSuccess("SELECT a_alias FROM (SELECT a a_alias FROM t)");
    }

    @Test
    public void testWhereIsPredicates() {
        this.checkSuccess("SELECT a, b FROM t WHERE a IS NULL");
    }

    @Test
    public void testWhereComparison() {
        this.checkSuccess("SELECT a, b FROM t WHERE a = b");
        this.checkSuccess("SELECT a, b FROM t WHERE a != b");
        this.checkSuccess("SELECT a, b FROM t WHERE a <> b");
        this.checkSuccess("SELECT a, b FROM t WHERE a > b");
        this.checkSuccess("SELECT a, b FROM t WHERE a >= b");
        this.checkSuccess("SELECT a, b FROM t WHERE a < b");
        this.checkSuccess("SELECT a, b FROM t WHERE a <= b");
    }

    @Test
    public void testOrderBy() {
        this.checkSuccess("SELECT a, b FROM t ORDER BY a");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a ASC");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a DESC");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a DESC, b ASC");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a DESC OFFSET 10 ROWS FETCH FIRST 20 ROWS ONLY");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a DESC FETCH FIRST 20 ROWS ONLY");
        this.checkSuccess("SELECT a, b FROM t ORDER BY a DESC OFFSET 10 ROWS");
    }

    @Test
    public void testOffsetFetchOnly() {
        this.checkSuccess("SELECT a, b FROM t OFFSET 10 ROWS FETCH FIRST 20 ROWS ONLY");
        this.checkSuccess("SELECT a, b FROM t FETCH FIRST 20 ROWS ONLY");
        this.checkSuccess("SELECT a, b FROM t OFFSET 10 ROWS");
    }

    @Test
    public void testExists() {
        this.checkSuccess("SELECT a, b FROM t WHERE EXISTS(SELECT 1 FROM t tt WHERE t.a = tt.a)");
        this.checkSuccess("SELECT a, b FROM t WHERE EXISTS(SELECT * FROM t tt WHERE t.a = tt.a)");
    }

    @Test
    public void testSelectScalar() {
        this.checkFailure("SELECT (SELECT a FROM t) FROM t", "SCALAR QUERY not supported");
    }

    @Test
    public void testWhereScalar() {
        this.checkFailure("SELECT a, b FROM t WHERE (SELECT a FROM t) IS NULL", "SCALAR QUERY not supported");
    }

    @Test
    public void testNullsFirstLast() {
        this.checkFailure("SELECT a, b FROM t ORDER BY a DESC NULLS FIRST", "NULLS FIRST not supported");
        this.checkFailure("SELECT a, b FROM t ORDER BY a DESC NULLS LAST", "NULLS LAST not supported");
    }

    @Test
    public void testGroupBy() {
        this.checkSuccess("SELECT a FROM t GROUP BY a");
    }

    @Test
    public void testAggregate() {
        this.checkSuccess("SELECT SUM(a) FROM t");
    }

    @Test
    public void testJoin() {
        this.checkSuccess("SELECT t1.a, t2.a FROM t t1 JOIN t t2 ON t1.a = t2.a");
    }

    @Test
    public void testMalformedExpression() {
        this.checkFailure("select 1 + from t", "Was expecting one of");
    }

    @Test
    public void testHiddenFunctions() {
        this.checkFailure("SELECT JSON_PARSE('[1,2,3]')", "Function 'JSON_PARSE' does not exist");
        String fname = HazelcastUdtObjectToJsonFunction.INSTANCE.getName();
        this.checkFailure("SELECT " + fname + "(null)", "Function '" + fname + "' does not exist");
    }

    private void checkSuccess(String sql) {
        this.context.parse(sql);
    }

    private void checkFailure(String sql, String message) {
        try {
            this.context.parse(sql);
            Assert.fail((String)("Exception is not thrown: " + message));
        }
        catch (QueryException e) {
            Assert.assertEquals((long)1008L, (long)e.getCode());
            Assert.assertTrue((String)e.getCause().getMessage(), (boolean)e.getCause().getMessage().contains(message));
        }
    }

    private static OptimizerContext createContext() {
        PartitionedMapTable partitionedMapTable = new PartitionedMapTable("public", "t", "t", Arrays.asList(ParserOperationsTest.field("a"), ParserOperationsTest.field("b")), (TableStatistics)new ConstantTableStatistics(100L), null, null, null, null, null, false, Collections.emptyList(), false);
        TestTableResolver resolver = TestTableResolver.create("public", new Table[]{partitionedMapTable});
        List<TestTableResolver> tableResolvers = Collections.singletonList(resolver);
        List searchPaths = QueryUtils.prepareSearchPaths(Collections.emptyList(), tableResolvers);
        return OptimizerContext.create((SqlCatalog)new SqlCatalog(tableResolvers), (List)searchPaths, Collections.emptyList(), name -> null, null, (SqlSecurityContext)NoOpSqlSecurityContext.INSTANCE);
    }

    private static TableField field(String name) {
        return new Field(name, QueryDataType.INT, false);
    }

    private static class Field
    extends TableField {
        private Field(String name, QueryDataType type, boolean hidden) {
            super(name, type, hidden);
        }
    }
}

