/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRel;
import com.hazelcast.jet.sql.impl.opt.physical.StreamToStreamJoinPhysicalRule;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.avatica.util.TimeUnit;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.shaded.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.shaded.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.shaded.org.apache.calcite.rex.RexNode;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIntervalQualifier;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class StreamToStreamJoinPhysicalRuleTest
extends OptimizerTestSupport {
    @Test
    public void test_maxWindowSize() {
        HashMap<Integer, Map<Integer, Long>> postponeTimeMap = new HashMap<Integer, Map<Integer, Long>>();
        postponeTimeMap.put(0, Collections.singletonMap(3, 10L));
        postponeTimeMap.put(1, Collections.singletonMap(4, 10L));
        postponeTimeMap.put(2, Collections.singletonMap(5, 15L));
        postponeTimeMap.put(3, Collections.singletonMap(0, 6L));
        postponeTimeMap.put(4, Collections.singletonMap(1, 13L));
        postponeTimeMap.put(5, Collections.singletonMap(2, 6L));
        Assert.assertEquals((long)16L, (long)StreamToStreamJoinPhysicalRel.minimumSpread(postponeTimeMap, (int)3));
    }

    @Test
    public void test() {
        HazelcastTypeFactory typeFactory = HazelcastTypeFactory.INSTANCE;
        RexBuilder b = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexInputRef leftTime = b.makeInputRef(typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), 0);
        RexInputRef rightTime = b.makeInputRef(typeFactory.createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), 2);
        RexLiteral intervalTen = b.makeIntervalLiteral(BigDecimal.TEN, new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO));
        RexLiteral intervalZero = b.makeIntervalLiteral(BigDecimal.ZERO, new SqlIntervalQualifier(TimeUnit.SECOND, TimeUnit.SECOND, SqlParserPos.ZERO));
        Assert.assertEquals((Object)ImmutableMap.of((Object)2, (Object)ImmutableMap.of((Object)0, (Object)0L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{leftTime, rightTime})));
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)2, (Object)10L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.LESS_THAN_OR_EQUAL, new RexNode[]{leftTime, b.makeCall(HazelcastSqlOperatorTable.PLUS, new RexNode[]{rightTime, intervalTen})})));
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)2, (Object)10L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.LESS_THAN, new RexNode[]{b.makeCall(HazelcastSqlOperatorTable.MINUS, new RexNode[]{leftTime, rightTime}), intervalTen})));
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)2, (Object)-10L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.LESS_THAN, new RexNode[]{b.makeCall(HazelcastSqlOperatorTable.PLUS, new RexNode[]{b.makeCall(HazelcastSqlOperatorTable.MINUS, new RexNode[]{leftTime, rightTime}), intervalTen}), intervalZero})));
        Assert.assertEquals((Object)ImmutableMap.of((Object)2, (Object)ImmutableMap.of((Object)0, (Object)10L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.GREATER_THAN, new RexNode[]{b.makeCall(HazelcastSqlOperatorTable.PLUS, new RexNode[]{leftTime, intervalTen}), b.makeCall(HazelcastSqlOperatorTable.MINUS, new RexNode[]{b.makeCall(HazelcastSqlOperatorTable.PLUS, new RexNode[]{rightTime, intervalTen}), intervalTen})})));
        Assert.assertEquals((Object)ImmutableMap.of((Object)0, (Object)ImmutableMap.of((Object)2, (Object)10L), (Object)2, (Object)ImmutableMap.of((Object)0, (Object)-10L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.EQUALS, new RexNode[]{leftTime, b.makeCall(HazelcastSqlOperatorTable.PLUS, new RexNode[]{rightTime, intervalTen})})));
        Assert.assertEquals(Collections.emptyMap(), this.call((RexNode)intervalTen));
    }

    @Test
    public void test_implicitCasts() {
        HazelcastTypeFactory typeFactory = HazelcastTypeFactory.INSTANCE;
        RexBuilder b = new RexBuilder((RelDataTypeFactory)typeFactory);
        RexInputRef leftTime = b.makeInputRef(typeFactory.createSqlType(SqlTypeName.TINYINT), 0);
        RexInputRef rightTime = b.makeInputRef(typeFactory.createSqlType(SqlTypeName.TINYINT), 2);
        Assert.assertEquals((Object)ImmutableMap.of((Object)2, (Object)ImmutableMap.of((Object)0, (Object)0L)), this.call(b.makeCall((SqlOperator)HazelcastSqlOperatorTable.GREATER_THAN_OR_EQUAL, new RexNode[]{b.makeCall(typeFactory.createSqlType(SqlTypeName.BIGINT), (SqlOperator)HazelcastSqlOperatorTable.CAST, Collections.singletonList(leftTime)), b.makeCall(typeFactory.createSqlType(SqlTypeName.BIGINT), (SqlOperator)HazelcastSqlOperatorTable.CAST, Collections.singletonList(rightTime))})));
    }

    public Map<Integer, Map<Integer, Long>> call(RexNode expr) {
        HashMap<Integer, Map<Integer, Long>> map = new HashMap<Integer, Map<Integer, Long>>();
        StreamToStreamJoinPhysicalRule.tryExtractTimeBound((RexNode)expr, Set.of(Integer.valueOf(0), Integer.valueOf(2)), map);
        return map;
    }
}

