/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.physical;

import com.hazelcast.function.SupplierEx;
import com.hazelcast.jet.core.DAG;
import com.hazelcast.jet.core.Edge;
import com.hazelcast.jet.core.Processor;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.core.processor.Processors;
import com.hazelcast.jet.sql.impl.opt.physical.CreateTopLevelDagVisitor;
import org.junit.Assert;
import org.junit.Test;

public class CreateDagVisitorTest {
    private static final SupplierEx<Processor> PROCESSOR_SUPPLIER = Processors.noopP();

    @Test
    public void when_loweringDownParallelismBetweenTwoDefaultParallelismVertices_then_parallelismIsChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((long)4L, (long)a.getLocalParallelism());
        Assert.assertEquals((long)4L, (long)b.getLocalParallelism());
    }

    @Test
    public void when_loweringDownParallelismBetweenThreeDefaultParallelismVertices_then_parallelismIsChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        Vertex c = dag.newVertex("c", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        dag.edge(Edge.between((Vertex)b, (Vertex)c));
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((long)4L, (long)a.getLocalParallelism());
        Assert.assertEquals((long)4L, (long)b.getLocalParallelism());
        Assert.assertEquals((long)4L, (long)c.getLocalParallelism());
    }

    @Test
    public void when_loweringDownParallelismBetweenOneDefaultParallelismVertex_then_parallelismIsNotChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        a.localParallelism(1);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((long)1L, (long)a.getLocalParallelism());
        Assert.assertEquals((long)-1L, (long)b.getLocalParallelism());
    }

    @Test
    public void when_loweringDownParallelismWithSingleCooperativeThreadCount_then_parallelismIsNotChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)1);
        Assert.assertEquals((long)-1L, (long)a.getLocalParallelism());
        Assert.assertEquals((long)-1L, (long)b.getLocalParallelism());
    }

    @Test
    public void when_loweringDownParallelismOnLocalEdge_then_edgeIsIsolated() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((Object)Edge.RoutingPolicy.ISOLATED, (Object)((Edge)dag.getOutboundEdges(a.getName()).get(0)).getRoutingPolicy());
    }

    @Test
    public void when_loweringDownParallelismOnDistributedEdge_then_parallelismIsNotChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        Edge edge = (Edge)dag.getOutboundEdges(a.getName()).get(0);
        edge.distributed();
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((long)-1L, (long)a.getLocalParallelism());
        Assert.assertEquals((long)-1L, (long)b.getLocalParallelism());
    }

    @Test
    public void when_loweringDownParallelismOnDistributedEdge_then_edgeRoutingPolicyIsNotChanged() {
        DAG dag = new DAG();
        Vertex a = dag.newVertex("a", PROCESSOR_SUPPLIER);
        Vertex b = dag.newVertex("b", PROCESSOR_SUPPLIER);
        dag.edge(Edge.between((Vertex)a, (Vertex)b));
        Edge edge = (Edge)dag.getOutboundEdges(a.getName()).get(0);
        edge.distributed();
        Edge.RoutingPolicy routingPolicy = edge.getRoutingPolicy();
        CreateTopLevelDagVisitor.decreaseParallelism((DAG)dag, (int)16);
        Assert.assertEquals((Object)routingPolicy, (Object)edge.getRoutingPolicy());
    }
}

