/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.logical;

import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SinkLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.SinkMapLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.ValuesLogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import junitparams.JUnitParamsRunner;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class LogicalSinkTest
extends OptimizerTestSupport {
    @BeforeClass
    public static void setUpClass() {
        LogicalSinkTest.initialize((int)1, null);
    }

    @Test
    public void test_requiresJob() {
        HazelcastTable table = LogicalSinkTest.partitionedTable("m", Arrays.asList(LogicalSinkTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSinkTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalSinkTest.assertPlan((RelNode)this.optimizeLogical("SINK INTO m VALUES (1, '1'), (2, '2')", true, table), LogicalSinkTest.plan(LogicalSinkTest.planRow(0, SinkLogicalRel.class), LogicalSinkTest.planRow(1, ValuesLogicalRel.class)));
    }

    @Test
    public void test_sinkValues() {
        HazelcastTable table = LogicalSinkTest.partitionedTable("m", Arrays.asList(LogicalSinkTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSinkTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalSinkTest.assertPlan((RelNode)this.optimizeLogical("SINK INTO m VALUES (1, '1'), (2, '2')", table), LogicalSinkTest.plan(LogicalSinkTest.planRow(0, SinkMapLogicalRel.class)));
    }

    @Test
    public void test_sinkSelect() {
        HazelcastTable target = LogicalSinkTest.partitionedTable("m1", Arrays.asList(LogicalSinkTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSinkTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        HazelcastTable source = LogicalSinkTest.partitionedTable("m2", Arrays.asList(LogicalSinkTest.field(QueryPath.KEY, QueryDataType.INT), LogicalSinkTest.field(QueryPath.VALUE, QueryDataType.VARCHAR)), 0L);
        LogicalSinkTest.assertPlan((RelNode)this.optimizeLogical("SINK INTO m1 SELECT * FROM m2", target, source), LogicalSinkTest.plan(LogicalSinkTest.planRow(0, SinkLogicalRel.class), LogicalSinkTest.planRow(1, FullScanLogicalRel.class)));
    }
}

