/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.cost;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.opt.cost.Cost;
import com.hazelcast.jet.sql.impl.opt.cost.CostFactory;
import com.hazelcast.shaded.org.apache.calcite.plan.RelOptCost;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CostTest {
    @Test
    public void testCostFactory() {
        CostFactory factory = CostFactory.INSTANCE;
        Assert.assertSame((Object)Cost.INFINITY, (Object)factory.makeInfiniteCost());
        Assert.assertSame((Object)Cost.HUGE, (Object)factory.makeHugeCost());
        Assert.assertSame((Object)Cost.TINY, (Object)factory.makeTinyCost());
        Assert.assertSame((Object)Cost.ZERO, (Object)factory.makeZeroCost());
        Cost cost = factory.makeCost(1.0, 2.0, 3.0);
        Assert.assertEquals((double)1.0, (double)cost.getRowsInternal(), (double)0.0);
        Assert.assertEquals((double)2.0, (double)cost.getCpuInternal(), (double)0.0);
        Assert.assertEquals((double)3.0, (double)cost.getNetworkInternal(), (double)0.0);
    }

    @Test
    public void testIsInfinite() {
        CostFactory factory = CostFactory.INSTANCE;
        Assert.assertFalse((boolean)factory.makeCost(1.0, 2.0, 3.0).isInfinite());
        Assert.assertTrue((boolean)factory.makeCost(1.0, Double.POSITIVE_INFINITY, 3.0).isInfinite());
        Assert.assertTrue((boolean)factory.makeCost(1.0, 2.0, Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)factory.makeCost(1.0, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY).isInfinite());
        Assert.assertTrue((boolean)factory.makeInfiniteCost().isInfinite());
    }

    @Test
    public void testEpsilon() {
        CostFactory factory = CostFactory.INSTANCE;
        Cost cost1 = factory.makeCost(1.0, 2.0, 3.0);
        Cost cost2 = factory.makeCost(1.0, 2.000005, 3.0);
        Cost cost3 = factory.makeCost(1.0, 2.00002, 3.0);
        Assert.assertTrue((boolean)cost1.isEqWithEpsilon((RelOptCost)cost2));
        Assert.assertFalse((boolean)cost1.isEqWithEpsilon((RelOptCost)cost3));
        Assert.assertTrue((boolean)cost2.isEqWithEpsilon((RelOptCost)cost1));
        Assert.assertFalse((boolean)cost2.isEqWithEpsilon((RelOptCost)cost3));
        Assert.assertFalse((boolean)cost3.isEqWithEpsilon((RelOptCost)cost1));
        Assert.assertFalse((boolean)cost3.isEqWithEpsilon((RelOptCost)cost2));
        Cost infiniteCost = factory.makeInfiniteCost();
        Assert.assertFalse((boolean)cost1.isEqWithEpsilon((RelOptCost)infiniteCost));
        Assert.assertFalse((boolean)infiniteCost.isEqWithEpsilon((RelOptCost)cost1));
        Assert.assertFalse((boolean)infiniteCost.isEqWithEpsilon((RelOptCost)infiniteCost));
    }

    @Test
    public void testLessThan() {
        CostFactory factory = CostFactory.INSTANCE;
        Cost cost = factory.makeCost(1.0, 2.0, 3.0);
        Cost sameCost = factory.makeCost(1.0, 2.0, 3.0);
        Assert.assertFalse((boolean)cost.isLt((RelOptCost)cost));
        Assert.assertFalse((boolean)cost.isLt((RelOptCost)sameCost));
        Assert.assertTrue((boolean)cost.isLe((RelOptCost)cost));
        Assert.assertTrue((boolean)cost.isLe((RelOptCost)sameCost));
        Cost biggerCost = factory.makeCost(4.0, 5.0, 6.0);
        Assert.assertTrue((boolean)cost.isLt((RelOptCost)biggerCost));
        Assert.assertTrue((boolean)cost.isLe((RelOptCost)biggerCost));
        Assert.assertFalse((boolean)biggerCost.isLt((RelOptCost)cost));
        Assert.assertFalse((boolean)biggerCost.isLe((RelOptCost)cost));
        Cost infiniteCost = factory.makeInfiniteCost();
        Assert.assertFalse((boolean)infiniteCost.isLt((RelOptCost)infiniteCost));
        Assert.assertTrue((boolean)infiniteCost.isLe((RelOptCost)infiniteCost));
    }

    @Test
    public void testPlus() {
        CostFactory factory = CostFactory.INSTANCE;
        Cost firstCost = factory.makeCost(1.0, 2.0, 3.0);
        Cost secondCost = factory.makeCost(4.0, 5.0, 6.0);
        Cost infiniteCost = factory.makeInfiniteCost();
        Assert.assertEquals((Object)factory.makeCost(5.0, 7.0, 9.0), (Object)firstCost.plus((RelOptCost)secondCost));
        Assert.assertEquals((Object)infiniteCost, (Object)firstCost.plus((RelOptCost)infiniteCost));
    }

    @Test
    public void testMultiply() {
        CostFactory factory = CostFactory.INSTANCE;
        Cost originalCost = factory.makeCost(1.0, 2.0, 3.0);
        Cost multipliedCost = factory.makeCost(3.0, 6.0, 9.0);
        Assert.assertEquals((Object)multipliedCost, (Object)originalCost.multiplyBy(3.0));
        Cost infiniteCost = factory.makeInfiniteCost();
        Assert.assertEquals((Object)infiniteCost, (Object)infiniteCost.multiplyBy(3.0));
    }

    @Test
    public void testEquals() {
        CostFactory factory = CostFactory.INSTANCE;
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(1.0, 2.0, 3.0), true);
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(10.0, 2.0, 3.0), false);
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(1.0, 10.0, 3.0), false);
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(1.0, Double.POSITIVE_INFINITY, 3.0), false);
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(1.0, 2.0, 10.0), false);
        SqlTestSupport.checkEquals(factory.makeCost(1.0, 2.0, 3.0), factory.makeCost(1.0, 2.0, Double.POSITIVE_INFINITY), false);
    }
}

