/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.opt.common;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.connector.test.TestAbstractSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.jet.sql.impl.opt.OptimizerTestSupport;
import com.hazelcast.jet.sql.impl.opt.logical.DropLateItemsLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.FullScanLogicalRel;
import com.hazelcast.jet.sql.impl.opt.logical.LogicalRel;
import com.hazelcast.jet.sql.impl.schema.HazelcastTable;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.shaded.org.apache.calcite.rel.RelNode;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalCalc;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.shaded.org.apache.calcite.rel.logical.LogicalTableScan;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CalcIntoScanRuleTest
extends OptimizerTestSupport {
    private SqlService sqlService;
    private TableResolverImpl resolver;

    @BeforeClass
    public static void beforeClass() throws Exception {
        CalcIntoScanRuleTest.initialize((int)1, null);
    }

    @Before
    public void before() throws Exception {
        this.sqlService = CalcIntoScanRuleTest.instance().getSql();
        NodeEngineImpl nodeEngine = Util.getNodeEngine((HazelcastInstance)CalcIntoScanRuleTest.instance());
        this.resolver = new TableResolverImpl((NodeEngine)nodeEngine, new RelationsStorage((NodeEngine)nodeEngine), new SqlConnectorCache((NodeEngine)nodeEngine));
    }

    @Test
    public void when_calcPushDownIntoScan_then_mergedFilterWereSimplified() {
        String name = "stream1";
        TestStreamSqlConnector.create(this.sqlService, name, Collections.singletonList("t"), Collections.singletonList(QueryDataTypeFamily.INTEGER), CalcIntoScanRuleTest.row(0), CalcIntoScanRuleTest.row(1), CalcIntoScanRuleTest.row(2));
        String sql = "SELECT * FROM (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE stream1, DESCRIPTOR(t), 1)) WHERE t > 1 AND t = 2)      WHERE t <= 2";
        CalcIntoScanRuleTest.assertInstanceOf(TestAbstractSqlConnector.TestTable.class, this.resolver.getTables().get(0));
        HazelcastTable streamingTable = CalcIntoScanRuleTest.streamingTable((Table)this.resolver.getTables().get(0), 3L);
        CalcIntoScanRuleTest.assertPlan(this.preOptimize(sql, streamingTable), CalcIntoScanRuleTest.plan(CalcIntoScanRuleTest.planRow(0, LogicalCalc.class), CalcIntoScanRuleTest.planRow(1, LogicalTableFunctionScan.class), CalcIntoScanRuleTest.planRow(2, LogicalTableScan.class)));
        LogicalRel logicalRel = this.optimizeLogical(sql, streamingTable);
        CalcIntoScanRuleTest.assertPlan((RelNode)logicalRel, CalcIntoScanRuleTest.plan(CalcIntoScanRuleTest.planRow(0, DropLateItemsLogicalRel.class), CalcIntoScanRuleTest.planRow(1, FullScanLogicalRel.class)));
        FullScanLogicalRel scan = (FullScanLogicalRel)logicalRel.getInput(0);
        CalcIntoScanRuleTest.assertContains((String)scan.toString(), (String)"filter==($0, 2)]");
        CalcIntoScanRuleTest.assertTipOfStream(sql, Collections.singletonList(new SqlTestSupport.Row(2)));
    }
}

