/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.index;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.index.IndexFilterTestSupport;
import com.hazelcast.query.impl.AbstractIndex;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class IndexFilterValueTest {
    @Test
    public void testContent() {
        List<ConstantExpression> components = Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.INT));
        List<Boolean> allowNulls = Collections.singletonList(true);
        IndexFilterValue value = new IndexFilterValue(components, allowNulls);
        Assert.assertSame(components, (Object)value.getComponents());
        Assert.assertSame(allowNulls, (Object)value.getAllowNulls());
    }

    @Test
    public void testEquals() {
        IndexFilterValue value = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.INT)), Collections.singletonList(true));
        SqlTestSupport.checkEquals(value, new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.INT)), Collections.singletonList(true)), true);
        SqlTestSupport.checkEquals(value, new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.BIGINT)), Collections.singletonList(true)), false);
        SqlTestSupport.checkEquals(value, new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.INT)), Collections.singletonList(false)), false);
    }

    @Test
    public void testSerialization() {
        IndexFilterValue original = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.INT)), Collections.singletonList(true));
        IndexFilterValue restored = (IndexFilterValue)SqlTestSupport.serializeAndCheck(original, 27);
        SqlTestSupport.checkEquals(original, restored, true);
    }

    @Test
    public void testValueSimple() {
        ExpressionEvalContext evalContext = SqlTestSupport.createExpressionEvalContext(new Object[0]);
        IndexFilterValue value = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(1, QueryDataType.BIGINT)), Collections.singletonList(true));
        Assert.assertEquals((Object)1L, (Object)value.getValue(evalContext));
        value = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(null, QueryDataType.BIGINT)), Collections.singletonList(true));
        Assert.assertEquals((Object)AbstractIndex.NULL, (Object)value.getValue(evalContext));
        value = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(null, QueryDataType.BIGINT)), Collections.singletonList(false));
        Assert.assertNull((Object)value.getValue(evalContext));
    }

    @Test
    public void testValueComposite() {
        ExpressionEvalContext evalContext = SqlTestSupport.createExpressionEvalContext(new Object[0]);
        IndexFilterValue value = new IndexFilterValue(Arrays.asList(IndexFilterTestSupport.constant(1, QueryDataType.BIGINT), IndexFilterTestSupport.constant("2", QueryDataType.VARCHAR)), Arrays.asList(true, true));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(new Comparable[]{Long.valueOf(1L), "2"}), (Object)value.getValue(evalContext));
        value = new IndexFilterValue(Arrays.asList(IndexFilterTestSupport.constant(null, QueryDataType.BIGINT), IndexFilterTestSupport.constant("2", QueryDataType.VARCHAR)), Arrays.asList(true, true));
        Assert.assertEquals((Object)IndexFilterTestSupport.composite(new Comparable[]{AbstractIndex.NULL, "2"}), (Object)value.getValue(evalContext));
        value = new IndexFilterValue(Arrays.asList(IndexFilterTestSupport.constant(null, QueryDataType.BIGINT), IndexFilterTestSupport.constant("2", QueryDataType.VARCHAR)), Arrays.asList(false, true));
        Assert.assertNull((Object)value.getValue(evalContext));
        value = new IndexFilterValue(Arrays.asList(IndexFilterTestSupport.constant(1L, QueryDataType.BIGINT), IndexFilterTestSupport.constant(null, QueryDataType.VARCHAR)), Arrays.asList(true, false));
        Assert.assertNull((Object)value.getValue(evalContext));
    }

    @Test
    public void testNonComparable() {
        ExpressionEvalContext evalContext = SqlTestSupport.createExpressionEvalContext(new Object[0]);
        IndexFilterValue value = new IndexFilterValue(Collections.singletonList(IndexFilterTestSupport.constant(new Object(), QueryDataType.OBJECT)), Collections.singletonList(true));
        try {
            value.getValue(evalContext);
            Assert.fail((String)"Must fail");
        }
        catch (QueryException e) {
            Assert.assertEquals((long)2000L, (long)e.getCode());
            Assert.assertTrue((boolean)e.getMessage().contains("Values used in index lookups must be Comparable"));
        }
    }
}

