/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.UpperFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class UpperFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Override
    protected String functionName() {
        return "UPPER";
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.VARCHAR;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal(), null);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), "A");
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('A')), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1(""), "");
        this.checkColumn(new ExpressionValue.StringVal().field1("a"), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1("A"), "A");
        this.checkColumn(new ExpressionValue.StringVal().field1("abcde"), "ABCDE");
        this.checkColumn(new ExpressionValue.StringVal().field1("AbCdE"), "ABCDE");
        this.checkColumn(new ExpressionValue.StringVal().field1("ABCDE"), "ABCDE");
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", null);
        this.checkLiteral("''", "");
        this.checkLiteral("'a'", "A");
        this.checkLiteral("'A'", "A");
        this.checkLiteral("'abcde'", "ABCDE");
        this.checkLiteral("'AbCdE'", "ABCDE");
        this.checkLiteral("'ABCDE'", "ABCDE");
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter(Character.valueOf('a'), "A");
        this.checkParameter(Character.valueOf('A'), "A");
        this.checkParameter("", "");
        this.checkParameter("a", "A");
        this.checkParameter("A", "A");
        this.checkParameter("abcde", "ABCDE");
        this.checkParameter("AbCdE", "ABCDE");
        this.checkParameter("ABCDE", "ABCDE");
    }

    @Test
    public void testEquals() {
        UpperFunction function = UpperFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        UpperFunctionIntegrationTest.checkEquals(function, UpperFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR)), true);
        UpperFunctionIntegrationTest.checkEquals(function, UpperFunction.create((Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        UpperFunction original = UpperFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        UpperFunction restored = (UpperFunction)UpperFunctionIntegrationTest.serializeAndCheck(original, 61);
        UpperFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

