/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;

public abstract class StringFunctionIntegrationTestSupport
extends ExpressionTestSupport {
    protected abstract String functionName();

    protected abstract SqlColumnType resultType();

    @Test
    public void testColumn() {
        this.checkSupportedColumns();
        this.checkColumnFailure(new ExpressionValue.BooleanVal().field1(true), SqlColumnType.BOOLEAN);
        this.checkColumnFailure(new ExpressionValue.ByteVal().field1((byte)100), SqlColumnType.TINYINT);
        this.checkColumnFailure(new ExpressionValue.ShortVal().field1((short)100), SqlColumnType.SMALLINT);
        this.checkColumnFailure(new ExpressionValue.IntegerVal().field1(100), SqlColumnType.INTEGER);
        this.checkColumnFailure(new ExpressionValue.LongVal().field1(100L), SqlColumnType.BIGINT);
        this.checkColumnFailure(new ExpressionValue.BigIntegerVal().field1(new BigInteger("100")), SqlColumnType.DECIMAL);
        this.checkColumnFailure(new ExpressionValue.BigDecimalVal().field1(new BigDecimal("100.5")), SqlColumnType.DECIMAL);
        this.checkColumnFailure(new ExpressionValue.FloatVal().field1(Float.valueOf(100.5f)), SqlColumnType.REAL);
        this.checkColumnFailure(new ExpressionValue.DoubleVal().field1(100.5), SqlColumnType.DOUBLE);
        this.checkColumnFailure(new ExpressionValue.LocalDateVal().field1(LOCAL_DATE_VAL), SqlColumnType.DATE);
        this.checkColumnFailure(new ExpressionValue.LocalTimeVal().field1(LOCAL_TIME_VAL), SqlColumnType.TIME);
        this.checkColumnFailure(new ExpressionValue.LocalDateTimeVal().field1(LOCAL_DATE_TIME_VAL), SqlColumnType.TIMESTAMP);
        this.checkColumnFailure(new ExpressionValue.OffsetDateTimeVal().field1(OFFSET_DATE_TIME_VAL), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        this.checkColumnFailure(OBJECT_VAL, SqlColumnType.OBJECT);
    }

    protected abstract void checkSupportedColumns();

    @Test
    public void testLiteral() {
        this.put(1);
        this.checkSupportedLiterals();
        this.checkLiteralFailure("true", SqlColumnType.BOOLEAN);
        this.checkLiteralFailure("1", SqlColumnType.TINYINT);
        this.checkLiteralFailure("1.1", SqlColumnType.DECIMAL);
        this.checkLiteralFailure("1.1E1", SqlColumnType.DOUBLE);
    }

    protected abstract void checkSupportedLiterals();

    @Test
    public void testParameter() {
        this.put(1);
        this.checkSupportedParameters();
        this.checkParameterFailure(true, SqlColumnType.BOOLEAN);
        this.checkParameterFailure((byte)100, SqlColumnType.TINYINT);
        this.checkParameterFailure((short)100, SqlColumnType.SMALLINT);
        this.checkParameterFailure(100, SqlColumnType.INTEGER);
        this.checkParameterFailure(100L, SqlColumnType.BIGINT);
        this.checkParameterFailure(BigInteger.ONE, SqlColumnType.DECIMAL);
        this.checkParameterFailure(BigDecimal.ONE, SqlColumnType.DECIMAL);
        this.checkParameterFailure(Float.valueOf(100.0f), SqlColumnType.REAL);
        this.checkParameterFailure(100.0, SqlColumnType.DOUBLE);
        this.checkParameterFailure(LOCAL_DATE_VAL, SqlColumnType.DATE);
        this.checkParameterFailure(LOCAL_TIME_VAL, SqlColumnType.TIME);
        this.checkParameterFailure(LOCAL_DATE_TIME_VAL, SqlColumnType.TIMESTAMP);
        this.checkParameterFailure(OFFSET_DATE_TIME_VAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        this.checkParameterFailure(OBJECT_VAL, SqlColumnType.OBJECT);
    }

    protected abstract void checkSupportedParameters();

    protected void checkColumn(ExpressionValue value, Object expectedResult) {
        this.put(value);
        String sql = "SELECT " + this.functionName() + "(field1) FROM map";
        this.checkValue0(sql, this.resultType(), expectedResult, new Object[0]);
    }

    private void checkColumnFailure(ExpressionValue value, SqlColumnType typeInErrorMessage) {
        this.put(value);
        String sql = "SELECT " + this.functionName() + "(field1) FROM map";
        this.checkFailure0(sql, 1008, StringFunctionIntegrationTestSupport.signatureErrorFunction(this.functionName(), typeInErrorMessage), new Object[0]);
    }

    protected void checkLiteral(Object operand, Object expectedResult) {
        String sql = "SELECT " + this.functionName() + "(" + String.valueOf(operand) + ") FROM map";
        this.checkValue0(sql, this.resultType(), expectedResult, new Object[0]);
    }

    private void checkLiteralFailure(Object operand, SqlColumnType typeInErrorMessage) {
        String sql = "SELECT " + this.functionName() + "(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, 1008, StringFunctionIntegrationTestSupport.signatureErrorFunction(this.functionName(), typeInErrorMessage), new Object[0]);
    }

    protected void checkParameter(Object param, Object expectedResult) {
        String sql = "SELECT " + this.functionName() + "(?) FROM map";
        this.checkValue0(sql, this.resultType(), expectedResult, param);
    }

    protected void checkParameterFailure(Object param, SqlColumnType typeInErrorMessage) {
        String sql = "SELECT " + this.functionName() + "(?) FROM map";
        this.checkFailure0(sql, 2000, StringFunctionIntegrationTestSupport.parameterError(0, SqlColumnType.VARCHAR, typeInErrorMessage), param);
    }
}

