/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.LowerFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class LowerFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Override
    protected String functionName() {
        return "LOWER";
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.VARCHAR;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal(), null);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), "a");
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('A')), "a");
        this.checkColumn(new ExpressionValue.StringVal().field1(""), "");
        this.checkColumn(new ExpressionValue.StringVal().field1("a"), "a");
        this.checkColumn(new ExpressionValue.StringVal().field1("A"), "a");
        this.checkColumn(new ExpressionValue.StringVal().field1("abcde"), "abcde");
        this.checkColumn(new ExpressionValue.StringVal().field1("AbCdE"), "abcde");
        this.checkColumn(new ExpressionValue.StringVal().field1("ABCDE"), "abcde");
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", null);
        this.checkLiteral("''", "");
        this.checkLiteral("'a'", "a");
        this.checkLiteral("'A'", "a");
        this.checkLiteral("'abcde'", "abcde");
        this.checkLiteral("'AbCdE'", "abcde");
        this.checkLiteral("'ABCDE'", "abcde");
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter(Character.valueOf('a'), "a");
        this.checkParameter(Character.valueOf('A'), "a");
        this.checkParameter("", "");
        this.checkParameter("a", "a");
        this.checkParameter("A", "a");
        this.checkParameter("abcde", "abcde");
        this.checkParameter("AbCdE", "abcde");
        this.checkParameter("ABCDE", "abcde");
    }

    @Test
    public void testEquals() {
        LowerFunction function = LowerFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        LowerFunctionIntegrationTest.checkEquals(function, LowerFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR)), true);
        LowerFunctionIntegrationTest.checkEquals(function, LowerFunction.create((Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        LowerFunction original = LowerFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        LowerFunction restored = (LowerFunction)LowerFunctionIntegrationTest.serializeAndCheck(original, 60);
        LowerFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

