/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.string;

import com.hazelcast.jet.sql.impl.expression.string.StringFunctionIntegrationTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.string.CharLengthFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class CharLengthFunctionIntegrationTest
extends StringFunctionIntegrationTestSupport {
    @Parameterized.Parameter
    public String name;

    @Parameterized.Parameters(name="name: {0}")
    public static Collection<Object[]> parameters() {
        return Arrays.asList({"CHAR_LENGTH"}, {"CHARACTER_LENGTH"}, {"LENGTH"});
    }

    @Override
    protected String functionName() {
        return this.name;
    }

    @Override
    protected SqlColumnType resultType() {
        return SqlColumnType.INTEGER;
    }

    @Override
    protected void checkSupportedColumns() {
        this.checkColumn(new ExpressionValue.CharacterVal().field1(null), null);
        this.checkColumn(new ExpressionValue.CharacterVal().field1(Character.valueOf('a')), 1);
        this.checkColumn(new ExpressionValue.StringVal(), null);
        this.checkColumn(new ExpressionValue.StringVal().field1("abcde"), 5);
        this.checkColumn(new ExpressionValue.StringVal().field1("abcde "), 6);
    }

    @Override
    protected void checkSupportedLiterals() {
        this.checkLiteral("null", null);
        this.checkLiteral("'a'", 1);
        this.checkLiteral("'abcde'", 5);
        this.checkLiteral("'abcde '", 6);
    }

    @Override
    protected void checkSupportedParameters() {
        this.checkParameter(null, null);
        this.checkParameter(Character.valueOf('a'), 1);
        this.checkParameter("abcde", 5);
        this.checkParameter("abcde ", 6);
    }

    @Test
    public void testEquals() {
        CharLengthFunction function = CharLengthFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        CharLengthFunctionIntegrationTest.checkEquals(function, CharLengthFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR)), true);
        CharLengthFunctionIntegrationTest.checkEquals(function, CharLengthFunction.create((Expression)ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.VARCHAR)), false);
    }

    @Test
    public void testSerialization() {
        CharLengthFunction original = CharLengthFunction.create((Expression)ConstantExpression.create((Object)"1", (QueryDataType)QueryDataType.VARCHAR));
        CharLengthFunction restored = (CharLengthFunction)CharLengthFunctionIntegrationTest.serializeAndCheck(original, 58);
        CharLengthFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

