/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.Parameterized;

@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class InOperatorIntegrationTest
extends ExpressionTestSupport {
    protected String longList = "(0, 1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 25, 28, 31, 35)";

    @Test
    public void inPredicateWithDifferentListLengthTest() {
        this.putAll(0, 1, 25, 30);
        this.checkValues(this.sqlQuery("IN (0, 1, 2)"), SqlColumnType.INTEGER, new Integer[]{0, 1}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (?, ?, ?)"), SqlColumnType.INTEGER, new Integer[]{0, 1}, 0, 1, 2);
        this.checkValues(this.sqlQuery("IN " + this.longList), SqlColumnType.INTEGER, new Integer[]{25, 0, 1}, new Object[0]);
        this.checkValues("SELECT this FROM map WHERE NOT (this IN (2, 1))", SqlColumnType.INTEGER, new Integer[]{25, 0, 30}, new Object[0]);
    }

    @Test
    public void notInPredicateWithDifferentListLengthTest() {
        this.putAll(0, 1, 3);
        this.checkValues(this.sqlQuery("NOT IN (0, 1, 2)"), SqlColumnType.INTEGER, new Integer[]{3}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (?, ?, ?)"), SqlColumnType.INTEGER, new Integer[]{3}, 0, 1, 2);
        this.checkValues(this.sqlQuery("NOT IN " + this.longList), SqlColumnType.INTEGER, new Integer[]{3}, new Object[0]);
    }

    @Test
    public void inPredicateWithRawNullTest() {
        this.putAll(0, 1, 2);
        this.checkFailure0(this.sqlQuery("IN (NULL, 0, 1)"), 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (0, NULL, NULL, NULL, 2)"), 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
        this.checkFailure0(this.sqlQuery("NOT IN (NULL, 1)"), 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
        this.checkFailure0(this.sqlQuery("NOT IN (0, NULL, NULL, NULL, 2)"), 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
        this.checkFailure0("SELECT this FROM map WHERE NOT (this IN (NULL, 2, 1, 0))", 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
        this.checkFailure0("SELECT this FROM map WHERE true <> (this IN (NULL, 2, 1, 0))", 1008, "Raw nulls are not supported for IN operator.", new Object[0]);
    }

    @Test
    public void inPredicateWithSubQueryTest() {
        String expectedExMessage = "Sub-queries are not supported for IN operator.";
        this.putAll(1, 2);
        this.checkFailure0(this.sqlQuery("IN (SELECT __key FROM map)"), 1008, expectedExMessage, new Object[0]);
        this.checkFailure0(this.sqlQuery("NOT IN (SELECT __key FROM map)"), 1008, expectedExMessage, new Object[0]);
    }

    @Test
    public void inPredicateLongNumericTypeTest() {
        this.putAll(0L, 1L, 0x7FFFFFFFFFFFFFFEL);
        this.checkValues(this.sqlQuery("IN (0, 1, 2)"), SqlColumnType.BIGINT, new Long[]{0L, 1L}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (0, 1, 2)"), SqlColumnType.BIGINT, new Long[]{0x7FFFFFFFFFFFFFFEL}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (CAST ('0' AS INTEGER), CAST ('1' AS INTEGER), 2)"), SqlColumnType.BIGINT, new Long[]{0L, 1L}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (CAST ('0' AS INTEGER), CAST ('1' AS INTEGER), 2)"), SqlColumnType.BIGINT, new Long[]{0x7FFFFFFFFFFFFFFEL}, new Object[0]);
    }

    @Test
    public void inPredicateNumericTypesTest() {
        this.putAll(0, 1, 127, 32766);
        this.checkValues(this.sqlQuery("IN (0, 1, 2)"), SqlColumnType.INTEGER, new Integer[]{0, 1}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (0, 1, 2)"), SqlColumnType.INTEGER, new Integer[]{127, 32766}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (CAST ('0' AS INTEGER), CAST ('1' AS TINYINT), 2)"), SqlColumnType.INTEGER, new Integer[]{0, 1}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (CAST ('0' AS INTEGER), CAST ('1' AS INTEGER), 2, (CAST (32766 AS SMALLINT)))"), SqlColumnType.INTEGER, new Integer[]{127}, new Object[0]);
        this.checkFailure0(this.sqlQuery("IN ('abc', 'bac')"), 1008, "CAST function cannot convert literal 'abc' to type INTEGER: Cannot parse VARCHAR value to INTEGER", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (FALSE, TRUE)"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST ('1970-01-01' AS DATE))"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST ('00:00:00' AS TIME))"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
    }

    @Test
    public void inPredicateStringTypeTest() {
        this.putAll("abc", "bac", "cba", "20");
        this.checkValues(this.sqlQuery("IN ('abc', 'cba')"), SqlColumnType.VARCHAR, new String[]{"cba", "abc"}, new Object[0]);
        this.checkValues(this.sqlQuery("IN ('abc', 'cba', 'bac')"), SqlColumnType.VARCHAR, new String[]{"cba", "abc", "bac"}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN ('abc', '1', 'cba')"), SqlColumnType.VARCHAR, new String[]{"bac", "20"}, new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (1)"), 2000, "Cannot parse VARCHAR value to TINYINT", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (128)"), 2000, "Cannot parse VARCHAR value to SMALLINT", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST('00:00:00' AS TIME))"), 2000, "Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST('2020-01-01' AS DATE))"), 2000, "Cannot parse VARCHAR value to DATE", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST('2020-01-01T14:01' AS TIMESTAMP))"), 2000, "Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST('2020-01-01T14:01+02:00' AS TIMESTAMP WITH TIME ZONE))"), 2000, "Cannot parse VARCHAR value to TIMESTAMP WITH TIME ZONE", new Object[0]);
        this.putAll("1", "2", "3");
        this.checkValues(this.sqlQuery("IN (1, 3, 4)"), SqlColumnType.VARCHAR, new String[]{"3", "1"}, new Object[0]);
        this.putAll("1", "2", "3", "129");
        this.checkValues(this.sqlQuery("IN (0, 3, 129)"), SqlColumnType.VARCHAR, new String[]{"3", "129"}, new Object[0]);
        this.putAll("01:00", "01:01", "01:02");
        this.checkValues(this.sqlQuery("IN (CAST('01:01' AS TIME), CAST('01:04' AS TIME))"), SqlColumnType.VARCHAR, new String[]{"01:01"}, new Object[0]);
        this.putAll("2021-01-01", "2021-01-02", "2021-01-03");
        this.checkValues(this.sqlQuery("IN (CAST('2021-01-02' AS DATE), CAST('2021-01-03' AS DATE), CAST('2021-01-04' AS DATE))"), SqlColumnType.VARCHAR, new String[]{"2021-01-02", "2021-01-03"}, new Object[0]);
        this.putAll("2021-01-01T01:01", "2021-01-02T01:01");
        this.checkValues(this.sqlQuery("IN (CAST('2021-01-02T01:01' AS TIMESTAMP), CAST('2021-01-03T01:01' AS TIMESTAMP))"), SqlColumnType.VARCHAR, new String[]{"2021-01-02T01:01"}, new Object[0]);
        this.putAll("2021-01-01T01:01+01:00", "2021-01-02T01:01+01:00");
        this.checkValues(this.sqlQuery("IN (CAST('2021-01-02T01:01+01:00' AS TIMESTAMP WITH TIME ZONE), CAST('2021-01-03T01:01+01:00' AS TIMESTAMP WITH TIME ZONE))"), SqlColumnType.VARCHAR, new String[]{"2021-01-02T01:01+01:00"}, new Object[0]);
    }

    @Test
    public void inPredicateDatesTest() {
        LocalDate date1 = LocalDate.of(1970, 1, 1);
        LocalDate date2 = LocalDate.of(1970, 1, 3);
        this.putAll(date1, date2);
        this.checkValues(this.sqlQuery("IN (CAST ('1970-01-01' AS DATE), CAST ('1970-01-03' AS DATE))"), SqlColumnType.DATE, new LocalDate[]{date1, date2}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (CAST ('1970-01-01' AS DATE), CAST ('1970-01-02' AS DATE))"), SqlColumnType.DATE, new LocalDate[]{date1}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (CAST ('1970-01-01' AS DATE), CAST ('1970-01-02' AS DATE))"), SqlColumnType.DATE, new LocalDate[]{date2}, new Object[0]);
        this.checkFailure0(this.sqlQuery("IN ('abc', 'bac')"), 1008, "CAST function cannot convert literal 'abc' to type DATE: Cannot parse VARCHAR value to DATE", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (2, 3)"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (TRUE, FALSE)"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
    }

    @Test
    public void inPredicateTimeTest() {
        LocalTime time1 = LocalTime.of(0, 0, 0);
        LocalTime time2 = LocalTime.of(0, 0, 2);
        this.putAll(time1, time2);
        this.checkValues(this.sqlQuery("IN (CAST('00:00:00' AS TIME), CAST('00:00:02' AS TIME))"), SqlColumnType.TIME, new LocalTime[]{time1, time2}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (CAST('00:00:00' AS TIME), CAST('00:00:01' AS TIME))"), SqlColumnType.TIME, new LocalTime[]{time1}, new Object[0]);
        this.checkValues(this.sqlQuery("NOT IN (CAST('00:00:00' AS TIME))"), SqlColumnType.TIME, new LocalTime[]{time2}, new Object[0]);
        this.checkFailure0(this.sqlQuery("IN ('abc', 'bac')"), 1008, "CAST function cannot convert literal 'abc' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (1)"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST('1970-01-01' AS DATE))"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("NOT IN (0, 1)"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN (CAST ('1970-01-01' AS DATE), 1, CAST ('00:00:02' AS TIME))"), 1008, "Values passed to IN operator must have compatible types", new Object[0]);
    }

    @Test
    public void test_mixedTypesInTheInList() {
        this.putAll(true);
        this.checkFailure0(this.sqlQuery("IN (1, 'abc')"), 1008, "Values in expression list must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN ('abc', 1)"), 1008, "Values in expression list must have compatible types", new Object[0]);
        this.checkFailure0(this.sqlQuery("IN ('abc', CAST('00:00:00' AS TIME))"), 1008, "Values in expression list must have compatible types", new Object[0]);
        this.putAll("1", "2");
        this.checkValues(this.sqlQuery("IN (1, 194919940239)"), SqlColumnType.VARCHAR, new String[]{"1"}, new Object[0]);
        this.checkValues(this.sqlQuery("IN (cast(1.0 as REAL), cast(2.3 as DOUBLE))"), SqlColumnType.VARCHAR, new String[]{"1"}, new Object[0]);
        this.putAll(LocalDateTime.of(2021, 1, 2, 0, 0, 0).atZone(ZoneId.systemDefault()).toOffsetDateTime().toString(), "2021-01-02T01:03:04+01:00");
        this.checkValues(this.sqlQuery("NOT IN (CAST('2021-01-02' AS DATE), CAST('2021-01-02T01:03:04+01:00' AS TIMESTAMP WITH TIME ZONE))"), SqlColumnType.VARCHAR, new String[0], new Object[0]);
        this.putAll("2021-01-02T00:00:00+12:00", "2021-01-02T01:03:04+01:00");
        this.checkValues(this.sqlQuery("NOT IN (CAST('2021-01-02' AS DATE), CAST('2021-01-02T01:03:04+01:00' AS TIMESTAMP WITH TIME ZONE))"), SqlColumnType.VARCHAR, new String[]{"2021-01-02T00:00:00+12:00"}, new Object[0]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> InOperatorIntegrationTest.execute(this.sqlQuery("IN (3, CAST('1970-01-01' AS DATE))"), new Object[0])).isInstanceOf(AssertionError.class)).hasMessage(null);
    }

    @Ignore(value="Support ROW().")
    @Test
    public void inPredicateRowsTest() {
        this.putAll(0, 1);
        String inClause = "IN (ROW(0, 0), ROW(1, 1), ROW(2, 2))";
    }

    protected void checkValues(String sql, SqlColumnType expectedType, Object[] expectedResults, Object ... params) {
        List<SqlRow> rows = InOperatorIntegrationTest.execute(sql, params);
        Assert.assertTrue((boolean)rows.stream().allMatch(row -> row.getMetadata().getColumn(0).getType() == expectedType));
        List rowValues = rows.stream().map(row -> row.getObject(0)).collect(Collectors.toList());
        Assertions.assertThat(rowValues).containsExactlyInAnyOrderElementsOf(Arrays.asList(expectedResults));
    }

    private String sqlQuery(String inClause) {
        return "SELECT this FROM map WHERE this " + inClause;
    }
}

