/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.predicate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.predicate.ComparisonMode;
import com.hazelcast.sql.impl.expression.predicate.ComparisonPredicate;
import com.hazelcast.sql.impl.row.HeapRow;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ComparisonPredicateTest {
    @Test
    public void testCreationAndEval() {
        Assert.assertFalse((boolean)ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS).eval(ComparisonPredicateTest.heapRow("foo"), SqlTestSupport.createExpressionEvalContext(new Object[0])));
        Assert.assertTrue((boolean)ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.LESS_THAN).eval(ComparisonPredicateTest.heapRow("foo"), SqlTestSupport.createExpressionEvalContext(new Object[0])));
    }

    @Test
    public void testEquality() {
        SqlTestSupport.checkEquals(ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), true);
        SqlTestSupport.checkEquals(ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.GREATER_THAN), false);
        SqlTestSupport.checkEquals(ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), ComparisonPredicateTest.comparison(0, 1, QueryDataType.BIGINT, ComparisonMode.EQUALS), false);
        SqlTestSupport.checkEquals(ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), ComparisonPredicateTest.comparison(1, 1, QueryDataType.INT, ComparisonMode.EQUALS), false);
        SqlTestSupport.checkEquals(ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS), ComparisonPredicateTest.comparison(1, 0, QueryDataType.INT, ComparisonMode.EQUALS), false);
    }

    @Test
    public void testSerialization() {
        ComparisonPredicate original = ComparisonPredicateTest.comparison(0, 1, QueryDataType.INT, ComparisonMode.EQUALS);
        ComparisonPredicate restored = (ComparisonPredicate)SqlTestSupport.serializeAndCheck(original, 45);
        SqlTestSupport.checkEquals(original, restored, true);
    }

    private static Row heapRow(Object ... values) {
        Assert.assertNotNull((Object)values);
        Assert.assertTrue((values.length > 0 ? 1 : 0) != 0);
        return new HeapRow(values);
    }

    private static ComparisonPredicate comparison(Object lhs, Object rhs, QueryDataType type, ComparisonMode mode) {
        return ComparisonPredicate.create((Expression)ConstantExpression.create((Object)lhs, (QueryDataType)type), (Expression)ConstantExpression.create((Object)rhs, (QueryDataType)type), (ComparisonMode)mode);
    }
}

