/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.UnaryMinusFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class UnaryMinusIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testColumn() {
        this.putAndCheckValue(new ExpressionValue.IntegerVal(), UnaryMinusIntegrationTest.sql("field1"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)0, new Object[0]);
        this.putAndCheckValue((byte)1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)-1, new Object[0]);
        this.putAndCheckValue((byte)-1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)1, new Object[0]);
        this.putAndCheckValue((byte)127, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)-127, new Object[0]);
        this.putAndCheckValue((byte)-128, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.SMALLINT, (short)128, new Object[0]);
        this.putAndCheckValue((short)0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.INTEGER, 0, new Object[0]);
        this.putAndCheckValue((short)1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.INTEGER, -1, new Object[0]);
        this.putAndCheckValue((short)-1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.INTEGER, 1, new Object[0]);
        this.putAndCheckValue((short)Short.MAX_VALUE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.INTEGER, -32767, new Object[0]);
        this.putAndCheckValue((short)Short.MIN_VALUE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.INTEGER, 32768, new Object[0]);
        this.putAndCheckValue(0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, -1L, new Object[0]);
        this.putAndCheckValue(-1, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(Integer.MAX_VALUE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, -2147483647L, new Object[0]);
        this.putAndCheckValue(Integer.MIN_VALUE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 0x80000000L, new Object[0]);
        this.putAndCheckValue(0L, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 0L, new Object[0]);
        this.putAndCheckValue(1L, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, -1L, new Object[0]);
        this.putAndCheckValue(-1L, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, 1L, new Object[0]);
        this.putAndCheckValue(Long.MAX_VALUE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.BIGINT, -9223372036854775807L, new Object[0]);
        this.putAndCheckFailure(Long.MIN_VALUE, UnaryMinusIntegrationTest.sql("this"), 2000, "BIGINT overflow in unary '-' operator", new Object[0]);
        this.putAndCheckValue(BigInteger.ONE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE.negate(), new Object[0]);
        this.putAndCheckValue(BigDecimal.ONE, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DECIMAL, BigDecimal.ONE.negate(), new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), UnaryMinusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(-0.0f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(-0.0f), UnaryMinusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(0.0f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(1.0f), UnaryMinusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(-1.0f), new Object[0]);
        this.putAndCheckValue(Float.valueOf(-1.0f), UnaryMinusIntegrationTest.sql("this"), SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.putAndCheckValue(0.0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, -0.0, new Object[0]);
        this.putAndCheckValue(-0.0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, 0.0, new Object[0]);
        this.putAndCheckValue(1.0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, -1.0, new Object[0]);
        this.putAndCheckValue(-1.0, UnaryMinusIntegrationTest.sql("this"), SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.putAndCheckFailure("foo", UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.putAndCheckFailure(true, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_VAL, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(LOCAL_TIME_VAL, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(LOCAL_DATE_TIME_VAL, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(OFFSET_DATE_TIME_VAL, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(OBJECT_VAL, UnaryMinusIntegrationTest.sql("this"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.OBJECT), new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(1);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), Character.valueOf('f'));
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkValue0(UnaryMinusIntegrationTest.sql("?"), SqlColumnType.BIGINT, -1L, (byte)1);
        this.checkValue0(UnaryMinusIntegrationTest.sql("?"), SqlColumnType.BIGINT, -1L, (short)1);
        this.checkValue0(UnaryMinusIntegrationTest.sql("?"), SqlColumnType.BIGINT, -1L, 1);
        this.checkValue0(UnaryMinusIntegrationTest.sql("?"), SqlColumnType.BIGINT, -1L, 1L);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ONE);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ONE);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("?"), 2000, UnaryMinusIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testLiteral() {
        this.put(1);
        this.checkValue0(UnaryMinusIntegrationTest.sql("null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0(UnaryMinusIntegrationTest.sql("1"), SqlColumnType.TINYINT, (byte)-1, new Object[0]);
        this.checkValue0(UnaryMinusIntegrationTest.sql("1.1"), SqlColumnType.DECIMAL, new BigDecimal("-1.1"), new Object[0]);
        this.checkValue0(UnaryMinusIntegrationTest.sql("1.1E0"), SqlColumnType.DOUBLE, -1.1, new Object[0]);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("'foo'"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure0(UnaryMinusIntegrationTest.sql("true"), 1008, UnaryMinusIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
    }

    @Test
    public void testEquality() {
        UnaryMinusIntegrationTest.checkEquals(UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        UnaryMinusIntegrationTest.checkEquals(UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        UnaryMinusIntegrationTest.checkEquals(UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
    }

    @Test
    public void testSerialization() {
        UnaryMinusFunction original = UnaryMinusFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        UnaryMinusFunction restored = (UnaryMinusFunction)UnaryMinusIntegrationTest.serializeAndCheck(original, 41);
        UnaryMinusIntegrationTest.checkEquals(original, restored, true);
    }

    private static String signatureError(SqlColumnType type) {
        return UnaryMinusIntegrationTest.signatureErrorOperator("-", type);
    }

    private static String sql(String attribute) {
        return "SELECT -" + attribute + " FROM map";
    }
}

