/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.RoundTruncateFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RoundTruncateFunctionTest {
    @Test
    public void testEquals() {
        ConstantExpression const1 = ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT);
        ConstantExpression const2 = ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT);
        ConstantExpression constOther = ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT);
        Expression function = RoundTruncateFunction.create((Expression)const1, (Expression)const2, (QueryDataType)QueryDataType.INT, (boolean)true);
        SqlTestSupport.checkEquals(function, RoundTruncateFunction.create((Expression)const1, (Expression)const2, (QueryDataType)QueryDataType.INT, (boolean)true), true);
        SqlTestSupport.checkEquals(function, RoundTruncateFunction.create((Expression)constOther, (Expression)const2, (QueryDataType)QueryDataType.INT, (boolean)true), false);
        SqlTestSupport.checkEquals(function, RoundTruncateFunction.create((Expression)const1, (Expression)constOther, (QueryDataType)QueryDataType.INT, (boolean)true), false);
        SqlTestSupport.checkEquals(function, RoundTruncateFunction.create((Expression)const1, (Expression)const2, (QueryDataType)QueryDataType.BIGINT, (boolean)true), false);
        SqlTestSupport.checkEquals(function, RoundTruncateFunction.create((Expression)const1, (Expression)const2, (QueryDataType)QueryDataType.INT, (boolean)false), false);
    }

    @Test
    public void testSerialization() {
        ConstantExpression const1 = ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT);
        ConstantExpression const2 = ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT);
        Expression original = RoundTruncateFunction.create((Expression)const1, (Expression)const2, (QueryDataType)QueryDataType.DECIMAL, (boolean)true);
        RoundTruncateFunction restored = (RoundTruncateFunction)SqlTestSupport.serializeAndCheck(original, 56);
        SqlTestSupport.checkEquals(original, restored, true);
    }

    @Test
    public void testSimplification() {
        this.checkSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.TINYINT), null, (QueryDataType)QueryDataType.TINYINT, (boolean)true));
        this.checkSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.SMALLINT), null, (QueryDataType)QueryDataType.SMALLINT, (boolean)true));
        this.checkSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.INT), null, (QueryDataType)QueryDataType.INT, (boolean)true));
        this.checkSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.BIGINT), null, (QueryDataType)QueryDataType.BIGINT, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DECIMAL), null, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.REAL), null, (QueryDataType)QueryDataType.REAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DOUBLE), null, (QueryDataType)QueryDataType.DOUBLE, (boolean)true));
        ConstantExpression len = ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT);
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.TINYINT), (Expression)len, (QueryDataType)QueryDataType.TINYINT, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.SMALLINT), (Expression)len, (QueryDataType)QueryDataType.SMALLINT, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.INT), (Expression)len, (QueryDataType)QueryDataType.INT, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.BIGINT), (Expression)len, (QueryDataType)QueryDataType.BIGINT, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DECIMAL), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.REAL), (Expression)len, (QueryDataType)QueryDataType.REAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DOUBLE), (Expression)len, (QueryDataType)QueryDataType.DOUBLE, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.TINYINT), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.SMALLINT), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.INT), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.BIGINT), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DECIMAL), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.REAL), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.DOUBLE), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
        this.checkNotSimplified(RoundTruncateFunction.create((Expression)ConstantExpression.create(null, (QueryDataType)QueryDataType.VARCHAR), (Expression)len, (QueryDataType)QueryDataType.DECIMAL, (boolean)true));
    }

    private void checkNotSimplified(Expression<?> expression) {
        Assert.assertEquals(RoundTruncateFunction.class, expression.getClass());
    }

    private void checkSimplified(Expression<?> expression) {
        Assert.assertEquals(ConstantExpression.class, expression.getClass());
    }
}

