/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RoundFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void test_byte() {
        this.checkColumn_1(new ExpressionValue.ByteVal().field1((byte)127), SqlColumnType.TINYINT, (byte)127);
        this.checkColumn_1(new ExpressionValue.ByteVal().field1((byte)-128), SqlColumnType.TINYINT, (byte)-128);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, 1), SqlColumnType.TINYINT, (byte)127);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, 0), SqlColumnType.TINYINT, (byte)127);
        this.checkColumnFailure_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, -1), 2000, "TINYINT overflow in ROUND function (consider adding an explicit CAST to SMALLINT)");
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, -2), SqlColumnType.TINYINT, (byte)100);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, -3), SqlColumnType.TINYINT, (byte)0);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)127, -4), SqlColumnType.TINYINT, (byte)0);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, 1), SqlColumnType.TINYINT, (byte)-128);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, 0), SqlColumnType.TINYINT, (byte)-128);
        this.checkColumnFailure_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, -1), 2000, "TINYINT overflow in ROUND function (consider adding an explicit CAST to SMALLINT)");
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, -2), SqlColumnType.TINYINT, (byte)-100);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, -3), SqlColumnType.TINYINT, (byte)0);
        this.checkColumn_2(new ExpressionBiValue.ByteIntegerVal().fields((byte)-128, -4), SqlColumnType.TINYINT, (byte)0);
    }

    @Test
    public void test_short() {
        this.checkColumn_1(new ExpressionValue.ShortVal().field1((short)Short.MAX_VALUE), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE);
        this.checkColumn_1(new ExpressionValue.ShortVal().field1((short)Short.MIN_VALUE), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, 1), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, 0), SqlColumnType.SMALLINT, (short)Short.MAX_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, -1), 2000, "SMALLINT overflow in ROUND function (consider adding an explicit CAST to INTEGER)");
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, -4), SqlColumnType.SMALLINT, (short)30000);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, -5), SqlColumnType.SMALLINT, (short)0);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MAX_VALUE, -6), SqlColumnType.SMALLINT, (short)0);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, 1), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, 0), SqlColumnType.SMALLINT, (short)Short.MIN_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, -1), 2000, "SMALLINT overflow in ROUND function (consider adding an explicit CAST to INTEGER)");
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, -4), SqlColumnType.SMALLINT, (short)-30000);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, -5), SqlColumnType.SMALLINT, (short)0);
        this.checkColumn_2(new ExpressionBiValue.ShortIntegerVal().fields((short)Short.MIN_VALUE, -6), SqlColumnType.SMALLINT, (short)0);
    }

    @Test
    public void test_int() {
        this.checkColumn_1(new ExpressionValue.IntegerVal().field1(Integer.MAX_VALUE), SqlColumnType.INTEGER, Integer.MAX_VALUE);
        this.checkColumn_1(new ExpressionValue.IntegerVal().field1(Integer.MIN_VALUE), SqlColumnType.INTEGER, Integer.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, 1), SqlColumnType.INTEGER, Integer.MAX_VALUE);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, 0), SqlColumnType.INTEGER, Integer.MAX_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -1), 2000, "INTEGER overflow in ROUND function (consider adding an explicit CAST to BIGINT)");
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -2), SqlColumnType.INTEGER, 2147483600);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -10), SqlColumnType.INTEGER, 0);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -11), SqlColumnType.INTEGER, 0);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MIN_VALUE, 1), SqlColumnType.INTEGER, Integer.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MIN_VALUE, 0), SqlColumnType.INTEGER, Integer.MIN_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MIN_VALUE, -1), 2000, "INTEGER overflow in ROUND function (consider adding an explicit CAST to BIGINT)");
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MIN_VALUE, -2), SqlColumnType.INTEGER, -2147483600);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -10), SqlColumnType.INTEGER, 0);
        this.checkColumn_2(new ExpressionBiValue.IntegerIntegerVal().fields(Integer.MAX_VALUE, -11), SqlColumnType.INTEGER, 0);
    }

    @Test
    public void test_long() {
        this.checkColumn_1(new ExpressionValue.LongVal().field1(Long.MAX_VALUE), SqlColumnType.BIGINT, Long.MAX_VALUE);
        this.checkColumn_1(new ExpressionValue.LongVal().field1(Long.MIN_VALUE), SqlColumnType.BIGINT, Long.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, 1), SqlColumnType.BIGINT, Long.MAX_VALUE);
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, 0), SqlColumnType.BIGINT, Long.MAX_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, -1), 2000, "BIGINT overflow in ROUND function (consider adding an explicit CAST to DECIMAL)");
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, -2), SqlColumnType.BIGINT, 0x7FFFFFFFFFFFFFF8L);
        this.checkColumnFailure_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, -19), 2000, "BIGINT overflow in ROUND function (consider adding an explicit CAST to DECIMAL)");
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MAX_VALUE, -20), SqlColumnType.BIGINT, 0L);
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, 1), SqlColumnType.BIGINT, Long.MIN_VALUE);
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, 0), SqlColumnType.BIGINT, Long.MIN_VALUE);
        this.checkColumnFailure_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, -1), 2000, "BIGINT overflow in ROUND function (consider adding an explicit CAST to DECIMAL)");
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, -2), SqlColumnType.BIGINT, -9223372036854775800L);
        this.checkColumnFailure_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, -19), 2000, "BIGINT overflow in ROUND function (consider adding an explicit CAST to DECIMAL)");
        this.checkColumn_2(new ExpressionBiValue.LongIntegerVal().fields(Long.MIN_VALUE, -20), SqlColumnType.BIGINT, 0L);
    }

    @Test
    public void test_BigInteger() {
        this.checkColumn_1(new ExpressionValue.BigIntegerVal().field1(new BigInteger("15")), SqlColumnType.DECIMAL, new BigDecimal("15"));
        this.checkColumn_1(new ExpressionValue.BigIntegerVal().field1(new BigInteger("-15")), SqlColumnType.DECIMAL, new BigDecimal("-15"));
        this.checkColumn_2(new ExpressionBiValue.BigIntegerIntegerVal().fields(new BigInteger("15"), -1), SqlColumnType.DECIMAL, new BigDecimal("20"));
        this.checkColumn_2(new ExpressionBiValue.BigIntegerIntegerVal().fields(new BigInteger("15"), -2), SqlColumnType.DECIMAL, new BigDecimal("0"));
        this.checkColumn_2(new ExpressionBiValue.BigIntegerIntegerVal().fields(new BigInteger("-15"), -1), SqlColumnType.DECIMAL, new BigDecimal("-20"));
        this.checkColumn_2(new ExpressionBiValue.BigIntegerIntegerVal().fields(new BigInteger("-15"), -2), SqlColumnType.DECIMAL, new BigDecimal("0"));
    }

    @Test
    public void test_BigDecimal() {
        this.checkColumn_1(new ExpressionValue.BigDecimalVal().field1(new BigDecimal("15.4")), SqlColumnType.DECIMAL, new BigDecimal("15"));
        this.checkColumn_1(new ExpressionValue.BigDecimalVal().field1(new BigDecimal("15.5")), SqlColumnType.DECIMAL, new BigDecimal("16"));
        this.checkColumn_1(new ExpressionValue.BigDecimalVal().field1(new BigDecimal("-15.4")), SqlColumnType.DECIMAL, new BigDecimal("-15"));
        this.checkColumn_1(new ExpressionValue.BigDecimalVal().field1(new BigDecimal("-15.5")), SqlColumnType.DECIMAL, new BigDecimal("-16"));
        this.checkColumn_2(new ExpressionBiValue.BigDecimalIntegerVal().fields(new BigDecimal("15.5"), -1), SqlColumnType.DECIMAL, new BigDecimal("20"));
        this.checkColumn_2(new ExpressionBiValue.BigDecimalIntegerVal().fields(new BigDecimal("15.5"), -2), SqlColumnType.DECIMAL, new BigDecimal("0"));
        this.checkColumn_2(new ExpressionBiValue.BigDecimalIntegerVal().fields(new BigDecimal("-15.5"), -1), SqlColumnType.DECIMAL, new BigDecimal("-20"));
        this.checkColumn_2(new ExpressionBiValue.BigDecimalIntegerVal().fields(new BigDecimal("-15.5"), -2), SqlColumnType.DECIMAL, new BigDecimal("0"));
    }

    @Test
    public void test_float() {
        this.checkColumn_1(new ExpressionValue.FloatVal().field1(Float.valueOf(15.4f)), SqlColumnType.REAL, Float.valueOf(15.0f));
        this.checkColumn_1(new ExpressionValue.FloatVal().field1(Float.valueOf(15.5f)), SqlColumnType.REAL, Float.valueOf(16.0f));
        this.checkColumn_1(new ExpressionValue.FloatVal().field1(Float.valueOf(-15.4f)), SqlColumnType.REAL, Float.valueOf(-15.0f));
        this.checkColumn_1(new ExpressionValue.FloatVal().field1(Float.valueOf(-15.5f)), SqlColumnType.REAL, Float.valueOf(-16.0f));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(15.5f), -1), SqlColumnType.REAL, Float.valueOf(20.0f));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(15.5f), -2), SqlColumnType.REAL, Float.valueOf(0.0f));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(-15.5f), -1), SqlColumnType.REAL, Float.valueOf(-20.0f));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(-15.5f), -2), SqlColumnType.REAL, Float.valueOf(0.0f));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(Float.POSITIVE_INFINITY), -1), SqlColumnType.REAL, Float.valueOf(Float.POSITIVE_INFINITY));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(Float.NEGATIVE_INFINITY), -1), SqlColumnType.REAL, Float.valueOf(Float.NEGATIVE_INFINITY));
        this.checkColumn_2(new ExpressionBiValue.FloatIntegerVal().fields(Float.valueOf(Float.NaN), -1), SqlColumnType.REAL, Float.valueOf(Float.NaN));
    }

    @Test
    public void test_double() {
        this.checkColumn_1(new ExpressionValue.DoubleVal().field1(15.4), SqlColumnType.DOUBLE, 15.0);
        this.checkColumn_1(new ExpressionValue.DoubleVal().field1(15.5), SqlColumnType.DOUBLE, 16.0);
        this.checkColumn_1(new ExpressionValue.DoubleVal().field1(-15.4), SqlColumnType.DOUBLE, -15.0);
        this.checkColumn_1(new ExpressionValue.DoubleVal().field1(-15.5), SqlColumnType.DOUBLE, -16.0);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(15.5, -1), SqlColumnType.DOUBLE, 20.0);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(15.5, -2), SqlColumnType.DOUBLE, 0.0);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(-15.5, -1), SqlColumnType.DOUBLE, -20.0);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(-15.5, -2), SqlColumnType.DOUBLE, 0.0);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(Double.POSITIVE_INFINITY, -1), SqlColumnType.DOUBLE, Double.POSITIVE_INFINITY);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(Double.NEGATIVE_INFINITY, -1), SqlColumnType.DOUBLE, Double.NEGATIVE_INFINITY);
        this.checkColumn_2(new ExpressionBiValue.DoubleIntegerVal().fields(Double.NaN, -1), SqlColumnType.DOUBLE, Double.NaN);
    }

    @Test
    public void test_boolean() {
        this.checkColumnFailure_2(new ExpressionBiValue.BooleanIntegerVal().fields(true, 127), 1008, this.signatureErorr(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER));
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerBooleanVal().fields(127, true), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.BOOLEAN));
    }

    @Test
    public void test_temporal() {
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerLocalDateVal().fields(127, LOCAL_DATE_VAL), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.DATE));
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerLocalTimeVal().fields(127, LOCAL_TIME_VAL), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.TIME));
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerLocalDateTimeVal().fields(127, LOCAL_DATE_TIME_VAL), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP));
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerOffsetDateTimeVal().fields(127, OFFSET_DATE_TIME_VAL), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
    }

    @Test
    public void test_object() {
        this.checkColumnFailure_2(new ExpressionBiValue.IntegerObjectVal().fields(127, "bad"), 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.OBJECT));
    }

    @Test
    public void testParameters() {
        this.put(new ExpressionValue.IntegerVal().field1(0));
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), (byte)10);
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), (short)10);
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), 10);
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), 10L);
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), new BigInteger("10"));
        this.check_1("?", SqlColumnType.DECIMAL, new BigDecimal("10"), new BigDecimal("9.5"));
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(9.5f));
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 9.5);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "9.5d");
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
        this.checkFailure_1("?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), (byte)10);
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), (short)10);
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), 10);
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), 10L);
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), new BigInteger("10"));
        this.check_2("?", "0", SqlColumnType.DECIMAL, new BigDecimal("10"), new BigDecimal("9.5"));
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(9.5f));
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 9.5);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "9.5");
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
        this.checkFailure_2("?", "0", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.check_2("15", "?", SqlColumnType.TINYINT, (byte)20, (byte)-1);
        this.check_2("15", "?", SqlColumnType.TINYINT, (byte)20, (short)-1);
        this.check_2("15", "?", SqlColumnType.TINYINT, (byte)20, -1);
        this.check_2("15", "?", SqlColumnType.TINYINT, (byte)20, -1L);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigInteger.ONE.negate());
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DECIMAL), BigDecimal.ONE.negate());
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.VARCHAR), "-1");
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.OBJECT), OBJECT_VAL);
        this.checkFailure_2("15", "?", 2000, RoundFunctionIntegrationTest.parameterError(0, SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), true);
        this.check_2("?", "?", SqlColumnType.DECIMAL, new BigDecimal("20"), 15, -1);
    }

    @Test
    public void testLiterals() {
        this.put(new ExpressionValue.IntegerVal().field1(0));
        this.check_1("null", SqlColumnType.DECIMAL, null, new Object[0]);
        this.check_1("15.1", SqlColumnType.DECIMAL, new BigDecimal("15"), new Object[0]);
        this.check_1("15.5", SqlColumnType.DECIMAL, new BigDecimal("16"), new Object[0]);
        this.check_1("-15.1", SqlColumnType.DECIMAL, new BigDecimal("-15"), new Object[0]);
        this.check_1("-15.5", SqlColumnType.DECIMAL, new BigDecimal("-16"), new Object[0]);
        this.check_1("15.1E0", SqlColumnType.DOUBLE, 15.0, new Object[0]);
        this.check_1("15.5E0", SqlColumnType.DOUBLE, 16.0, new Object[0]);
        this.check_1("-15.1E0", SqlColumnType.DOUBLE, -15.0, new Object[0]);
        this.check_1("-15.5E0", SqlColumnType.DOUBLE, -16.0, new Object[0]);
        this.put(new ExpressionValue.IntegerVal().field1(-1));
        this.check_2("15", "field1", SqlColumnType.TINYINT, (byte)20, new Object[0]);
        this.check_2("15.1", "field1", SqlColumnType.DECIMAL, new BigDecimal("20"), new Object[0]);
        this.checkFailure_2("'15.1'", "field1", 1008, this.signatureErorr(SqlColumnType.VARCHAR, SqlColumnType.INTEGER), new Object[0]);
        this.checkFailure_2("true", "field1", 1008, this.signatureErorr(SqlColumnType.BOOLEAN, SqlColumnType.INTEGER), new Object[0]);
        this.put(new ExpressionValue.IntegerVal().field1(15));
        this.check_2("field1", "-1", SqlColumnType.INTEGER, 20, new Object[0]);
        this.checkFailure_2("field1", "'-1'", 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure_2("field1", "true", 1008, this.signatureErorr(SqlColumnType.INTEGER, SqlColumnType.BOOLEAN), new Object[0]);
    }

    private void checkColumn_1(ExpressionValue value, SqlColumnType expectedType, Object expectedValue) {
        this.put(value);
        this.check_1("field1", expectedType, expectedValue, new Object[0]);
    }

    private void checkColumn_2(ExpressionBiValue value, SqlColumnType expectedType, Object expectedValue) {
        this.put(value);
        this.check_2("field1", "field2", expectedType, expectedValue, new Object[0]);
    }

    private void checkColumnFailure_2(ExpressionBiValue value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        String sql = RoundFunctionIntegrationTest.sql("field1", "field2");
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    private void checkFailure_1(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = RoundFunctionIntegrationTest.sql(operand, new Object[0]);
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private void checkFailure_2(Object operand1, Object operand2, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = RoundFunctionIntegrationTest.sql(operand1, operand2);
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    private void check_1(Object operand, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        this.checkValue0(RoundFunctionIntegrationTest.sql(operand, new Object[0]), expectedType, expectedValue, params);
    }

    private void check_2(Object operand1, Object operand2, SqlColumnType expectedType, Object expectedValue, Object ... params) {
        this.checkValue0(RoundFunctionIntegrationTest.sql(operand1, operand2), expectedType, expectedValue, params);
    }

    private String signatureErorr(SqlColumnType ... columnTypes) {
        return RoundFunctionIntegrationTest.signatureErrorFunction("ROUND", columnTypes);
    }

    private static String sql(Object operand1, Object ... operand2) {
        assert (operand2 == null || operand2.length <= 1);
        if (operand2 != null && operand2.length == 1) {
            return "SELECT ROUND(" + String.valueOf(operand1) + ", " + String.valueOf(operand2[0]) + ") FROM map";
        }
        return "SELECT ROUND(" + String.valueOf(operand1) + ") FROM map";
    }
}

