/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.RandFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class RandFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void testNoArg() {
        this.put(0);
        double res1 = this.checkValue("", SKIP_VALUE_CHECK, new Object[0]);
        double res2 = this.checkValue("", SKIP_VALUE_CHECK, new Object[0]);
        Assert.assertNotEquals((Object)res1, (Object)res2);
    }

    @Test
    public void testMultipleCallsInSingleQuery() {
        this.putAll(0, 1, 2, 3);
        List<SqlRow> rows = RandFunctionIntegrationTest.execute("SELECT RAND(), RAND() FROM map", new Object[0]);
        Assert.assertEquals((long)4L, (long)rows.size());
        HashSet<Double> values = new HashSet<Double>();
        for (SqlRow row : rows) {
            double value1 = (Double)row.getObject(0);
            double value2 = (Double)row.getObject(1);
            Assert.assertNotEquals((Object)value1, (Object)value2);
            values.add(value1);
        }
        Assert.assertTrue((values.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testColumn() {
        this.checkColumn((byte)1, 1L);
        this.checkColumn((short)1, 1L);
        this.checkColumn(1, 1L);
        this.checkColumn(1L, 1L);
        this.put(new ExpressionValue.IntegerVal());
        double nullRes1 = this.checkValue("field1", SKIP_VALUE_CHECK, new Object[0]);
        double nullRes2 = this.checkValue("field1", SKIP_VALUE_CHECK, new Object[0]);
        Assert.assertNotEquals((Object)nullRes1, (Object)nullRes2);
        this.checkColumnFailure("1", 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(Character.valueOf('1'), 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR));
        this.checkColumnFailure(true, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN));
        this.checkColumnFailure(Float.valueOf(1.0f), 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.REAL));
        this.checkColumnFailure(1.0, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DOUBLE));
        this.checkColumnFailure(BigInteger.ONE, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL));
        this.checkColumnFailure(BigDecimal.ONE, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL));
        this.checkColumnFailure(LOCAL_DATE_VAL, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DATE));
        this.checkColumnFailure(LOCAL_TIME_VAL, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.TIME));
        this.checkColumnFailure(LOCAL_DATE_TIME_VAL, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP));
        this.checkColumnFailure(OFFSET_DATE_TIME_VAL, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE));
        this.checkColumnFailure(OBJECT_VAL, 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.OBJECT));
    }

    private void checkColumn(Object value, long expectedSeed) {
        this.put(value);
        this.checkValue("this", new Random(expectedSeed).nextDouble(), new Object[0]);
    }

    private void checkColumnFailure(Object value, int expectedErrorCode, String expectedErrorMessage) {
        this.put(value);
        this.checkFailure("this", expectedErrorCode, expectedErrorMessage, new Object[0]);
    }

    @Test
    public void testParameter() {
        this.put(0);
        double nullRes1 = this.checkValue("?", SKIP_VALUE_CHECK, new Object[]{null});
        double nullRes2 = this.checkValue("?", SKIP_VALUE_CHECK, new Object[]{null});
        Assert.assertNotEquals((Object)nullRes1, (Object)nullRes2);
        this.checkParameter((byte)1, 1L);
        this.checkParameter((short)1, 1L);
        this.checkParameter(1, 1L);
        this.checkParameter(1L, 1L);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigInteger.ZERO);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BigDecimal.ZERO);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(0.0f));
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 0.0);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.checkFailure("?", 2000, RandFunctionIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    private void checkParameter(Object param, long expectedSeed) {
        this.checkValue("?", new Random(expectedSeed).nextDouble(), param);
    }

    @Test
    public void testLiteral() {
        this.put(0);
        this.checkValue(0, new Random(0L).nextDouble(), new Object[0]);
        this.checkValue(Long.MAX_VALUE, new Random(Long.MAX_VALUE).nextDouble(), new Object[0]);
        double nullRes1 = this.checkValue("null", SKIP_VALUE_CHECK, new Object[0]);
        double nullRes2 = this.checkValue("null", SKIP_VALUE_CHECK, new Object[0]);
        Assert.assertNotEquals((Object)nullRes1, (Object)nullRes2);
        this.checkFailure("'foo'", 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.VARCHAR), new Object[0]);
        this.checkFailure("true", 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.BOOLEAN), new Object[0]);
        this.checkFailure("1.1", 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DECIMAL), new Object[0]);
        this.checkFailure("1.1E1", 1008, RandFunctionIntegrationTest.signatureError(SqlColumnType.DOUBLE), new Object[0]);
    }

    private static String signatureError(SqlColumnType type) {
        return RandFunctionIntegrationTest.signatureErrorFunction("RAND", type);
    }

    private Double checkValue(Object operand, Object expectedValue, Object ... params) {
        String sql = "SELECT RAND(" + String.valueOf(operand) + ") FROM map";
        return (Double)this.checkValue0(sql, SqlColumnType.DOUBLE, expectedValue, params);
    }

    private void checkFailure(Object operand, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        String sql = "SELECT RAND(" + String.valueOf(operand) + ") FROM map";
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    @Test
    public void testEquals() {
        RandFunction function = RandFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT));
        RandFunctionIntegrationTest.checkEquals(function, RandFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)), true);
        RandFunctionIntegrationTest.checkEquals(function, RandFunction.create((Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT)), false);
    }

    @Test
    public void testSerialization() {
        RandFunction original = RandFunction.create((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT));
        RandFunction restored = (RandFunction)RandFunctionIntegrationTest.serializeAndCheck(original, 53);
        RandFunctionIntegrationTest.checkEquals(original, restored, true);
    }

    @Test
    @Ignore(value="Simplified test for https://github.com/hazelcast/hazelcast/issues/23629")
    public void testNotInlined() {
        String sql = "SELECT 1 FROM (  SELECT RAND() rand FROM TABLE(generate_series(1, 10000))) WHERE rand>? AND rand<?";
        System.out.println(sql);
        SqlResult res = RandFunctionIntegrationTest.instance().getSql().execute(sql, new Object[]{0.5, 0.5});
        Assert.assertFalse((boolean)res.iterator().hasNext());
    }
}

