/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression.math;

import com.hazelcast.jet.sql.impl.expression.math.ArithmeticOperatorIntegrationTest;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.math.MinusFunction;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MinusOperatorIntegrationTest
extends ArithmeticOperatorIntegrationTest {
    @Override
    protected String operator() {
        return "-";
    }

    @Test
    public void testTinyint() {
        this.putAndCheckValue((byte)0, this.sql("this", "null"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.putAndCheckValue((byte)0, this.sql("null", "this"), SqlColumnType.SMALLINT, null, new Object[0]);
        this.checkFields((byte)0, (byte)1, SqlColumnType.SMALLINT, (short)-1);
        this.checkFields((byte)127, (byte)-128, SqlColumnType.SMALLINT, (short)255);
        this.checkFields((byte)-128, (byte)127, SqlColumnType.SMALLINT, (short)-255);
        this.checkFields((byte)0, (short)1, SqlColumnType.INTEGER, -1);
        this.checkFields((byte)127, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, 32895);
        this.checkFields((byte)-128, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, -32895);
        this.checkFields((byte)0, 1, SqlColumnType.BIGINT, -1L);
        this.checkFields((byte)127, Integer.MIN_VALUE, SqlColumnType.BIGINT, 2147483775L);
        this.checkFields((byte)-128, Integer.MAX_VALUE, SqlColumnType.BIGINT, -2147483775L);
        this.checkFields((byte)0, 1L, SqlColumnType.BIGINT, -1L);
        this.checkError((byte)127, Long.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError((byte)-128, Long.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields((byte)0, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1"));
        this.checkFields((byte)0, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields((byte)0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields((byte)0, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (byte)1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (short)1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1);
        this.putAndCheckValue((byte)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1L);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((byte)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testSmallint() {
        this.putAndCheckValue((short)0, this.sql("this", "null"), SqlColumnType.INTEGER, null, new Object[0]);
        this.putAndCheckValue((short)0, this.sql("null", "this"), SqlColumnType.INTEGER, null, new Object[0]);
        this.checkFields((short)0, (byte)1, SqlColumnType.INTEGER, -1);
        this.checkFields((short)Short.MAX_VALUE, (byte)-128, SqlColumnType.INTEGER, 32895);
        this.checkFields((short)Short.MIN_VALUE, (byte)127, SqlColumnType.INTEGER, -32895);
        this.checkFields((short)0, (short)1, SqlColumnType.INTEGER, -1);
        this.checkFields((short)Short.MAX_VALUE, (short)Short.MIN_VALUE, SqlColumnType.INTEGER, 65535);
        this.checkFields((short)Short.MIN_VALUE, (short)Short.MAX_VALUE, SqlColumnType.INTEGER, -65535);
        this.checkFields((short)0, 1, SqlColumnType.BIGINT, -1L);
        this.checkFields((short)Short.MAX_VALUE, Integer.MIN_VALUE, SqlColumnType.BIGINT, 2147516415L);
        this.checkFields((short)Short.MIN_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, -2147516415L);
        this.checkFields((short)0, 1L, SqlColumnType.BIGINT, -1L);
        this.checkError((short)Short.MAX_VALUE, Long.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError((short)Short.MIN_VALUE, Long.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields((short)0, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1"));
        this.checkFields((short)0, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields((short)0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields((short)0, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (byte)1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (short)1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1);
        this.putAndCheckValue((short)0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1L);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure((short)0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testInteger() {
        this.putAndCheckValue(0, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFields(0, (byte)1, SqlColumnType.BIGINT, -1L);
        this.checkFields(Integer.MAX_VALUE, (byte)-128, SqlColumnType.BIGINT, 2147483775L);
        this.checkFields(Integer.MIN_VALUE, (byte)127, SqlColumnType.BIGINT, -2147483775L);
        this.checkFields(0, (short)1, SqlColumnType.BIGINT, -1L);
        this.checkFields(Integer.MAX_VALUE, (short)Short.MIN_VALUE, SqlColumnType.BIGINT, 2147516415L);
        this.checkFields(Integer.MIN_VALUE, (short)Short.MAX_VALUE, SqlColumnType.BIGINT, -2147516415L);
        this.checkFields(0, 1, SqlColumnType.BIGINT, -1L);
        this.checkFields(Integer.MAX_VALUE, Integer.MIN_VALUE, SqlColumnType.BIGINT, 0xFFFFFFFFL);
        this.checkFields(Integer.MIN_VALUE, Integer.MAX_VALUE, SqlColumnType.BIGINT, -4294967295L);
        this.checkFields(0, 1L, SqlColumnType.BIGINT, -1L);
        this.checkError(Integer.MAX_VALUE, Long.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError(Integer.MIN_VALUE, Long.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields(0, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1"));
        this.checkFields(0, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields(0, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields(0, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (byte)1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (short)1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1);
        this.putAndCheckValue(0, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1L);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testBigint() {
        this.putAndCheckValue(0L, this.sql("this", "null"), SqlColumnType.BIGINT, null, new Object[0]);
        this.putAndCheckValue(0L, this.sql("null", "this"), SqlColumnType.BIGINT, null, new Object[0]);
        this.checkFields(0L, (byte)1, SqlColumnType.BIGINT, -1L);
        this.checkError(Long.MAX_VALUE, (byte)-128, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError(Long.MIN_VALUE, (byte)127, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields(0L, (short)1, SqlColumnType.BIGINT, -1L);
        this.checkError(Long.MAX_VALUE, (short)Short.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError(Long.MIN_VALUE, (short)Short.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields(0, 1, SqlColumnType.BIGINT, -1L);
        this.checkError(Long.MAX_VALUE, Integer.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError(Long.MIN_VALUE, Integer.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields(0, 1L, SqlColumnType.BIGINT, -1L);
        this.checkError(Long.MAX_VALUE, Long.MIN_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkError(Long.MIN_VALUE, Long.MAX_VALUE, 2000, MinusOperatorIntegrationTest.overflowError());
        this.checkFields(0L, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1"));
        this.checkFields(0L, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields(0L, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields(0L, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (byte)1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, (short)1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1);
        this.putAndCheckValue(0L, this.sql("this", "?"), SqlColumnType.BIGINT, -1L, 1L);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_INTEGER_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DECIMAL), BIG_DECIMAL_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(0L, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.BIGINT, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigInteger() {
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(BigInteger.ZERO, (byte)1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigInteger.ONE, (byte)-128, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(129));
        this.checkFields(BigInteger.ONE.negate(), (byte)127, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-128));
        this.checkFields(BigInteger.ZERO, (short)1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigInteger.ONE, (short)Short.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(32769));
        this.checkFields(BigInteger.ONE.negate(), (short)Short.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(Short.MIN_VALUE));
        this.checkFields(BigInteger.ZERO, 1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigInteger.ONE, Integer.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(0x80000001L));
        this.checkFields(BigInteger.ONE.negate(), Integer.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(Integer.MIN_VALUE));
        this.checkFields(BigInteger.ZERO, 1L, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigInteger.ONE, Long.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(1).add(MinusOperatorIntegrationTest.decimal(Long.MIN_VALUE).negate()));
        this.checkFields(BigInteger.ONE.negate(), Long.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1).add(MinusOperatorIntegrationTest.decimal(Long.MAX_VALUE).negate()));
        this.checkFields(BigInteger.ZERO, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigInteger.ZERO, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields(BigInteger.ZERO, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields(BigInteger.ZERO, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), (byte)1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), (short)1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), 1);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), 1L);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), BigInteger.ONE);
        this.putAndCheckValue(BigInteger.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"), MinusOperatorIntegrationTest.decimal("1.1"));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigInteger.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDecimal_BigDecimal() {
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "null"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("null", "this"), SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkFields(BigDecimal.ZERO, (byte)1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigDecimal.ONE, (byte)-128, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(129));
        this.checkFields(BigDecimal.ONE.negate(), (byte)127, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-128));
        this.checkFields(BigDecimal.ZERO, (short)1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigDecimal.ONE, (short)Short.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(32769));
        this.checkFields(BigDecimal.ONE.negate(), (short)Short.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(Short.MIN_VALUE));
        this.checkFields(BigDecimal.ZERO, 1, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigDecimal.ONE, Integer.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(0x80000001L));
        this.checkFields(BigDecimal.ONE.negate(), Integer.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(Integer.MIN_VALUE));
        this.checkFields(BigDecimal.ZERO, 1L, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigDecimal.ONE, Long.MIN_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(1).add(MinusOperatorIntegrationTest.decimal(Long.MIN_VALUE).negate()));
        this.checkFields(BigDecimal.ONE.negate(), Long.MAX_VALUE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1).add(MinusOperatorIntegrationTest.decimal(Long.MAX_VALUE).negate()));
        this.checkFields(BigDecimal.ZERO, BigInteger.ONE, SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1));
        this.checkFields(BigDecimal.ZERO, MinusOperatorIntegrationTest.decimal("1.1"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"));
        this.checkFields(BigDecimal.ZERO, Float.valueOf(1.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields(BigDecimal.ZERO, 1.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), (byte)1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), (short)1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), 1);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), 1L);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal(-1), BigInteger.ONE);
        this.putAndCheckValue(BigDecimal.ZERO, this.sql("this", "?"), SqlColumnType.DECIMAL, MinusOperatorIntegrationTest.decimal("-1.1"), MinusOperatorIntegrationTest.decimal("1.1"));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.REAL), Float.valueOf(1.0f));
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(BigDecimal.ZERO, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DECIMAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testReal() {
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("this", "null"), SqlColumnType.REAL, null, new Object[0]);
        this.putAndCheckValue(Float.valueOf(0.0f), this.sql("null", "this"), SqlColumnType.REAL, null, new Object[0]);
        this.checkFields(Float.valueOf(1.0f), Float.valueOf(2.0f), SqlColumnType.REAL, Float.valueOf(-1.0f));
        this.checkFields(Float.valueOf(1.0f), 2.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), (byte)2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), (short)2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), 2);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), 2L);
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(2.0f), BigInteger.ONE.negate());
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), MinusOperatorIntegrationTest.decimal("2"));
        this.putAndCheckValue(Float.valueOf(1.0f), this.sql("this", "?"), SqlColumnType.REAL, Float.valueOf(-1.0f), Float.valueOf(2.0f));
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DOUBLE), 1.0);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(Float.valueOf(1.0f), this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.REAL, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    public void testDouble() {
        this.putAndCheckValue(0.0, this.sql("this", "null"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.putAndCheckValue(0.0, this.sql("null", "this"), SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkFields(1.0, 2.0, SqlColumnType.DOUBLE, -1.0);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), CHAR_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.VARCHAR), "foo");
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.BOOLEAN), true);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, (byte)2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, (short)2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, 2);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, 2L);
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, 2.0, BigInteger.ONE.negate());
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, MinusOperatorIntegrationTest.decimal("2"));
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, Float.valueOf(2.0f));
        this.putAndCheckValue(1.0, this.sql("this", "?"), SqlColumnType.DOUBLE, -1.0, 2.0);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.DATE), LOCAL_DATE_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIME), LOCAL_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP), LOCAL_DATE_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), OFFSET_DATE_TIME_VAL);
        this.putAndCheckFailure(1.0, this.sql("this", "?"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.DOUBLE, SqlColumnType.OBJECT), OBJECT_VAL);
    }

    @Test
    @Parameters(method="dates")
    public void testDate(LocalDate date) {
        this.putAndCheckValue(date, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(date, this.sql("INTERVAL '1' SECOND", null), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(date, this.sql("this", null), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(date, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(date, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(ONE_YEAR_AND_ONE_MONTH), new Object[0]);
        this.putAndCheckFailure(date, this.sql("INTERVAL '1' SECOND", "this"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.DATE), new Object[0]);
        this.putAndCheckValue(date, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, date.atStartOfDay().minus(1L, ChronoUnit.SECONDS), date);
        this.putAndCheckFailure(date, this.sql("INTERVAL '1' SECOND", "?"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(date, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
        this.putAndCheckFailure(date, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.DATE, SqlColumnType.DATE), new Object[0]);
    }

    @Test
    @Parameters(method="times")
    public void testTime(LocalTime time) {
        this.putAndCheckValue(time, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(time, this.sql("INTERVAL '1' SECOND", null), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(time, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(time, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIME, time.minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIME, time.minus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIME, time.minus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIME, time.minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckValue(time, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIME, time, new Object[0]);
        this.putAndCheckFailure(time, this.sql("INTERVAL '1' SECOND", "this"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIME), new Object[0]);
        this.putAndCheckValue(time, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, time.atDate(LocalDate.now()).minus(1L, ChronoUnit.SECONDS), time);
        this.putAndCheckFailure(time, this.sql("INTERVAL '1' SECOND", "?"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(time, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
        this.putAndCheckFailure(time, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIME, SqlColumnType.TIME), new Object[0]);
    }

    @Test
    @Parameters(method="dateTimes")
    public void testTimestamp(LocalDateTime timestamp) {
        this.putAndCheckValue(timestamp, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", null), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP, timestamp.minus(ONE_YEAR_AND_ONE_MONTH), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", "this"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("?", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, timestamp.minus(1L, ChronoUnit.SECONDS), timestamp);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", "?"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP), new Object[0]);
    }

    @Test
    @Parameters(method="dateTimes")
    public void testTimestampWithTimezone(LocalDateTime date) {
        OffsetDateTime timestamp = date.atZone(ZoneId.systemDefault()).toOffsetDateTime();
        this.putAndCheckValue(timestamp, this.sql(null, "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP, null, new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", null), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", null), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql(null, "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' SECOND"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MINUTE"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.MINUTES), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' HOUR"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.HOURS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' DAY"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.DAYS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1 00:00:01' DAY TO SECOND"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.DAYS).minus(1L, ChronoUnit.SECONDS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' MONTH"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.MONTHS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1' YEAR"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(1L, ChronoUnit.YEARS), new Object[0]);
        this.putAndCheckValue(timestamp, this.sql("this", "INTERVAL '1-1' YEAR TO MONTH"), SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, timestamp.minus(Period.of(1, 1, 0)), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", "this"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "INTERVAL '1' SECOND"), 2000, MinusOperatorIntegrationTest.parameterError(0, SqlColumnType.TIMESTAMP, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), timestamp);
        this.putAndCheckFailure(timestamp, this.sql("INTERVAL '1' SECOND", "?"), 1008, this.signatureError("INTERVAL_SECOND", SqlColumnType.TIMESTAMP), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("this", "?"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
        this.putAndCheckFailure(timestamp, this.sql("?", "this"), 1008, this.signatureError(SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, SqlColumnType.TIMESTAMP_WITH_TIME_ZONE), new Object[0]);
    }

    @Test
    public void testEquality() {
        MinusOperatorIntegrationTest.checkEquals(MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), true);
        MinusOperatorIntegrationTest.checkEquals(MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.BIGINT), false);
        MinusOperatorIntegrationTest.checkEquals(MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)100, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), false);
    }

    @Test
    public void testSerialization() {
        Expression original = MinusFunction.create((Expression)ConstantExpression.create((Object)3, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT);
        Expression restored = (Expression)MinusOperatorIntegrationTest.serializeAndCheck(original, 38);
        MinusOperatorIntegrationTest.checkEquals(original, restored, true);
    }

    private static String overflowError() {
        return "BIGINT overflow in '-' operator (consider adding explicit CAST to DECIMAL)";
    }
}

