/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.jet.sql.impl.expression.ExpressionTestSupport;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.impl.expression.CaseExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.junit.Test;

public class NullIfFunctionIntegrationTest
extends ExpressionTestSupport {
    @Test
    public void equalParameters() {
        this.put(1);
        this.checkValue0("select nullif(this, 1) from map", SqlColumnType.INTEGER, null, new Object[0]);
    }

    @Test
    public void nullsAsParameters() {
        this.put(1);
        this.checkValue0("select nullif(null, this) from map", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0("select nullif(this, null) from map", SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0("select nullif(CAST(null as INT), null) from map", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0("select nullif(nullif(CAST(null as INT), null), null) from map", SqlColumnType.INTEGER, null, new Object[0]);
    }

    @Test
    public void notEqualParameters() {
        this.put(1);
        this.checkValue0("select nullif(this, 2) from map", SqlColumnType.INTEGER, 1, new Object[0]);
    }

    @Test
    public void numbersCoercion() {
        this.put(1);
        this.checkValue0("select nullif(this, 1) from map", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0("select nullif(this, CAST(1 as SMALLINT)) from map", SqlColumnType.INTEGER, null, new Object[0]);
        this.checkValue0("select nullif(this, CAST(1 as BIGINT)) from map", SqlColumnType.BIGINT, null, new Object[0]);
        this.checkValue0("select nullif(this, CAST(1 as REAL)) from map", SqlColumnType.REAL, null, new Object[0]);
        this.checkValue0("select nullif(this, CAST(1 as DOUBLE PRECISION)) from map", SqlColumnType.DOUBLE, null, new Object[0]);
        this.checkValue0("select nullif(this, CAST(1 as DECIMAL)) from map", SqlColumnType.DECIMAL, null, new Object[0]);
        this.checkValue0("select nullif(this, 2) from map", SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0("select nullif(this, CAST(2 as SMALLINT)) from map", SqlColumnType.INTEGER, 1, new Object[0]);
        this.checkValue0("select nullif(this, CAST(2 as BIGINT)) from map", SqlColumnType.BIGINT, 1L, new Object[0]);
        this.checkValue0("select nullif(this, CAST(2 as REAL)) from map", SqlColumnType.REAL, Float.valueOf(1.0f), new Object[0]);
        this.checkValue0("select nullif(this, CAST(2 as DOUBLE PRECISION)) from map", SqlColumnType.DOUBLE, 1.0, new Object[0]);
        this.checkValue0("select nullif(this, CAST(2 as DECIMAL)) from map", SqlColumnType.DECIMAL, BigDecimal.ONE, new Object[0]);
    }

    @Test
    public void dateTimeValuesAndLiterals() {
        LocalDate localDate = LocalDate.of(2021, 1, 1);
        this.put(localDate);
        this.checkValue0("select nullif(this, '2021-01-02') from map", SqlColumnType.DATE, localDate, new Object[0]);
        LocalTime localTime = LocalTime.of(12, 0);
        this.put(localTime);
        this.checkValue0("select nullif(this, '13:00') from map", SqlColumnType.TIME, localTime, new Object[0]);
        LocalDateTime localDateTime = LocalDateTime.of(localDate, localTime);
        this.put(localDateTime);
        this.checkValue0("select nullif(this, '2021-01-02T13:00') from map", SqlColumnType.TIMESTAMP, localDateTime, new Object[0]);
        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofHours(2));
        this.put(offsetDateTime);
        this.checkValue0("select nullif(this, '2021-01-02T13:00+01:00') from map", SqlColumnType.TIMESTAMP_WITH_TIME_ZONE, offsetDateTime, new Object[0]);
    }

    @Test
    public void fail_whenCantInferNullIfParameterTypes() {
        this.put(1);
        this.checkFailure0("select nullif(?, ?) from map", 1008, "Cannot apply 'NULLIF' function to [UNKNOWN, UNKNOWN] (consider adding an explicit CAST)", new Object[0]);
    }

    @Test
    public void nonCoercibleTypes() {
        this.put(1);
        this.checkFailure0("select nullif(1, 'abc') from map", 1008, "Cannot apply 'NULLIF' function to [TINYINT, VARCHAR] (consider adding an explicit CAST)", new Object[0]);
        this.checkFailure0("select nullif('abc', CAST('2021-01-02' as DATE)) from map", 1008, "CAST function cannot convert literal 'abc' to type DATE: Cannot parse VARCHAR value to DATE", new Object[0]);
        this.checkFailure0("select nullif('abc', CAST('13:00:00' as TIME)) from map", 1008, "CAST function cannot convert literal 'abc' to type TIME: Cannot parse VARCHAR value to TIME", new Object[0]);
        this.checkFailure0("select nullif('abc', CAST('2021-01-02T13:00' as TIMESTAMP)) from map", 1008, "CAST function cannot convert literal 'abc' to type TIMESTAMP: Cannot parse VARCHAR value to TIMESTAMP", new Object[0]);
        this.checkFailure0("select nullif(1, CAST('2021-01-02' as DATE)) from map", 1008, "Cannot apply 'NULLIF' function to [TINYINT, DATE] (consider adding an explicit CAST)", new Object[0]);
        this.checkFailure0("select nullif(1, CAST('13:00:00' as TIME)) from map", 1008, "Cannot apply 'NULLIF' function to [TINYINT, TIME] (consider adding an explicit CAST)", new Object[0]);
        this.checkFailure0("select nullif(1, CAST('2021-01-02T13:00' as TIMESTAMP)) from map", 1008, "Cannot apply 'NULLIF' function to [TINYINT, TIMESTAMP] (consider adding an explicit CAST)", new Object[0]);
    }

    @Test
    public void testEquality() {
        NullIfFunctionIntegrationTest.checkEquals(CaseExpression.nullif((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)), CaseExpression.nullif((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)), true);
        NullIfFunctionIntegrationTest.checkEquals(CaseExpression.nullif((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT)), CaseExpression.nullif((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)10, (QueryDataType)QueryDataType.INT)), false);
    }

    @Test
    public void testSerialization() {
        CaseExpression original = CaseExpression.nullif((Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT));
        CaseExpression restored = (CaseExpression)NullIfFunctionIntegrationTest.serializeAndCheck(original, 70);
        NullIfFunctionIntegrationTest.checkEquals(original, restored, true);
    }
}

