/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.expression;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionValue;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.com.google.common.collect.Iterables;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlStatement;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import junit.framework.TestCase;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;

public abstract class ExpressionTestSupport
extends SqlTestSupport {
    public static final Character CHAR_VAL = Character.valueOf('f');
    public static final String STRING_VAL = "foo";
    public static final String SEPARATOR_VAL = "-";
    public static final boolean BOOLEAN_VAL = true;
    public static final byte BYTE_VAL = 1;
    public static final short SHORT_VAL = 1;
    public static final int INTEGER_VAL = 1;
    public static final long LONG_VAL = 1L;
    public static final BigInteger BIG_INTEGER_VAL = BigInteger.ONE;
    public static final BigDecimal BIG_DECIMAL_VAL = BigDecimal.ONE;
    public static final float FLOAT_VAL = 1.0f;
    public static final double DOUBLE_VAL = 1.0;
    public static final LocalDate LOCAL_DATE_VAL = LocalDate.parse("2020-01-01");
    public static final LocalTime LOCAL_TIME_VAL = LocalTime.parse("00:00");
    public static final LocalDateTime LOCAL_DATE_TIME_VAL = LocalDateTime.parse("2020-01-01T00:00");
    public static final OffsetDateTime OFFSET_DATE_TIME_VAL = OffsetDateTime.parse("2020-01-01T00:00+00:00");
    public static final ExpressionValue OBJECT_VAL = new ExpressionValue.ObjectVal();
    protected static final Object SKIP_VALUE_CHECK = new Object();
    protected static final String STANDARD_LOCAL_DATE_VAL = "2020-1-1";
    protected static final String STANDARD_LOCAL_TIME_VAL = "0:0:0";
    protected static final String STANDARD_LOCAL_OFFSET_TIME_VAL = "2020-1-1 0:0:0+00:00";
    protected static final String STANDARD_LOCAL_DATE_TIME_VAL = "2020-1-1 0:0:0";
    protected static IMap map;

    @BeforeClass
    public static void beforeClass() {
        ExpressionTestSupport.initialize((int)1, null);
        map = ExpressionTestSupport.instance().getMap("map");
    }

    protected void put(Object value) {
        this.put(0, value);
    }

    protected void put(int key, Object value) {
        ExpressionTestSupport.createMapping("map", Integer.TYPE, value.getClass());
        map.clear();
        map.put((Object)key, value);
    }

    protected void putAll(Object ... values) {
        if (values == null || values.length == 0) {
            return;
        }
        HashMap<Integer, Object> entries = new HashMap<Integer, Object>();
        int key = 0;
        for (Object value : values) {
            entries.put(key++, value);
        }
        this.putAll(entries);
    }

    protected void putAll(Map<Integer, Object> entries) {
        ExpressionTestSupport.createMapping("map", Integer.TYPE, Iterables.get(entries.values(), (int)0).getClass());
        map.clear();
        map.putAll(entries);
    }

    protected void putAndCheckValue(Object value, String sql, SqlColumnType expectedType, Object expectedResult, Object ... params) {
        this.put(value);
        this.checkValue0(sql, expectedType, expectedResult, params);
    }

    protected Object checkValue0(String sql, SqlColumnType expectedType, Object expectedResult, Object ... params) {
        List<SqlRow> rows = ExpressionTestSupport.execute(sql, params);
        Assert.assertEquals((long)1L, (long)rows.size());
        SqlRow row = rows.get(0);
        Assert.assertEquals((long)1L, (long)row.getMetadata().getColumnCount());
        Assert.assertEquals((Object)expectedType, (Object)row.getMetadata().getColumn(0).getType());
        Object value = row.getObject(0);
        if (expectedResult != SKIP_VALUE_CHECK) {
            Assert.assertEquals((Object)expectedResult, (Object)value);
        }
        return value;
    }

    protected void checkValues0(String sql, SqlColumnType expectedType, Object[] expectedResults, Object ... params) {
        List<SqlRow> rows = ExpressionTestSupport.execute(sql, params);
        int expectedResultCount = expectedResults.length;
        Assert.assertEquals((long)expectedResultCount, (long)rows.size());
        Object[] values = new Object[expectedResultCount];
        for (int i = 0; i < expectedResultCount; ++i) {
            Object value;
            SqlRow row = rows.get(i);
            Assert.assertEquals((long)1L, (long)row.getMetadata().getColumnCount());
            Assert.assertEquals((Object)expectedType, (Object)row.getMetadata().getColumn(0).getType());
            values[i] = value = row.getObject(0);
        }
        Assertions.assertThat((Object[])values).containsExactlyInAnyOrderElementsOf(Arrays.asList(expectedResults));
    }

    protected void putAndCheckFailure(Object value, String sql, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        this.put(value);
        this.checkFailure0(sql, expectedErrorCode, expectedErrorMessage, params);
    }

    protected void checkFailure0(String sql, int expectedErrorCode, String expectedErrorMessage, Object ... params) {
        try {
            ExpressionTestSupport.execute(sql, params);
            Assert.fail((String)"Must fail");
        }
        catch (HazelcastSqlException e) {
            Assert.assertTrue((expectedErrorMessage.length() != 0 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)e.getMessage());
            this.logger.info("Error caught", (Throwable)e);
            Assert.assertTrue((String)("\nExpected: " + expectedErrorMessage + "\nActual: " + e.getMessage()), (boolean)e.getMessage().contains(expectedErrorMessage));
            Assert.assertEquals((String)(e.getCode() + ": " + e.getMessage()), (long)expectedErrorCode, (long)e.getCode());
        }
    }

    protected static String signatureErrorFunction(String functionName, Object ... columnTypes) {
        TestCase.assertNotNull((Object)columnTypes);
        StringJoiner joiner = new StringJoiner(", ");
        Arrays.stream(columnTypes).forEach(columnType -> joiner.add(columnType.toString()));
        return "Cannot apply '" + functionName + "' function to [" + String.valueOf(joiner) + "] (consider adding an explicit CAST)";
    }

    protected static String signatureErrorOperator(String operatorName, Object ... columnTypes) {
        TestCase.assertNotNull((Object)columnTypes);
        StringJoiner joiner = new StringJoiner(", ");
        Arrays.stream(columnTypes).forEach(columnType -> joiner.add(columnType.toString()));
        return "Cannot apply '" + operatorName + "' operator to [" + String.valueOf(joiner) + "] (consider adding an explicit CAST)";
    }

    protected static String parameterError(int position, SqlColumnType expectedType, SqlColumnType actualType) {
        return String.format("Parameter at position %d must be of %s type, but %s was found (consider adding an explicit CAST)", position, expectedType, actualType);
    }

    protected static ExpressionValue stringValue1(String first) {
        return new ExpressionValue.StringVal().field1(first);
    }

    protected static ExpressionBiValue stringValue2(String first, String second) {
        return new ExpressionBiValue.StringStringVal().fields(first, second);
    }

    protected static ExpressionValue booleanValue1(Boolean first) {
        return new ExpressionValue.BooleanVal().field1(first);
    }

    protected static ExpressionBiValue booleanValue2(Boolean first, Boolean second) {
        return new ExpressionBiValue.BooleanBooleanVal().fields(first, second);
    }

    protected static List<SqlRow> execute(String sql, Object ... params) {
        return ExpressionTestSupport.execute(ExpressionTestSupport.instance(), sql, params);
    }

    protected static List<SqlRow> execute(HazelcastInstance member, String sql, Object ... params) {
        SqlStatement query = new SqlStatement(sql);
        if (params != null) {
            query.setParameters(Arrays.asList(params));
        }
        return ExpressionTestSupport.executeStatement(member, query);
    }

    protected static List<SqlRow> executeStatement(HazelcastInstance member, SqlStatement query) {
        ArrayList<SqlRow> rows = new ArrayList<SqlRow>();
        try (SqlResult result = member.getSql().execute(query);){
            for (SqlRow row : result) {
                rows.add(row);
            }
        }
        return rows;
    }
}

