/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.test;

import com.hazelcast.function.BiConsumerEx;
import com.hazelcast.function.FunctionEx;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.core.EventTimePolicy;
import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.core.Vertex;
import com.hazelcast.jet.impl.pipeline.transform.BatchSourceTransform;
import com.hazelcast.jet.impl.util.Util;
import com.hazelcast.jet.pipeline.BatchSource;
import com.hazelcast.jet.pipeline.SourceBuilder;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.HazelcastRexNode;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.schema.JetTable;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.optimizer.PlanObjectKey;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.Table;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TestAllTypesSqlConnector
implements SqlConnector {
    public static final String TYPE_NAME = "AllTypes";
    public static final List<MappingField> FIELD_LIST = Arrays.asList(new MappingField("string", QueryDataType.VARCHAR), new MappingField("boolean", QueryDataType.BOOLEAN), new MappingField("byte", QueryDataType.TINYINT), new MappingField("short", QueryDataType.SMALLINT), new MappingField("int", QueryDataType.INT), new MappingField("long", QueryDataType.BIGINT), new MappingField("float", QueryDataType.REAL), new MappingField("double", QueryDataType.DOUBLE), new MappingField("decimal", QueryDataType.DECIMAL), new MappingField("time", QueryDataType.TIME), new MappingField("date", QueryDataType.DATE), new MappingField("timestamp", QueryDataType.TIMESTAMP), new MappingField("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME), new MappingField("map", QueryDataType.OBJECT), new MappingField("object", QueryDataType.OBJECT));
    private static final List<TableField> FIELD_LIST2 = Util.toList(FIELD_LIST, f -> new TableField(f.name(), f.type(), false));
    private static final JetSqlRow VALUES = new JetSqlRow((SerializationService)SqlTestSupport.TEST_SS, new Object[]{"string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), ImmutableMap.of((Object)42, (Object)43), null});
    public static final SqlTestSupport.Row ALL_TYPES_ROW = new SqlTestSupport.Row(VALUES.getValues());

    public static void create(SqlService sqlService, String tableName) {
        sqlService.execute("CREATE MAPPING " + tableName + " TYPE AllTypes", new Object[0]);
    }

    public String typeName() {
        return TYPE_NAME;
    }

    @Nonnull
    public String defaultObjectType() {
        return "Dummy";
    }

    @Nonnull
    public List<MappingField> resolveAndValidateFields(@Nonnull NodeEngine nodeEngine, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> userFields) {
        if (!userFields.isEmpty()) {
            throw QueryException.error((String)"Don't specify external fields, they are fixed");
        }
        return FIELD_LIST;
    }

    @Nonnull
    public Table createTable(@Nonnull NodeEngine nodeEngine, @Nonnull String schemaName, @Nonnull String mappingName, @Nonnull SqlConnector.SqlExternalResource externalResource, @Nonnull List<MappingField> resolvedFields) {
        return new TestAllTypesTable(this, schemaName, mappingName);
    }

    @Nonnull
    public Vertex fullScanReader(@Nonnull SqlConnector.DagBuildContext context, @Nullable HazelcastRexNode predicate, @Nonnull List<HazelcastRexNode> projection, @Nullable List<Map<String, Expression<?>>> partitionPruningCandidates, @Nullable FunctionEx<ExpressionEvalContext, EventTimePolicy<JetSqlRow>> eventTimePolicyProvider) {
        if (eventTimePolicyProvider != null) {
            throw QueryException.error((String)"Ordering function are not supported for AllTypes mappings");
        }
        Expression convertedPredicate = context.convertFilter(predicate);
        List convertedProjection = context.convertProjection(projection);
        BatchSource source = SourceBuilder.batch((String)"batch", ExpressionEvalContext::from).fillBufferFn((BiConsumerEx & Serializable)(ctx, buf) -> {
            JetSqlRow row = ExpressionUtil.evaluate((Expression)convertedPredicate, (List)convertedProjection, (JetSqlRow)VALUES, (ExpressionEvalContext)ctx);
            if (row != null) {
                buf.add((Object)row);
            }
            buf.close();
        }).build();
        ProcessorMetaSupplier pms = ((BatchSourceTransform)source).metaSupplier;
        return context.getDag().newUniqueVertex(context.getTable().toString(), pms);
    }

    private static final class TestAllTypesTable
    extends JetTable {
        private TestAllTypesTable(@Nonnull SqlConnector sqlConnector, @Nonnull String schemaName, @Nonnull String name) {
            super(sqlConnector, FIELD_LIST2, schemaName, name, (TableStatistics)new ConstantTableStatistics(1L), null, false);
        }

        public PlanObjectKey getObjectKey() {
            return new TestAllTypesPlanObjectKey(this.getSchemaName(), this.getSqlName());
        }
    }

    private static final class TestAllTypesPlanObjectKey
    implements PlanObjectKey {
        private final String schemaName;
        private final String name;

        private TestAllTypesPlanObjectKey(String schemaName, String name) {
            this.schemaName = schemaName;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestAllTypesPlanObjectKey that = (TestAllTypesPlanObjectKey)o;
            return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.schemaName, this.name);
        }
    }
}

