/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map.index;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.impl.connector.map.index.SqlIndexTestSupport;
import com.hazelcast.jet.sql.impl.support.expressions.ExpressionBiValue;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.TestHazelcastInstanceFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlIndexConverterMismatchTest
extends SqlIndexTestSupport {
    private static final String MAP_NAME = "map";
    private final TestHazelcastInstanceFactory factory = new TestHazelcastInstanceFactory(2);
    private HazelcastInstance member1;
    private HazelcastInstance member2;
    private IMap<Integer, ExpressionBiValue> map;
    @Parameterized.Parameter
    public boolean composite;

    @Parameterized.Parameters(name="composite:{0}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> res = new ArrayList<Object[]>();
        res.add(new Object[]{false});
        res.add(new Object[]{true});
        return res;
    }

    @Before
    public void before() {
        IndexConfig indexConfig = new IndexConfig().setName("index").setType(IndexType.HASH).addAttribute("field1");
        if (this.composite) {
            indexConfig.addAttribute("field2");
        }
        Config config = this.getConfig();
        config.addMapConfig(new MapConfig().setName(MAP_NAME).setBackupCount(0).addIndexConfig(indexConfig));
        this.member1 = this.factory.newHazelcastInstance(config);
        this.member2 = this.factory.newHazelcastInstance(config);
        this.map = this.member1.getMap(MAP_NAME);
    }

    @Ignore(value="https://github.com/hazelcast/hazelcast/issues/19287")
    @Test
    public void testMismatch() {
        ExpressionBiValue.IntegerIntegerVal value1 = new ExpressionBiValue.IntegerIntegerVal();
        value1.field1(10);
        value1.field2(10);
        ExpressionBiValue.StringIntegerVal value2 = new ExpressionBiValue.StringIntegerVal();
        value2.field1("10");
        value2.field2(10);
        this.map.put((Object)SqlIndexConverterMismatchTest.getLocalKey(this.member1, key -> key), (Object)value1);
        this.map.put((Object)SqlIndexConverterMismatchTest.getLocalKey(this.member2, key -> key), (Object)value2);
        try {
            try (SqlResult result = this.member1.getSql().execute("SELECT key FROM map WHERE field1=1", new Object[0]);){
                for (SqlRow sqlRow : result) {
                }
            }
            Assert.fail((String)"Must fail!");
        }
        catch (HazelcastSqlException e) {
            Assert.assertEquals((long)1009L, (long)e.getCode());
            Throwable ex = this.findRootQueryException(e);
            Assert.assertEquals((Object)"Cannot use the index \"index\" of the IMap \"map\" because it has component \"field1\" of type VARCHAR, but INTEGER was expected", (Object)ex.getMessage());
        }
    }

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    private Throwable findRootQueryException(Throwable t) {
        while (t != null) {
            if (t instanceof QueryException && t.getCause() == null) {
                return t;
            }
            t = t.getCause();
        }
        return null;
    }
}

