/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.impl.TestUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.UpdateProcessorSupplier;
import com.hazelcast.jet.sql.impl.connector.map.UpdatingEntryProcessor;
import com.hazelcast.jet.sql.impl.inject.PrimitiveUpsertTargetDescriptor;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.query.impl.predicates.PredicateTestUtils;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ParameterExpression;
import com.hazelcast.sql.impl.expression.UntrustedExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.PlusFunction;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.schema.ConstantTableStatistics;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTable;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;

public class UpdateProcessorTest
extends SqlTestSupport {
    private static final String MAP_NAME = "map";
    private Map<Integer, Object> map;

    @BeforeClass
    public static void beforeClass() {
        UpdateProcessorTest.initializeWithClient((int)2, null, null);
    }

    @Before
    public void before() {
        this.map = UpdateProcessorTest.instance().getMap(MAP_NAME);
    }

    @Test
    public void test_update() {
        Object updated = this.executeUpdate(1, 1, UpdateProcessorTest.partitionedTable(QueryDataType.INT), Collections.singletonList(QueryPath.VALUE), Collections.singletonList(PlusFunction.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT)), Collections.emptyList());
        Assertions.assertThat((Object)updated).isEqualTo((Object)2);
    }

    @Test
    public void test_updateWithDynamicParameter() {
        Object updated = this.executeUpdate(2L, 1, UpdateProcessorTest.partitionedTable(QueryDataType.BIGINT), Collections.singletonList(QueryPath.VALUE), Collections.singletonList(PlusFunction.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.BIGINT), (Expression)ParameterExpression.create((int)0, (QueryDataType)QueryDataType.BIGINT), (QueryDataType)QueryDataType.BIGINT)), Collections.singletonList(2L));
        Assertions.assertThat((Object)updated).isEqualTo((Object)4L);
    }

    @Test
    public void when_keyDoesNotExist_then_doesNotCreateEntry() {
        Object updated = this.executeUpdate(1, 0, UpdateProcessorTest.partitionedTable(QueryDataType.INT), Collections.singletonList(QueryPath.VALUE), Collections.singletonList(PlusFunction.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT)), Collections.emptyList());
        Assertions.assertThat((Object)updated).isEqualTo((Object)1);
        Assertions.assertThat(this.map).containsExactly(new Map.Entry[]{PredicateTestUtils.entry((Object)1, (Object)1)});
    }

    @Test
    public void when_serializedObject_then_deserializedCorrect() {
        AbstractSerializationService service = (AbstractSerializationService)TestUtil.getNode((HazelcastInstance)UpdateProcessorTest.instance()).getSerializationService();
        UntrustedExpressionEvalContext evalContextMock = (UntrustedExpressionEvalContext)Mockito.mock(UntrustedExpressionEvalContext.class);
        Mockito.when((Object)evalContextMock.getSerializationService()).thenReturn((Object)((InternalSerializationService)Mockito.mock((Object[])new InternalSerializationService[0])));
        Subject subject = new Subject(true, Collections.emptySet(), Collections.emptySet(), Collections.emptySet());
        Mockito.when((Object)evalContextMock.subject()).thenReturn((Object)subject);
        EntryProcessor processor = UpdatingEntryProcessor.supplier((PartitionedMapTable)UpdateProcessorTest.partitionedTable(QueryDataType.INT), Collections.emptyList(), Collections.emptyList()).get(evalContextMock);
        Data data = service.toData((Object)processor);
        Object actual = service.toObject((Object)data);
        Assertions.assertThat((Object)actual).usingRecursiveComparison().comparingOnlyFields(new String[]{"rowProjectorSupplier", "valueProjectorSupplier", "arguments"}).ignoringFields(new String[]{"subject.pubCredentials", "subject.privCredentials"}).isEqualTo((Object)processor);
    }

    private static PartitionedMapTable partitionedTable(QueryDataType valueType) {
        return new PartitionedMapTable("public", MAP_NAME, MAP_NAME, Arrays.asList(new MapTableField(QueryPath.KEY, QueryDataType.INT, false, QueryPath.KEY_PATH), new MapTableField(QueryPath.VALUE, valueType, false, QueryPath.VALUE_PATH)), (TableStatistics)new ConstantTableStatistics(1L), (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (Object)PrimitiveUpsertTargetDescriptor.INSTANCE, (Object)PrimitiveUpsertTargetDescriptor.INSTANCE, Collections.emptyList(), false, Collections.emptyList(), false);
    }

    private Object executeUpdate(Object initialValue, int inputValue, PartitionedMapTable table, List<String> fieldNames, List<Expression<?>> expressions, List<Object> arguments) {
        UpdateProcessorSupplier processor = new UpdateProcessorSupplier(MAP_NAME, UpdatingEntryProcessor.supplier((PartitionedMapTable)table, fieldNames, expressions));
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)processor)).jobConfig(new JobConfig().setArgument("__sql.arguments", arguments)).executeBeforeEachRun(() -> this.map.put(1, initialValue)).input(Collections.singletonList(UpdateProcessorTest.jetRow(inputValue))).hazelcastInstance(UpdateProcessorTest.instance()).outputChecker(SqlTestSupport::compareRowLists).disableProgressAssertion().expectOutput(Collections.emptyList());
        return this.map.get(1);
    }
}

