/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlSelectTest
extends SqlTestSupport {
    @BeforeClass
    public static void setUpClass() {
        SqlSelectTest.initialize((int)1, null);
    }

    private static List<SqlTestSupport.Row> fillIMapAndGetData(IMap<Integer, String> map, int count) {
        int i;
        assert (count >= 0);
        ArrayList<SqlTestSupport.Row> rows = new ArrayList<SqlTestSupport.Row>(count);
        for (i = 0; i < count; ++i) {
            char ch = (char)(65 + i);
            String s = String.valueOf(ch);
            map.put((Object)i, (Object)s);
            rows.add(new SqlTestSupport.Row(i, s));
        }
        Assert.assertEquals((long)i, (long)count);
        return rows;
    }

    @Test
    public void test_basicSelect() {
        HazelcastInstance hazelcastInstance = SqlSelectTest.instance();
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = hazelcastInstance.getMap(name);
        List<SqlTestSupport.Row> rows = SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 20);
        SqlSelectTest.assertRowsAnyOrder("SELECT * FROM " + name, rows);
    }

    @Test
    public void test_selectWithEqFilter() {
        HazelcastInstance hazelcastInstance = SqlSelectTest.instance();
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = hazelcastInstance.getMap(name);
        SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 14);
        List<SqlTestSupport.Row> filteredRows = Collections.singletonList(new SqlTestSupport.Row(5, "F"));
        SqlSelectTest.assertRowsAnyOrder("SELECT * FROM " + name + " AS I WHERE I.__key = 5", filteredRows);
    }

    @Test
    public void test_selectWithEqFilterAndProject() {
        HazelcastInstance hazelcastInstance = SqlSelectTest.instance();
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = hazelcastInstance.getMap(name);
        SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 14);
        List<SqlTestSupport.Row> filteredAndProjectedRows = Collections.singletonList(new SqlTestSupport.Row(10L, "F"));
        SqlSelectTest.assertRowsAnyOrder("SELECT __key * 2, this FROM " + name + " AS I WHERE I.__key = 5", filteredAndProjectedRows);
    }

    @Test
    public void test_selectWithEvenNumbersFilter() {
        HazelcastInstance hazelcastInstance = SqlSelectTest.instance();
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = hazelcastInstance.getMap(name);
        List<SqlTestSupport.Row> rows = SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 14);
        List<SqlTestSupport.Row> filteredRows = rows.stream().filter(row -> (Integer)row.getValues()[0] % 2 == 0).collect(Collectors.toList());
        SqlSelectTest.assertRowsAnyOrder("SELECT * FROM " + name + " WHERE ( __key % 2 ) = 0", filteredRows);
    }

    @Test
    public void test_selectWithProjection() {
        boolean thisProjection = true;
        HazelcastInstance hazelcastInstance = SqlSelectTest.instance();
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = hazelcastInstance.getMap(name);
        List<SqlTestSupport.Row> rows = SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 20);
        List<SqlTestSupport.Row> projected = rows.stream().map(row -> new SqlTestSupport.Row(row.getValues()[1])).collect(Collectors.toList());
        SqlSelectTest.assertRowsAnyOrder("SELECT this FROM " + name, projected);
    }

    @Test
    public void test_selectFromView() {
        String name = SqlSelectTest.randomName();
        SqlSelectTest.createMapping(name, Integer.TYPE, String.class);
        IMap map = SqlSelectTest.instance().getMap(name);
        SqlSelectTest.instance().getSql().execute("CREATE VIEW v AS SELECT * FROM " + name, new Object[0]);
        List<SqlTestSupport.Row> rows = SqlSelectTest.fillIMapAndGetData((IMap<Integer, String>)map, 20);
        SqlSelectTest.assertRowsAnyOrder("SELECT * FROM v", rows);
    }
}

