/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.IMapSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlJsonTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setup() {
        SqlJsonTest.initialize((int)1, null);
        sqlService = SqlJsonTest.instance().getSql();
    }

    private static SqlTestSupport.SqlMapping jsonMapping(String name) {
        return (SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).options(new Object[]{"keyFormat", "json-flat", "valueFormat", "json-flat"});
    }

    @Test
    public void test_nulls() {
        String name = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(name).fields(new String[]{"id INT EXTERNAL NAME \"__key.id\"", "name VARCHAR EXTERNAL NAME \"this.name\""})).create();
        SqlJsonTest.assertMapEventually(name, "SINK INTO " + name + " VALUES (null, null)", Map.of(new HazelcastJsonValue("{\"id\":null}"), new HazelcastJsonValue("{\"name\":null}")));
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(null, null)));
    }

    @Test
    public void test_fieldsMapping() {
        String name = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(name).fields(new String[]{"key_name VARCHAR EXTERNAL NAME \"__key.name\"", "value_name VARCHAR EXTERNAL NAME \"this.name\""})).create();
        SqlJsonTest.assertMapEventually(name, "SINK INTO " + name + " (value_name, key_name) VALUES ('Bob', 'Alice')", Map.of(new HazelcastJsonValue("{\"name\":\"Alice\"}"), new HazelcastJsonValue("{\"name\":\"Bob\"}")));
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row("Alice", "Bob")));
    }

    @Test
    public void test_schemaEvolution() {
        String name = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).fields(new String[]{"__key INT", "name VARCHAR"})).options(new Object[]{"keyFormat", "java", "keyJavaClass", Integer.class.getName(), "valueFormat", "json-flat"})).create();
        sqlService.execute("SINK INTO " + name + " VALUES (13, 'Alice')", new Object[0]);
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).fields(new String[]{"__key INT", "name VARCHAR", "ssn BIGINT"})).options(new Object[]{"keyFormat", "java", "keyJavaClass", Integer.class.getName(), "valueFormat", "json-flat"})).createOrReplace();
        sqlService.execute("SINK INTO " + name + " VALUES (69, 'Bob', 123456789)", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(13, "Alice", null), new SqlTestSupport.Row(69, "Bob", 123456789L)));
    }

    @Test
    public void test_allTypes() {
        String from = SqlJsonTest.randomName();
        TestAllTypesSqlConnector.create(sqlService, from);
        String to = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(to).fields(new String[]{"id VARCHAR EXTERNAL NAME \"__key.id\"", "string VARCHAR", "\"boolean\" BOOLEAN", "byte TINYINT", "short SMALLINT", "\"int\" INT", "long BIGINT", "\"float\" REAL", "\"double\" DOUBLE", "\"decimal\" DECIMAL", "\"time\" TIME", "\"date\" DATE", "\"timestamp\" TIMESTAMP", "timestampTz TIMESTAMP WITH TIME ZONE", "object OBJECT", "map OBJECT"})).create();
        sqlService.execute("SINK INTO " + to + " SELECT '1', f.* FROM " + from + " f", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT * FROM " + to, List.of(new SqlTestSupport.Row("1", "string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), "{42=43}", null)));
    }

    @Test
    public void when_explicitTopLevelField_then_fail_key() {
        this.when_explicitTopLevelField_then_fail("__key", "this");
    }

    @Test
    public void when_explicitTopLevelField_then_fail_this() {
        this.when_explicitTopLevelField_then_fail("this", "__key");
    }

    private void when_explicitTopLevelField_then_fail(String field, String otherField) {
        String name = SqlJsonTest.randomName();
        Assertions.assertThatThrownBy(() -> ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(name).fields(new String[]{field + " VARCHAR", "f VARCHAR EXTERNAL NAME \"" + otherField + ".f\""})).create()).hasMessage("Cannot use '" + field + "' field with JSON serialization");
    }

    @Test
    public void test_writingToTopLevel() {
        String mapName = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(mapName).fields(new String[]{"id INT EXTERNAL NAME \"__key.id\"", "name VARCHAR"})).create();
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + "(__key, name) VALUES ('{\"id\":1}', null)", new Object[0])).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + "(id, this) VALUES (1, '{\"name\":\"foo\"}')", new Object[0])).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
    }

    @Test
    public void test_topLevelFieldExtraction() {
        String name = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlJsonTest.jsonMapping(name).fields(new String[]{"id INT EXTERNAL NAME \"__key.id\"", "name VARCHAR EXTERNAL NAME \"this.name\""})).create();
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice')", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, List.of(new SqlTestSupport.Row(new HazelcastJsonValue("{\"id\":1}"), new HazelcastJsonValue("{\"name\":\"Alice\"}"))));
    }

    @Test
    public void test_jsonType() {
        String name = SqlJsonTest.randomName();
        ((SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, IMapSqlConnector.class).options(new Object[]{"keyFormat", "json", "valueFormat", "json"})).create();
        sqlService.execute("SINK INTO " + name + " VALUES (CAST('[1,2,3]' AS JSON), CAST('[4,5,6]' AS JSON))", new Object[0]);
        SqlJsonTest.assertRowsAnyOrder("SELECT __key, this FROM " + name, List.of(new SqlTestSupport.Row(new HazelcastJsonValue("[1,2,3]"), new HazelcastJsonValue("[4,5,6]"))));
    }
}

