/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.IndexType;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.map.model.Person;
import com.hazelcast.jet.sql.impl.connector.map.model.PersonId;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastParametrizedRunner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Enclosed.class)
public class SqlJoinTest {

    @RunWith(value=HazelcastParametrizedRunner.class)
    public static class SqlAsymmetricOuterJoinTest
    extends SqlTestSupport {
        private static SqlService sqlService;
        @Parameterized.Parameter
        public OuterJoinType joinType;

        @BeforeClass
        public static void setUpClass() {
            SqlAsymmetricOuterJoinTest.initialize((int)2, null);
            sqlService = SqlAsymmetricOuterJoinTest.instance().getSql();
        }

        @Parameterized.Parameters(name="{0} JOIN")
        public static Object[] params() {
            return new Object[]{OuterJoinType.LEFT, OuterJoinType.RIGHT};
        }

        @Test
        public void test_join() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName() + "_batch";
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName() + "_map";
            SqlAsymmetricOuterJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this || '-s' FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.__key", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, 2, "value-2-s")));
        }

        @Test
        public void test_joinOnPrimitiveKey() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.__key", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, 2, "value-2")));
        }

        @Test
        public void test_joinNotOnPrimitiveKey() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)3);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.this", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, "value-2", 2)));
        }

        @Test
        public void test_joinNotOnPrimitiveKey_withAdditionalCondition() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)3);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.this and m.__key is null", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, null, null)));
        }

        @Test
        public void test_joinNotOnPrimitiveKey_multipleMatches() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)2);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.this", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, "value-2", 2), new SqlTestSupport.Row(2, "value-3", 2)));
        }

        @Test
        public void test_joinNotOnPrimitiveKey_multipleMatches_additionalCondition() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)2);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON t.v = m.this and m.__key='value-3'", Arrays.asList(new SqlTestSupport.Row(0, null, null), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, "value-3", 2)));
        }

        @Test
        public void test_joinWithAlwaysTrueCondition() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)3);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON 1 = 1", Arrays.asList(new SqlTestSupport.Row(0, "value-1", 1), new SqlTestSupport.Row(0, "value-2", 2), new SqlTestSupport.Row(0, "value-3", 3), new SqlTestSupport.Row(null, "value-1", 1), new SqlTestSupport.Row(null, "value-2", 2), new SqlTestSupport.Row(null, "value-3", 3)));
        }

        @Test
        public void test_joinWithNonEquiJoin() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}, {"3"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON m.__key > t.v", Arrays.asList(new SqlTestSupport.Row(0, 1, "value-1"), new SqlTestSupport.Row(0, 2, "value-2"), new SqlTestSupport.Row(0, 3, "value-3"), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, 3, "value-3"), new SqlTestSupport.Row(3, null, null)));
        }

        @Test
        public void test_joinWithNonEquiJoin_additionalCondition() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, batchName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}, {"3"}));
            String mapName = SqlAsymmetricOuterJoinTest.randomName();
            SqlAsymmetricOuterJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlAsymmetricOuterJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT t.v, m.__key, m.this FROM " + this.joinClause(batchName, mapName) + " ON m.__key > t.v AND m.this IS NOT NULL", Arrays.asList(new SqlTestSupport.Row(0, 1, "value-1"), new SqlTestSupport.Row(0, 2, "value-2"), new SqlTestSupport.Row(0, 3, "value-3"), new SqlTestSupport.Row(null, null, null), new SqlTestSupport.Row(2, 3, "value-3"), new SqlTestSupport.Row(3, null, null)));
        }

        @Test
        public void test_whenOuterJoinHasSubquery() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            IMap map = SqlAsymmetricOuterJoinTest.instance().getMap(batchName);
            SqlAsymmetricOuterJoinTest.createMapping(batchName, Integer.TYPE, Integer.TYPE);
            map.put((Object)1, (Object)1);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT * FROM " + this.joinClause(batchName, "(SELECT * FROM " + batchName + ")") + " ON true", Collections.singletonList(new SqlTestSupport.Row(1, 1, 1, 1)));
        }

        @Test
        public void test_whenOuterJoinUseStreamingSource_thenExceptionThrown() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            IMap map = SqlAsymmetricOuterJoinTest.instance().getMap(batchName);
            SqlAsymmetricOuterJoinTest.createMapping(batchName, Integer.TYPE, Integer.TYPE);
            map.put((Object)1, (Object)1);
            Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + this.joinClause(batchName, "TABLE(GENERATE_STREAM(1))") + " ON true", new Object[0])).hasCauseInstanceOf(QueryException.class).hasMessageContaining("The right side of a LEFT JOIN or the left side of RIGHT JOIN cannot be a streaming source");
        }

        @Test
        public void test_whenOuterJoinUseValuesClause() {
            String batchName = SqlAsymmetricOuterJoinTest.randomName();
            IMap map = SqlAsymmetricOuterJoinTest.instance().getMap(batchName);
            SqlAsymmetricOuterJoinTest.createMapping(batchName, Integer.TYPE, Integer.TYPE);
            map.put((Object)1, (Object)1);
            SqlTestSupport.Row expectedRow = this.joinType == OuterJoinType.LEFT ? new SqlTestSupport.Row(1, 1, (byte)1, (byte)2) : new SqlTestSupport.Row((byte)1, (byte)2, 1, 1);
            SqlAsymmetricOuterJoinTest.assertRowsAnyOrder("SELECT * FROM " + this.joinClause(batchName, "(VALUES(1,2))") + " ON true", Collections.singletonList(expectedRow));
        }

        private String joinClause(String batchSourceName, String mapSourceName) {
            String leftJoinOperand = this.joinType == OuterJoinType.LEFT ? batchSourceName : mapSourceName;
            String rightJoinOperand = this.joinType == OuterJoinType.LEFT ? mapSourceName : batchSourceName;
            String leftAlias = this.joinType == OuterJoinType.LEFT ? "t" : "m";
            String rightAlias = this.joinType == OuterJoinType.LEFT ? "m" : "t";
            return String.format("%s %s %s JOIN %s %s", leftJoinOperand, leftAlias, this.joinType.toString(), rightJoinOperand, rightAlias);
        }

        public static enum OuterJoinType {
            LEFT,
            RIGHT;

        }
    }

    @RunWith(value=HazelcastParametrizedRunner.class)
    public static class SqlSemiAntiJoinTest
    extends SqlTestSupport {
        private static SqlService sqlService;
        @Parameterized.Parameter
        public JoinType joinType;

        @BeforeClass
        public static void setUpClass() {
            SqlSemiAntiJoinTest.initialize((int)2, null);
            sqlService = SqlSemiAntiJoinTest.instance().getSql();
        }

        @Parameterized.Parameters(name="{0} JOIN")
        public static Object[] params() {
            return new Object[]{JoinType.SEMI, JoinType.ANTI};
        }

        @Test
        public void test_exists_withSubqueryAlwaysReturningSome() {
            String name = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), {"1", "value-1"}, {"2", "value-2"}, {"3", "value-3"});
            this.assertRows("SELECT * FROM " + name + " WHERE " + this.whereClause() + " (SELECT 1)", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2"), new SqlTestSupport.Row(3, "value-3")), Collections.emptyList());
        }

        @Test
        public void test_exists_withSubqueryAlwaysReturningNone() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), {"1", "value-1"}, {"2", "value-2"}, {"3", "value-3"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), new String[0][]);
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT 1 FROM " + subName + " WHERE v = 1)", Collections.emptyList(), Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2"), new SqlTestSupport.Row(3, "value-3")));
        }

        @Test
        public void test_exists_onCorrelatedPrimitiveKey() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), {"1", "value-1"}, {"2", "value-2"}, {"3", "value-3"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), {"0"}, {"1"}, {"2"});
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT s.v FROM " + subName + " s WHERE s.v = m.k)", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")), Collections.singletonList(new SqlTestSupport.Row(3, "value-3")));
        }

        @Test
        public void test_exists_onWithMultipleNestedExistsAndNonScalarSubquery() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), {"1", "value-1"}, {"2", "value-2"}, {"3", "value-3"});
            String subName = SqlSemiAntiJoinTest.createTable(Arrays.asList("v", "w"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.INTEGER), {"0", "0"}, {"1", "1"}, {"2", "2"});
            String subSubName = SqlSemiAntiJoinTest.createTable(Arrays.asList("a", "b"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.INTEGER), {"0", "0"}, {"1", "1"}, {"2", "2"});
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT * FROM " + subName + " s WHERE " + this.whereClause() + " (SELECT * FROM " + subSubName + " t WHERE t.a = s.v))", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2"), new SqlTestSupport.Row(3, "value-3")), Collections.emptyList());
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT * FROM " + subName + " s WHERE " + this.whereClause() + " (SELECT * FROM " + subSubName + " t WHERE t.a = s.v ORDER BY b))", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2"), new SqlTestSupport.Row(3, "value-3")), Collections.emptyList());
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT * FROM " + subName + " s WHERE " + this.whereClause() + " (SELECT * FROM " + subSubName + " t WHERE t.a = s.v )) LIMIT 0", Collections.emptyList(), Collections.emptyList());
        }

        @Test
        public void test_exists_onCorrelatedPrimitiveValue() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), {"1", "value-1"}, {"2", "value-2"}, {"3", "value-3"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.VARCHAR), {"value-0"}, {"value-1"}, {"value-2"});
            this.assertRows("SELECT * FROM " + mainName + " m WHERE " + this.whereClause() + " (SELECT s.v FROM " + subName + " s WHERE s.v = m.v)", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")), Collections.singletonList(new SqlTestSupport.Row(3, "value-3")));
        }

        @Test
        public void test_exists_withAdditionalCondition() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), {"value-1", "1"}, {"value-2", "2"}, {"value-3", "3"}, {"value-4", "4"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), {"1"}, {null}, {"3"}, {"4"});
            this.assertRows("SELECT m.v, m.k FROM  " + mainName + " m WHERE " + this.whereClause() + " (SELECT s.v FROM " + subName + " s WHERE s.v = m.v AND s.v >= 2)", Arrays.asList(new SqlTestSupport.Row(3, "value-3"), new SqlTestSupport.Row(4, "value-4")), Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_exists_withAdditionalCondition_thenFilter() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), {"value-1", "1"}, {"value-2", "2"}, {"value-3", "3"}, {"value-4", "4"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), {"1"}, {null}, {"3"}, {"4"});
            this.assertRows("SELECT m.v, m.k FROM  " + mainName + " m WHERE " + this.whereClause() + " (SELECT s.v FROM " + subName + " s WHERE s.v = m.v AND s.v >= 2) AND m.v % 2 = 1", Collections.singletonList(new SqlTestSupport.Row(3, "value-3")), Collections.singletonList(new SqlTestSupport.Row(1, "value-1")));
        }

        @Test
        public void test_exists_onOtherThanEquality() {
            String mainName = SqlSemiAntiJoinTest.createTable(Arrays.asList("k", "v"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), {"value-1", "1"}, {"value-2", "2"}, {"value-3", "3"}, {"value-4", "4"});
            String subName = SqlSemiAntiJoinTest.createTable(Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), {"1"}, {null}, {"3"}, {"4"});
            this.assertRows("SELECT * FROM  " + mainName + " m WHERE " + this.whereClause() + " (SELECT s.v FROM " + subName + " s WHERE s.v < m.v)", Arrays.asList(new SqlTestSupport.Row("value-2", 2), new SqlTestSupport.Row("value-3", 3), new SqlTestSupport.Row("value-4", 4)), Collections.singletonList(new SqlTestSupport.Row("value-1", 1)));
        }

        private static String createTable(List<String> names, List<QueryDataTypeFamily> types, String[] ... values) {
            String name = SqlSemiAntiJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, name, names, types, Arrays.asList(values));
            return name;
        }

        private String whereClause() {
            switch (this.joinType) {
                case SEMI: {
                    return "EXISTS";
                }
                case ANTI: {
                    return "NOT EXISTS";
                }
            }
            throw new IllegalStateException("Unexpected join type: " + String.valueOf((Object)this.joinType));
        }

        private void assertRows(String sql, Collection<SqlTestSupport.Row> rowsExisted, Collection<SqlTestSupport.Row> rowsNotExisted) {
            switch (this.joinType) {
                case SEMI: {
                    SqlSemiAntiJoinTest.assertRowsAnyOrder(sql, rowsExisted);
                    break;
                }
                case ANTI: {
                    SqlSemiAntiJoinTest.assertRowsAnyOrder(sql, rowsNotExisted);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected join type: " + String.valueOf((Object)this.joinType));
                }
            }
        }

        public static enum JoinType {
            SEMI,
            ANTI;

        }
    }

    public static class SqlInnerJoinTest
    extends SqlTestSupport {
        private static SqlService sqlService;

        @BeforeClass
        public static void setUpClass() {
            SqlInnerJoinTest.initialize((int)2, null);
            sqlService = SqlInnerJoinTest.instance().getSql();
        }

        @Test
        public void test_innerJoin_mapOnRight() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l INNER JOIN " + mapName + " m ON l.v = m.__key + m.__key", Collections.singletonList(new SqlTestSupport.Row(2, "value-1")));
        }

        @Test
        public void test_innerJoin_mapOnLeft() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + mapName + " m INNER JOIN " + leftName + " l ON l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerCommaJoin() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String map1Name = "abc";
            String map2Name = "cdf";
            SqlInnerJoinTest.createMapping(map1Name, Integer.TYPE, String.class);
            SqlInnerJoinTest.createMapping(map2Name, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(map1Name).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(map1Name).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(map1Name).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.instance().getMap(map2Name).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(map2Name).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(map2Name).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m1.this, m2.this FROM " + leftName + " AS l, " + map1Name + " AS m1, " + map2Name + " AS m2 WHERE l.v = m1.__key AND l.v = m2.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1", "value-1"), new SqlTestSupport.Row(2, "value-2", "value-2")));
        }

        @Test
        public void test_innerJoinUsing() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Collections.singletonList("__key"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {"1"}, {"2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m USING (__key)", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinConditionInWhereClause() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l, " + mapName + " m WHERE l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinAndConditionInWhereClause() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l INNER JOIN " + mapName + " m ON 1 = 1 WHERE l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinWithoutCondition() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 2);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l, " + mapName + " m ", Arrays.asList(new SqlTestSupport.Row(0, "value-1"), new SqlTestSupport.Row(0, "value-2"), new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(1, "value-2")));
        }

        @Test
        public void test_crossJoin() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 2);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l CROSS JOIN " + mapName + " m ", Arrays.asList(new SqlTestSupport.Row(0, "value-1"), new SqlTestSupport.Row(0, "value-2"), new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(1, "value-2")));
        }

        @Test
        public void test_innerJoinNull() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key", Collections.singletonList(new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinFilter() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key WHERE m.__key < 2", Collections.singletonList(new SqlTestSupport.Row(1, "value-1")));
        }

        @Test
        public void test_innerJoinProject() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this || '-s' FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key ", Arrays.asList(new SqlTestSupport.Row(1, "value-1-s"), new SqlTestSupport.Row(2, "value-2-s")));
        }

        @Test
        public void test_innerJoinDynamicParameters() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this || ?FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key WHERE m.__key < ?", Arrays.asList("-s", 2), Collections.singletonList(new SqlTestSupport.Row(1, "value-1-s")));
        }

        @Test
        public void test_innerJoinConditionProject() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v = 2 * m.__key", Collections.singletonList(new SqlTestSupport.Row(2, 1, "value-1")));
        }

        @Test
        public void test_innerJoinOnValue() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, String.class, Integer.TYPE);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)"value-1", (Object)1);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)"value-2", (Object)2);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)"value-3", (Object)3);
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.__key FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.this", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinNonEqui() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 4);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v > m.__key", Arrays.asList(new SqlTestSupport.Row(2, 1, "value-1"), new SqlTestSupport.Row(3, 1, "value-1"), new SqlTestSupport.Row(3, 2, "value-2")));
        }

        @Test
        public void test_joinEquiJoinAndDisjunction() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 4);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key OR l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, 1, "value-1"), new SqlTestSupport.Row(2, 2, "value-2"), new SqlTestSupport.Row(3, 3, "value-3")));
        }

        @Test
        public void test_innerJoinEquiAndNonEqui() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Arrays.asList("v1", "v2"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.INTEGER), Arrays.asList({"0", "0"}, {"1", "0"}, {"2", "2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v1, l.v2, m.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m ON l.v1 = m.__key AND l.v2 != m.__key", Collections.singletonList(new SqlTestSupport.Row(1, 0, 1, "value-1")));
        }

        @Test
        public void test_innerJoinMulti() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName1 = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName1, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName1).put((Object)1, (Object)"value-1.1");
            SqlInnerJoinTest.instance().getMap(mapName1).put((Object)2, (Object)"value-1.2");
            SqlInnerJoinTest.instance().getMap(mapName1).put((Object)3, (Object)"value-1.3");
            String mapName2 = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName2, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName2).put((Object)1, (Object)"value-2.1");
            SqlInnerJoinTest.instance().getMap(mapName2).put((Object)2, (Object)"value-2.2");
            SqlInnerJoinTest.instance().getMap(mapName2).put((Object)3, (Object)"value-2.3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m1.this, m2.this FROM " + leftName + " l JOIN " + mapName1 + " m1 ON l.v = m1.__key JOIN " + mapName2 + " m2 ON l.v + m1.__key > m2.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1.1", "value-2.1"), new SqlTestSupport.Row(2, "value-1.2", "value-2.1"), new SqlTestSupport.Row(2, "value-1.2", "value-2.2"), new SqlTestSupport.Row(2, "value-1.2", "value-2.3")));
        }

        @Test
        public void test_multipleJoinsWithSelectStar() {
            SqlInnerJoinTest.createMapping("m1", Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.createMapping("m2", Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.createMapping("m3", Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.assertRowsOrdered("select * from m1 join m2 on m1.__key=m2.__key join m3 on m2.__key=m3.__key", SqlInnerJoinTest.rows(1, new Object[0]));
        }

        @Test
        public void test_innerJoinPartOfTheCompositeKey() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.INTEGER), Arrays.asList({"0"}, {null}, {"2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Person.class, PersonId.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(null, "value-1"), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(2, "value-2"), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(3, "value-3"), (Object)new PersonId());
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.name, m.id FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.id", Collections.singletonList(new SqlTestSupport.Row(2, "value-2", 2)));
        }

        @Test
        public void test_innerJoinFullCompositeKeyConjunction() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Arrays.asList("v1", "v2"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), Arrays.asList({"0", "value-0"}, {"1", null}, {"2", "value-2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Person.class, PersonId.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(1, null), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(2, "value-2"), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(3, "value-3"), (Object)new PersonId());
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v1, l.v2, m.id, m.name FROM " + leftName + " l JOIN " + mapName + " m ON l.v1 = m.id AND l.v2 = m.name", Collections.singletonList(new SqlTestSupport.Row(2, "value-2", 2, "value-2")));
        }

        @Test
        public void test_innerJoinFullCompositeKeyDisjunction() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Arrays.asList("v1", "v2"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), Arrays.asList({"0", "value-0"}, {"1", null}, {"2", "value-2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Person.class, PersonId.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(1, "value-1"), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(2, "value-2"), (Object)new PersonId());
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new Person(3, "value-3"), (Object)new PersonId());
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v1, l.v2, m.id, m.name FROM " + leftName + " l JOIN " + mapName + " m ON l.v1 = m.id OR l.v2 = m.name", Arrays.asList(new SqlTestSupport.Row(1, null, 1, "value-1"), new SqlTestSupport.Row(2, "value-2", 2, "value-2")));
        }

        @Test
        public void test_innerJoinPartOfTheCompositeValue() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.VARCHAR), Arrays.asList({"value-0"}, {"value-1"}, {"value-2"}));
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, PersonId.class, Person.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new PersonId(1), (Object)new Person(0, "value-1"));
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new PersonId(2), (Object)new Person(0, "value-2"));
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)new PersonId(3), (Object)new Person(0, "value-3"));
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.id FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.name", Arrays.asList(new SqlTestSupport.Row("value-1", 1), new SqlTestSupport.Row("value-2", 2)));
        }

        @Test
        public void test_innerJoinKeyAndValue() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, Person.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)new Person(0, "value-1"));
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)new Person(2, "value-2"));
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)new Person(0, "value-3"));
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.id, m.name FROM " + leftName + " l JOIN " + mapName + " m ON l.v = m.__key AND l.v = m.id", Collections.singletonList(new SqlTestSupport.Row(2, 2, "value-2")));
        }

        @Test
        public void test_innerJoinWithAlwaysFalseCondition() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 4);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.__key, m.this FROM " + leftName + " l JOIN " + mapName + " m ON 1 = 2", Collections.emptyList());
        }

        @Test
        public void test_innerJoinWithTypeConversion_smallerLeft() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Short.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l INNER JOIN " + mapName + " m ON l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_innerJoinWithTypeConversion_smallerRight() {
            String leftName = SqlInnerJoinTest.randomName();
            TestBatchSqlConnector.create(sqlService, leftName, 3);
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Long.TYPE, String.class);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1L, (Object)"value-1");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)2L, (Object)"value-2");
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)3L, (Object)"value-3");
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT l.v, m.this FROM " + leftName + " l INNER JOIN " + mapName + " m ON l.v = m.__key", Arrays.asList(new SqlTestSupport.Row(1, "value-1"), new SqlTestSupport.Row(2, "value-2")));
        }

        @Test
        public void test_joinSubquery() {
            String mapName = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName, Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.instance().getMap(mapName).put((Object)1, (Object)1);
            String mapName2 = SqlInnerJoinTest.randomName();
            SqlInnerJoinTest.createMapping(mapName2, Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.instance().getMap(mapName2).put((Object)1, (Object)2);
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT * FROM " + mapName + " AS m1 JOIN (SELECT * FROM " + mapName2 + ") AS m2 ON m1.__key = m2.__key", Collections.singletonList(new SqlTestSupport.Row(1, 1, 1, 2)));
        }

        @Test
        public void test_joinValues() {
            String leftName = "map";
            SqlInnerJoinTest.createMapping(leftName, Integer.TYPE, Integer.TYPE);
            SqlInnerJoinTest.instance().getMap(leftName).put((Object)1, (Object)1);
            SqlInnerJoinTest.assertRowsAnyOrder("SELECT * FROM " + leftName + " l JOIN (VALUES (1, 1)) AS r ON true", Collections.singletonList(new SqlTestSupport.Row(1, 1, (byte)1, (byte)1)));
        }

        @Test
        public void test_indexScanOnRightHandOfNestedLoopJoin() {
            String m1 = "m1_" + SqlInnerJoinTest.randomName();
            String m2 = "m2_" + SqlInnerJoinTest.randomName();
            IMap m1Map = SqlInnerJoinTest.instance().getMap(m1);
            m1Map.put((Object)42, (Object)"foo");
            m1Map.put((Object)43, (Object)"bar");
            IMap m2Map = SqlInnerJoinTest.instance().getMap(m2);
            m2Map.addIndex(IndexType.HASH, new String[]{"this"});
            m2Map.put((Object)43, (Object)"baz");
            for (int i = 44; i < 60; ++i) {
                m2Map.put((Object)i, (Object)("boo" + i));
            }
            SqlInnerJoinTest.createMapping(m1, Integer.class, String.class);
            SqlInnerJoinTest.createMapping(m2, Integer.class, String.class);
            String sql = "select * from " + m1 + " m1 join " + m2 + " m2 on m1.__key=m2.__key where m2.this='baz'";
            SqlInnerJoinTest.assertRowsAnyOrder(sql, SqlInnerJoinTest.rows(4, 43, "bar", 43, "baz"));
            for (SqlRow r : sqlService.execute("explain " + sql, new Object[0])) {
                if (!r.getObject(0).toString().contains("IndexScanMapPhysicalRel")) continue;
                return;
            }
            Assert.fail((String)"Index scan not found in the plan");
        }
    }
}

