/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.CompactSerializationConfig;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.map.IMap;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.nio.serialization.FieldKind;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlService;
import java.io.IOException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlCompactTest
extends SqlTestSupport {
    private static SqlService sqlService;
    private static SqlService clientSqlService;
    private static final String PERSON_ID_TYPE_NAME = "personId";
    private static final String PERSON_TYPE_NAME = "person";
    private static final String ALL_TYPES_TYPE_NAME = "allTypes";
    private static InternalSerializationService serializationService;

    @BeforeClass
    public static void beforeClass() {
        Config config = new Config();
        config.getJetConfig().setEnabled(true);
        CompactSerializationConfig compactSerializationConfig = config.getSerializationConfig().getCompactSerializationConfig();
        compactSerializationConfig.addSerializer((CompactSerializer)new CompactSerializer<Person>(){

            @Nonnull
            public Person read(@Nonnull CompactReader reader) {
                Person person = new Person();
                person.surname = reader.getFieldKind("surname") == FieldKind.STRING ? reader.readString("surname") : "NotAssigned";
                return person;
            }

            public void write(@Nonnull CompactWriter writer, @Nonnull Person person) {
                writer.writeString("surname", person.surname);
            }

            @Nonnull
            public String getTypeName() {
                return SqlCompactTest.PERSON_TYPE_NAME;
            }

            @Nonnull
            public Class<Person> getCompactClass() {
                return Person.class;
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        SqlCompactTest.initializeWithClient((int)1, (Config)config, (ClientConfig)clientConfig);
        sqlService = SqlCompactTest.instance().getSql();
        clientSqlService = SqlCompactTest.client().getSql();
        serializationService = com.hazelcast.jet.impl.util.Util.getSerializationService((HazelcastInstance)SqlCompactTest.instance());
    }

    @Test
    public void test_objectIsNotSupported() {
        String name = SqlCompactTest.randomName();
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING " + name + " (key_id INT , object OBJECT ) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]).updateCount()).hasMessageContaining("Cannot derive Compact type for 'OBJECT'");
    }

    @Test
    public void test_readToClassWithNonNulls() throws IOException {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " ( __key INT , b BOOLEAN , bt TINYINT , s SMALLINT , i INTEGER , l BIGINT , f REAL , d DOUBLE ) TYPE IMap OPTIONS ('keyFormat'='integer', 'valueFormat'='compact', 'valueCompactTypeName'='" + Primitives.class.getName() + "')", new Object[0]).updateCount();
        sqlService.execute("SINK INTO " + name + " VALUES (1, true, 2, 3, 4, 5, 12.321, 124.311)", new Object[0]).updateCount();
        IMap map = SqlCompactTest.client().getMap(name);
        Primitives primitives = (Primitives)map.get((Object)1);
        Assert.assertTrue((boolean)primitives.b);
        Assert.assertEquals((long)2L, (long)primitives.bt);
        Assert.assertEquals((long)3L, (long)primitives.s);
        Assert.assertEquals((long)4L, (long)primitives.i);
        Assert.assertEquals((long)5L, (long)primitives.l);
        Assert.assertEquals((double)12.321, (double)primitives.f, (double)0.1);
        Assert.assertEquals((double)124.311, (double)primitives.d, (double)0.1);
    }

    @Test
    public void test_insertNulls() throws IOException {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (__key INT , b BOOLEAN , st VARCHAR , bt TINYINT , s SMALLINT , i INTEGER , l BIGINT , bd DECIMAL , f REAL , d DOUBLE , t TIME , dt DATE , tmstmp TIMESTAMP , tmstmpTz TIMESTAMP WITH TIME ZONE ) TYPE IMap OPTIONS ('keyFormat'='integer', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]).updateCount();
        sqlService.execute("SINK INTO " + name + " VALUES (1, null, null, null, null, null, null, null, null, null, null, null, null, null )", new Object[0]).updateCount();
        Map.Entry<Data, Data> entry = SqlCompactTest.randomEntryFrom(name);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(entry.getValue());
        Assertions.assertThat((Boolean)valueRecord.getNullableBoolean("b")).isNull();
        Assertions.assertThat((String)valueRecord.getString("st")).isNull();
        Assertions.assertThat((Byte)valueRecord.getNullableInt8("bt")).isNull();
        Assertions.assertThat((Short)valueRecord.getNullableInt16("s")).isNull();
        Assertions.assertThat((Integer)valueRecord.getNullableInt32("i")).isNull();
        Assertions.assertThat((Long)valueRecord.getNullableInt64("l")).isNull();
        Assertions.assertThat((BigDecimal)valueRecord.getDecimal("bd")).isNull();
        Assertions.assertThat((Float)valueRecord.getNullableFloat32("f")).isNull();
        Assertions.assertThat((Double)valueRecord.getNullableFloat64("d")).isNull();
        Assertions.assertThat((LocalTime)valueRecord.getTime("t")).isNull();
        Assertions.assertThat((LocalDate)valueRecord.getDate("dt")).isNull();
        Assertions.assertThat((LocalDateTime)valueRecord.getTimestamp("tmstmp")).isNull();
        Assertions.assertThat((OffsetDateTime)valueRecord.getTimestampWithTimezone("tmstmpTz")).isNull();
        SqlCompactTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, null, null, null, null, null, null, null, null, null, null, null, null, null)));
    }

    @Test
    public void test_readNonNullKindsOfCompactViaSQL() {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " ( __key INT , b BOOLEAN , st VARCHAR , bt TINYINT , s SMALLINT , i INTEGER , l BIGINT , bd DECIMAL , f REAL , d DOUBLE , t TIME , dt DATE , tmstmp TIMESTAMP , tmstmpTz TIMESTAMP WITH TIME ZONE ) TYPE IMap OPTIONS ('keyFormat'='integer', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]).updateCount();
        boolean b = true;
        String st = "test";
        byte bt = 12;
        short s = 1312;
        int i = 12314;
        long l = 23214141L;
        BigDecimal bd = BigDecimal.TEN;
        float f = 1.3221321E7f;
        double d = 1.3221321213213E7;
        LocalDate dt = LocalDate.now();
        LocalTime t = LocalTime.now();
        LocalDateTime tmstmp = LocalDateTime.now();
        OffsetDateTime tmstmpTz = OffsetDateTime.now();
        GenericRecord record = GenericRecordBuilder.compact((String)PERSON_TYPE_NAME).setBoolean("b", b).setString("st", st).setInt8("bt", bt).setInt16("s", s).setInt32("i", i).setInt64("l", l).setDecimal("bd", bd).setFloat32("f", f).setFloat64("d", d).setTime("t", t).setDate("dt", dt).setTimestamp("tmstmp", tmstmp).setTimestampWithTimezone("tmstmpTz", tmstmpTz).build();
        IMap map = SqlCompactTest.client().getMap(name);
        map.put((Object)1, (Object)record);
        SqlCompactTest.assertRowsAnyOrder("SELECT * FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, b, st, bt, s, i, l, bd, Float.valueOf(f), d, t, dt, tmstmp, tmstmpTz)));
    }

    @Test
    public void test_emptyColumnListIsNotAllowed() {
        String name = SqlCompactTest.randomName();
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING " + name + " TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]).iterator().next()).hasMessageContaining("Column list is required for Compact format");
    }

    @Test
    public void test_fieldsMapping() throws IOException {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (key_id INT EXTERNAL NAME \"__key.id\", value_id INT EXTERNAL NAME \"this.id\") TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " (value_id, key_id) VALUES (2, 1)", new Object[0]);
        Map.Entry<Data, Data> entry = SqlCompactTest.randomEntryFrom(name);
        InternalGenericRecord keyRecord = serializationService.readAsInternalGenericRecord(entry.getKey());
        Assertions.assertThat((Integer)keyRecord.getNullableInt32("id")).isEqualTo(1);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(entry.getValue());
        Assertions.assertThat((Integer)valueRecord.getNullableInt32("id")).isEqualTo(2);
        SqlCompactTest.assertRowsAnyOrder("SELECT key_id, value_id FROM " + name, Collections.singletonList(new SqlTestSupport.Row(1, 2)));
    }

    @Test
    public void test_schemaEvolution_fieldAdded() {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + " (key_id INT EXTERNAL NAME \"__key.id\", name VARCHAR ) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice')", new Object[0]);
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + "(id INT EXTERNAL NAME \"__key.id\" , name VARCHAR, ssn BIGINT) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (2, 'Bob', 123456789)", new Object[0]);
        SqlCompactTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row(1, "Alice", null), new SqlTestSupport.Row(2, "Bob", 123456789L)));
    }

    @Test
    public void test_schemaEvolution_fieldRemoved() {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + "(id INT EXTERNAL NAME \"__key.id\" , name VARCHAR, ssn BIGINT ) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (1, 'Alice', 123456789)", new Object[0]);
        sqlService.execute("CREATE OR REPLACE MAPPING " + name + "(id INT EXTERNAL NAME \"__key.id\" , name VARCHAR) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        sqlService.execute("SINK INTO " + name + " VALUES (2, 'Bob')", new Object[0]);
        SqlCompactTest.assertRowsAnyOrder("SELECT * FROM " + name, Arrays.asList(new SqlTestSupport.Row(1, "Alice"), new SqlTestSupport.Row(2, "Bob")));
    }

    @Test
    public void test_allTypes() throws IOException {
        String from = SqlCompactTest.randomName();
        TestAllTypesSqlConnector.create(sqlService, from);
        String to = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + to + " ( id INT EXTERNAL NAME \"__key.id\" , \"character\" VARCHAR , string VARCHAR , \"boolean\" BOOLEAN , byte TINYINT , short SMALLINT , \"int\" INT , long BIGINT , \"float\" REAL , \"double\" DOUBLE , \"decimal\" DECIMAL , \"time\" TIME , \"date\" DATE , \"timestamp\" TIMESTAMP , timestampTz TIMESTAMP WITH TIME ZONE  ) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='allTypes')", new Object[0]);
        sqlService.execute("SINK INTO " + to + " SELECT 13, 'a', string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", timestampTz  FROM " + from + " f", new Object[0]);
        InternalGenericRecord valueRecord = serializationService.readAsInternalGenericRecord(SqlCompactTest.randomEntryFrom(to).getValue());
        Assertions.assertThat((String)valueRecord.getString("string")).isEqualTo("string");
        Assertions.assertThat((String)valueRecord.getString("character")).isEqualTo("a");
        Assertions.assertThat((Boolean)valueRecord.getNullableBoolean("boolean")).isTrue();
        Assertions.assertThat((Byte)valueRecord.getNullableInt8("byte")).isEqualTo((byte)127);
        Assertions.assertThat((Short)valueRecord.getNullableInt16("short")).isEqualTo((short)Short.MAX_VALUE);
        Assertions.assertThat((Integer)valueRecord.getNullableInt32("int")).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((Long)valueRecord.getNullableInt64("long")).isEqualTo(Long.MAX_VALUE);
        Assertions.assertThat((Float)valueRecord.getNullableFloat32("float")).isEqualTo(1.234568E9f);
        Assertions.assertThat((Double)valueRecord.getNullableFloat64("double")).isEqualTo(1.234512345678901E14);
        Assertions.assertThat((BigDecimal)valueRecord.getDecimal("decimal")).isEqualTo((Object)new BigDecimal("9223372036854775.123"));
        Assertions.assertThat((LocalTime)valueRecord.getTime("time")).isEqualTo((Object)LocalTime.of(12, 23, 34));
        Assertions.assertThat((LocalDate)valueRecord.getDate("date")).isEqualTo((Object)LocalDate.of(2020, 4, 15));
        Assertions.assertThat((LocalDateTime)valueRecord.getTimestamp("timestamp")).isEqualTo((Object)LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000));
        Assertions.assertThat((OffsetDateTime)valueRecord.getTimestampWithTimezone("timestampTz")).isEqualTo((Object)OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC));
        SqlCompactTest.assertRowsAnyOrder("SELECT * FROM " + to, Collections.singletonList(new SqlTestSupport.Row(13, "a", "string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC))));
    }

    @Test
    public void test_writingToTopLevelWhileNestedFieldMapped_implicit() {
        String mapName = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + mapName + "(__key INT, name VARCHAR) TYPE IMap\nOPTIONS (\n'keyFormat'='java'\n, 'keyJavaClass'='" + Integer.class.getName() + "'\n, 'valueFormat'='compact'\n, 'valueCompactTypeName'='person'\n)", new Object[0]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SINK INTO " + mapName + "(__key, this) VALUES(1, null)", new Object[0]).iterator().next()).hasMessageContaining("Writing to top-level fields of type OBJECT not supported");
        clientSqlService.execute("SINK INTO " + mapName + " VALUES (1, 'foo')", new Object[0]);
        Iterator resultIter = clientSqlService.execute("SELECT __key, this, name FROM " + mapName, new Object[0]).iterator();
        SqlRow row = (SqlRow)resultIter.next();
        Assert.assertEquals((long)1L, (long)((Integer)row.getObject(0)).intValue());
        SqlCompactTest.assertInstanceOf(GenericRecord.class, (Object)row.getObject(1));
        Assert.assertEquals((Object)"foo", (Object)row.getObject(2));
        Assert.assertFalse((boolean)resultIter.hasNext());
    }

    @Test
    public void test_topLevelFieldExtraction() {
        String name = SqlCompactTest.randomName();
        sqlService.execute("CREATE MAPPING " + name + "(id INT EXTERNAL NAME \"__key.id\" , name VARCHAR ) TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]);
        clientSqlService.execute("SINK INTO " + name + " (id, name) VALUES (1, 'Alice')", new Object[0]);
        Iterator rowIterator = clientSqlService.execute("SELECT __key, this FROM " + name, new Object[0]).iterator();
        SqlRow row = (SqlRow)rowIterator.next();
        Assert.assertFalse((boolean)rowIterator.hasNext());
        Assert.assertEquals((Object)GenericRecordBuilder.compact((String)PERSON_ID_TYPE_NAME).setNullableInt32("id", Integer.valueOf(1)).build(), (Object)row.getObject(0));
        Assert.assertEquals((Object)GenericRecordBuilder.compact((String)PERSON_TYPE_NAME).setString("name", "Alice").build(), (Object)row.getObject(1));
    }

    @Test
    public void when_explicitTopLevelField_then_fail_key() {
        this.when_explicitTopLevelField_then_fail("__key", "this");
    }

    @Test
    public void when_explicitTopLevelField_then_fail_this() {
        this.when_explicitTopLevelField_then_fail("this", "__key");
    }

    private void when_explicitTopLevelField_then_fail(String field, String otherField) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING map (" + field + " VARCHAR, f VARCHAR EXTERNAL NAME \"" + otherField + ".f\") TYPE IMap OPTIONS ('keyFormat'='compact', 'keyCompactTypeName'='personId', 'valueFormat'='compact', 'valueCompactTypeName'='person')", new Object[0]).iterator().next()).isInstanceOf(HazelcastSqlException.class)).hasMessage("Cannot use the '" + field + "' field with Compact serialization");
    }

    private static Map.Entry<Data, Data> randomEntryFrom(String mapName) {
        NodeEngineImpl engine = com.hazelcast.jet.impl.util.Util.getNodeEngine((HazelcastInstance)SqlCompactTest.instance());
        MapService service = (MapService)engine.getService("hz:impl:mapService");
        MapServiceContext context = service.getMapServiceContext();
        return Arrays.stream(context.getPartitionContainers()).map(partitionContainer -> partitionContainer.getExistingRecordStore(mapName)).filter(Objects::nonNull).flatMap(store -> {
            Iterator iterator = store.iterator();
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 16), false);
        }).map(entry -> Util.entry((Object)((Data)entry.getKey()), (Object)((Data)((Record)entry.getValue()).getValue()))).findFirst().get();
    }

    public static class Primitives {
        boolean b;
        byte bt;
        short s;
        int i;
        long l;
        float f;
        double d;

        public Primitives() {
        }

        public Primitives(boolean b, byte bt, short s, int i, long l, float f, double d) {
            this.b = b;
            this.bt = bt;
            this.s = s;
            this.i = i;
            this.l = l;
            this.f = f;
            this.d = d;
        }
    }

    public static class Person {
        String surname;
    }
}

