/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.serialization.impl.compact.CompactTestUtil;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecordBuilder;
import com.hazelcast.jet.Util;
import com.hazelcast.jet.sql.impl.connector.map.Metadata;
import com.hazelcast.jet.sql.impl.connector.map.SampleMetadataResolver;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.nio.serialization.VersionedPortable;
import com.hazelcast.nio.serialization.compact.CompactReader;
import com.hazelcast.nio.serialization.compact.CompactSerializer;
import com.hazelcast.nio.serialization.compact.CompactWriter;
import com.hazelcast.nio.serialization.genericrecord.GenericRecordBuilder;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelParametersRunnerFactory;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastParallelParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SampleMetadataResolverTest {
    private static final int PORTABLE_FACTORY_ID = 1;
    private static final int PORTABLE_CLASS_ID = 2;
    private static final int PORTABLE_CLASS_VERSION = 3;
    @Parameterized.Parameter
    public boolean key;

    @Parameterized.Parameters(name="key:{0}")
    public static Collection<Boolean> parameters() {
        return Arrays.asList(true, false);
    }

    @Test
    public void test_versionedPortable() {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).build();
        InternalSerializationService ss = (InternalSerializationService)new DefaultSerializationServiceBuilder().addClassDefinition(classDefinition).build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new VersionedPortableClass(), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(3))});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new VersionedPortableClass()), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(3))});
    }

    @Test
    public void test_portable() {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 0).build();
        InternalSerializationService ss = (InternalSerializationService)new DefaultSerializationServiceBuilder().addClassDefinition(classDefinition).build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new PortableClass(), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"0")});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new PortableClass()), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)"0")});
    }

    @Test
    public void test_portableRecord() {
        ClassDefinition classDefinition = new ClassDefinitionBuilder(1, 2, 3).build();
        InternalSerializationService ss = (InternalSerializationService)new DefaultSerializationServiceBuilder().addClassDefinition(classDefinition).build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new PortableGenericRecordBuilder(classDefinition).build(), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(3))});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new PortableGenericRecordBuilder(classDefinition).build()), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"portable"), Util.entry((Object)(this.key ? "keyPortableFactoryId" : "valuePortableFactoryId"), (Object)String.valueOf(1)), Util.entry((Object)(this.key ? "keyPortableClassId" : "valuePortableClassId"), (Object)String.valueOf(2)), Util.entry((Object)(this.key ? "keyPortableClassVersion" : "valuePortableClassVersion"), (Object)String.valueOf(3))});
    }

    @Test
    public void test_compact() {
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.getCompactSerializationConfig().addSerializer((CompactSerializer)new CompactClass.CompactClassSerializer());
        InternalSerializationService ss = (InternalSerializationService)new DefaultSerializationServiceBuilder().setSchemaService(CompactTestUtil.createInMemorySchemaService()).setConfig(serializationConfig).build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new CompactClass(1), (boolean)this.key);
        Assertions.assertThat((List)metadata.fields()).containsExactly((Object[])new MappingField[]{new MappingField("field", QueryDataType.INT, (this.key ? QueryPath.KEY : QueryPath.VALUE) + ".field")});
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"compact"), Util.entry((Object)(this.key ? "keyCompactTypeName" : "valueCompactTypeName"), (Object)"type-name")});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new CompactClass(1)), (boolean)this.key);
        Assertions.assertThat((List)metadata.fields()).containsExactly((Object[])new MappingField[]{new MappingField("field", QueryDataType.INT, (this.key ? QueryPath.KEY : QueryPath.VALUE) + ".field")});
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"compact"), Util.entry((Object)(this.key ? "keyCompactTypeName" : "valueCompactTypeName"), (Object)"type-name")});
    }

    @Test
    public void test_compactRecord() {
        SerializationConfig serializationConfig = new SerializationConfig();
        InternalSerializationService ss = (InternalSerializationService)new DefaultSerializationServiceBuilder().setSchemaService(CompactTestUtil.createInMemorySchemaService()).setConfig(serializationConfig).build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)GenericRecordBuilder.compact((String)"type-name").setInt32("field", 1).build(), (boolean)this.key);
        Assertions.assertThat((List)metadata.fields()).containsExactly((Object[])new MappingField[]{new MappingField("field", QueryDataType.INT, (this.key ? QueryPath.KEY : QueryPath.VALUE) + ".field")});
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"compact"), Util.entry((Object)(this.key ? "keyCompactTypeName" : "valueCompactTypeName"), (Object)"type-name")});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)GenericRecordBuilder.compact((String)"type-name").setInt32("field", 1).build()), (boolean)this.key);
        Assertions.assertThat((List)metadata.fields()).containsExactly((Object[])new MappingField[]{new MappingField("field", QueryDataType.INT, (this.key ? QueryPath.KEY : QueryPath.VALUE) + ".field")});
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"compact"), Util.entry((Object)(this.key ? "keyCompactTypeName" : "valueCompactTypeName"), (Object)"type-name")});
    }

    @Test
    public void test_json() {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new HazelcastJsonValue("{}"), (boolean)this.key);
        Assertions.assertThat((Object)metadata).isNull();
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new HazelcastJsonValue("{}")), (boolean)this.key);
        Assertions.assertThat((Object)metadata).isNull();
    }

    @Test
    public void test_java() {
        InternalSerializationService ss = new DefaultSerializationServiceBuilder().build();
        Metadata metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)new Value(), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"java"), Util.entry((Object)(this.key ? "keyJavaClass" : "valueJavaClass"), (Object)Value.class.getName())});
        metadata = SampleMetadataResolver.resolve((InternalSerializationService)ss, (Object)ss.toData((Object)new Value()), (boolean)this.key);
        Assertions.assertThat((Map)metadata.options()).containsExactly(new Map.Entry[]{Util.entry((Object)(this.key ? "keyFormat" : "valueFormat"), (Object)"java"), Util.entry((Object)(this.key ? "keyJavaClass" : "valueJavaClass"), (Object)Value.class.getName())});
    }

    private static final class VersionedPortableClass
    implements VersionedPortable {
        private VersionedPortableClass() {
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public int getClassVersion() {
            return 3;
        }

        public void writePortable(PortableWriter writer) {
        }

        public void readPortable(PortableReader reader) {
        }
    }

    private static final class PortableClass
    implements Portable {
        private PortableClass() {
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 2;
        }

        public void writePortable(PortableWriter writer) {
        }

        public void readPortable(PortableReader reader) {
        }
    }

    private static class CompactClass {
        public int field;

        private CompactClass(int field) {
            this.field = field;
        }

        private static class CompactClassSerializer
        implements CompactSerializer<CompactClass> {
            private CompactClassSerializer() {
            }

            @Nonnull
            public CompactClass read(@Nonnull CompactReader reader) {
                return new CompactClass(reader.readInt32("field"));
            }

            public void write(@Nonnull CompactWriter writer, @Nonnull CompactClass object) {
                writer.writeInt32("field", object.field);
            }

            @Nonnull
            public String getTypeName() {
                return "type-name";
            }

            @Nonnull
            public Class<CompactClass> getCompactClass() {
                return CompactClass.class;
            }
        }
    }

    private static final class Value
    implements Serializable {
        private Value() {
        }
    }
}

