/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.map;

import com.hazelcast.config.IndexConfig;
import com.hazelcast.config.IndexType;
import com.hazelcast.jet.SimpleTestInClusterSupport;
import com.hazelcast.jet.TestContextSupport;
import com.hazelcast.jet.config.JobConfig;
import com.hazelcast.jet.core.ProcessorSupplier;
import com.hazelcast.jet.core.test.TestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.ExpressionUtil;
import com.hazelcast.jet.sql.impl.connector.map.MapIndexScanP;
import com.hazelcast.jet.sql.impl.opt.FieldCollation;
import com.hazelcast.map.IMap;
import com.hazelcast.shaded.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.sql.impl.exec.scan.MapIndexScanMetadata;
import com.hazelcast.sql.impl.exec.scan.index.IndexEqualsFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilterValue;
import com.hazelcast.sql.impl.exec.scan.index.IndexRangeFilter;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.FunctionalPredicateExpression;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class MapIndexScanPTest
extends SimpleTestInClusterSupport {
    @Parameterized.Parameter
    public int count;
    private IMap<Integer, Person> map;
    private static final BiPredicate<List<?>, List<?>> LENIENT_SAME_ITEMS_IN_ORDER = (expected, actual) -> {
        if (expected.size() != actual.size()) {
            return false;
        }
        List expectedList = expected;
        List actualList = actual;
        for (int i = 0; i < expectedList.size(); ++i) {
            if (Objects.equals(expectedList.get(i), actualList.get(i))) continue;
            return false;
        }
        return true;
    };

    @Parameterized.Parameters(name="count:{0}")
    public static Collection<Integer> parameters() {
        return Arrays.asList(1000, 50000);
    }

    @BeforeClass
    public static void beforeClass() {
        MapIndexScanPTest.initialize((int)1, null);
    }

    @Before
    public void before() {
        this.map = MapIndexScanPTest.instance().getMap(MapIndexScanPTest.randomMapName());
    }

    @Test
    public void test_pointLookup_hashed() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = this.count; i > 0; --i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
        }
        expected.add(SqlTestSupport.jetRow(5, "value-5", 5));
        IndexConfig indexConfig = new IndexConfig(IndexType.HASH, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        IndexEqualsFilter filter = new IndexEqualsFilter(MapIndexScanPTest.intValue(5));
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), (IndexFilter)filter, -1, false);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    @Test
    public void test_fullScanAsc_sorted() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = this.count; i > 0; --i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
            expected.add(SqlTestSupport.jetRow(this.count - i + 1, "value-" + (this.count - i + 1), this.count - i + 1));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), null, 2, false);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    @Test
    public void test_fullScanDesc_sorted() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = 0; i <= this.count; ++i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
            expected.add(SqlTestSupport.jetRow(this.count - i, "value-" + (this.count - i), this.count - i));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), null, 2, true);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    @Test
    public void test_whenFilterExistsWithoutSpecificProjection_sorted() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = this.count; i > 0; --i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
            if (i <= this.count / 2) continue;
            expected.add(SqlTestSupport.jetRow(this.count - i + 1, "value-" + (this.count - i + 1), this.count - i + 1));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        IndexRangeFilter filter = new IndexRangeFilter(MapIndexScanPTest.intValue(0), true, MapIndexScanPTest.intValue(this.count / 2), true);
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), (IndexFilter)filter, 2, false);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    @Test
    public void test_whenBothFiltersAndSpecificProjectionExists_sorted() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = this.count; i > 0; --i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
            if (i <= this.count / 2 || i % 2 != 1) continue;
            expected.add(SqlTestSupport.jetRow(this.count - i + 1, "value-" + (this.count - i + 1), this.count - i + 1));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        FunctionalPredicateExpression remainingFilter = new FunctionalPredicateExpression(row -> {
            int value = (Integer)row.get(0);
            return value % 2 == 0;
        });
        IndexRangeFilter filter = new IndexRangeFilter(MapIndexScanPTest.intValue(0), true, MapIndexScanPTest.intValue(this.count / 2), true);
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), (IndexFilter)filter, remainingFilter, 0, false);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    @Test
    public void test_whenFilterAndSpecificProjectionExists_sorted() {
        ArrayList<JetSqlRow> expected = new ArrayList<JetSqlRow>();
        for (int i = this.count; i > 0; --i) {
            this.map.put((Object)i, (Object)new Person("value-" + i, i));
            if (i <= this.count / 2) continue;
            expected.add(SqlTestSupport.jetRow(this.count - i + 1, "value-" + (this.count - i + 1), this.count - i + 1));
        }
        IndexConfig indexConfig = new IndexConfig(IndexType.SORTED, new String[]{"age"}).setName(MapIndexScanPTest.randomName());
        this.map.addIndex(indexConfig);
        IndexRangeFilter filter = new IndexRangeFilter(MapIndexScanPTest.intValue(0), true, MapIndexScanPTest.intValue(this.count / 2), true);
        MapIndexScanMetadata metadata = this.metadata(indexConfig.getName(), (IndexFilter)filter, 0, false);
        TestSupport.verifyProcessor((ProcessorSupplier)TestContextSupport.adaptSupplier((ProcessorSupplier)MapIndexScanP.readMapIndexSupplier((MapIndexScanMetadata)metadata))).hazelcastInstance(MapIndexScanPTest.instance()).jobConfig(new JobConfig().setArgument("__sql.arguments", Collections.emptyList())).outputChecker(LENIENT_SAME_ITEMS_IN_ORDER).disableSnapshots().disableProgressAssertion().expectOutput(expected);
    }

    private MapIndexScanMetadata metadata(String indexName, IndexFilter filter, int fieldIndex, boolean descending) {
        return this.metadata(indexName, filter, null, fieldIndex, descending);
    }

    private MapIndexScanMetadata metadata(String indexName, IndexFilter filter, Expression<Boolean> reminderFilter, int fieldIndex, boolean descending) {
        return new MapIndexScanMetadata(this.map.getName(), indexName, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, Arrays.asList(QueryPath.KEY_PATH, MapIndexScanPTest.valuePath("name"), MapIndexScanPTest.valuePath("age")), Arrays.asList(QueryDataType.INT, QueryDataType.VARCHAR, QueryDataType.INT), filter, Arrays.asList(ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), ColumnExpression.create((int)1, (QueryDataType)QueryDataType.VARCHAR), ColumnExpression.create((int)2, (QueryDataType)QueryDataType.INT)), reminderFilter, fieldIndex == -1 ? null : ExpressionUtil.comparisonFn(Collections.singletonList(new FieldCollation(new RelFieldCollation(fieldIndex)))), descending);
    }

    private static QueryPath valuePath(String path) {
        return MapIndexScanPTest.path(path, false);
    }

    private static QueryPath path(String path, boolean key) {
        return new QueryPath(path, key);
    }

    private static IndexFilterValue intValue(Integer value) {
        return MapIndexScanPTest.intValue(value, false);
    }

    private static IndexFilterValue intValue(Integer value, boolean allowNull) {
        return new IndexFilterValue(Collections.singletonList(MapIndexScanPTest.constant(value, QueryDataType.INT)), Collections.singletonList(allowNull));
    }

    private static ConstantExpression constant(Object value, QueryDataType type) {
        return ConstantExpression.create((Object)value, (QueryDataType)type);
    }

    public static class Person
    implements Serializable {
        public String name;
        public int age;

        private Person() {
        }

        private Person(String name, int age) {
            this.name = name;
            this.age = age;
        }
    }
}

