/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvRowProjector;
import com.hazelcast.sql.impl.expression.ColumnExpression;
import com.hazelcast.sql.impl.expression.ConstantExpression;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.math.DivideFunction;
import com.hazelcast.sql.impl.expression.math.MultiplyFunction;
import com.hazelcast.sql.impl.extract.GenericQueryTarget;
import com.hazelcast.sql.impl.extract.GenericQueryTargetDescriptor;
import com.hazelcast.sql.impl.extract.QueryExtractor;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTarget;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class KvRowProjectorTest {
    @Test
    public void test_project() {
        KvRowProjector projector = new KvRowProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (QueryTarget)new IdentityTarget(), (QueryTarget)new IdentityTarget(), null, Arrays.asList(MultiplyFunction.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), DivideFunction.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT)), (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class));
        JetSqlRow row = projector.project((Object)1, (Object)8);
        Assertions.assertThat((Object[])row.getValues()).isEqualTo((Object)new Object[]{2, 4});
    }

    @Test
    public void test_project_onlyDataKeyAndValueIsProvided() {
        InternalSerializationService serializationService = new DefaultSerializationServiceBuilder().build();
        KvRowProjector projector = new KvRowProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (QueryTarget)new GenericQueryTarget(serializationService, null, true), (QueryTarget)new GenericQueryTarget(serializationService, null, false), null, Arrays.asList(MultiplyFunction.create((Expression)ColumnExpression.create((int)0, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT), DivideFunction.create((Expression)ColumnExpression.create((int)1, (QueryDataType)QueryDataType.INT), (Expression)ConstantExpression.create((Object)2, (QueryDataType)QueryDataType.INT), (QueryDataType)QueryDataType.INT)), SqlTestSupport.createExpressionEvalContext(new Object[0]));
        JetSqlRow row = projector.project(serializationService.toData((Object)1), serializationService.toData((Object)8));
        Assertions.assertThat((Object)row).isEqualTo((Object)SqlTestSupport.jetRow(2, 4));
    }

    @Test
    public void when_filteredByPredicate_then_returnsNull() {
        KvRowProjector projector = new KvRowProjector(new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (QueryTarget)new IdentityTarget(), (QueryTarget)new IdentityTarget(), (Expression)ConstantExpression.create((Object)Boolean.FALSE, (QueryDataType)QueryDataType.BOOLEAN), Collections.emptyList(), (ExpressionEvalContext)Mockito.mock(ExpressionEvalContext.class));
        JetSqlRow row = projector.project((Object)1, (Object)8);
        Assertions.assertThat((Object)row).isNull();
    }

    @Test
    public void test_supplierSerialization() {
        InternalSerializationService serializationService = new DefaultSerializationServiceBuilder().build();
        KvRowProjector.Supplier original = KvRowProjector.supplier((QueryPath[])new QueryPath[]{QueryPath.KEY_PATH, QueryPath.VALUE_PATH}, (QueryDataType[])new QueryDataType[]{QueryDataType.INT, QueryDataType.INT}, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (QueryTargetDescriptor)GenericQueryTargetDescriptor.DEFAULT, (Expression)ConstantExpression.create((Object)Boolean.FALSE, (QueryDataType)QueryDataType.BOOLEAN), Arrays.asList(ConstantExpression.create((Object)1, (QueryDataType)QueryDataType.INT), ConstantExpression.create((Object)"2", (QueryDataType)QueryDataType.INT)));
        KvRowProjector.Supplier serialized = (KvRowProjector.Supplier)serializationService.toObject((Object)serializationService.toData((Object)original));
        Assertions.assertThat((Object)serialized).isEqualToComparingFieldByField((Object)original);
    }

    private static final class IdentityTarget
    implements QueryTarget {
        private Object value;

        private IdentityTarget() {
        }

        public void setTarget(Object value, Data valueData) {
            this.value = value;
        }

        public QueryExtractor createExtractor(String path, QueryDataType type) {
            return () -> this.value;
        }
    }
}

