/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.jet.sql.impl.CalciteSqlOptimizer;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolver;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataResolvers;
import com.hazelcast.jet.sql.impl.schema.AbstractRelationsStorage;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.shaded.com.google.common.collect.ImmutableMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.InternalSqlService;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnitParamsRunner.class)
public class KvMetadataResolversTest {
    private KvMetadataResolvers resolvers;
    @Mock
    private KvMetadataResolver resolver;
    @Mock
    private CalciteSqlOptimizer optimizer;
    @Mock
    private AbstractRelationsStorage relationsStorage;
    @Mock
    private InternalSqlService sqlService;
    @Mock
    private NodeEngine nodeEngine;
    @Mock
    private InternalSerializationService ss;
    private AutoCloseable openMocks;

    @Before
    public void setUp() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
        BDDMockito.given((Object)this.nodeEngine.getSerializationService()).willReturn((Object)this.ss);
        BDDMockito.given((Object)this.resolver.supportedFormats()).willAnswer(invocationOnMock -> Stream.of("java"));
        BDDMockito.given((Object)this.nodeEngine.getSqlService()).willReturn((Object)this.sqlService);
        BDDMockito.given((Object)this.sqlService.getOptimizer()).willReturn((Object)this.optimizer);
        BDDMockito.given((Object)this.optimizer.relationsStorage()).willReturn((Object)this.relationsStorage);
        this.resolvers = new KvMetadataResolvers(new KvMetadataResolver[]{this.resolver});
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    @Parameters(value={"__key", "this"})
    public void when_renamedKeyOrThis_then_throws(String fieldName) {
        MappingField field = KvMetadataResolversTest.field(fieldName, QueryDataType.INT, "renamed");
        Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.singletonList(field), Collections.emptyMap(), this.nodeEngine)).hasMessage("Cannot rename field: '" + fieldName + "'");
    }

    @Test
    public void when_invalidExternalName_then_throws() {
        MappingField field = KvMetadataResolversTest.field("field_name", QueryDataType.INT, "invalid_prefix.name");
        Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.singletonList(field), Collections.emptyMap(), this.nodeEngine)).hasMessage("Invalid external name: invalid_prefix.name");
    }

    @Test
    public void test_resolveAndValidateFields() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("__key", QueryDataType.INT)));
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("this", QueryDataType.VARCHAR)));
        List fields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), (Map)options, this.nodeEngine);
        Assertions.assertThat((List)fields).containsExactly((Object[])new MappingField[]{KvMetadataResolversTest.field("__key", QueryDataType.INT), KvMetadataResolversTest.field("this", QueryDataType.VARCHAR)});
    }

    @Test
    public void when_keyOrThisNameIsUsed_then_itIsFilteredOut() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("__key", QueryDataType.INT, "__key.name"), KvMetadataResolversTest.field("keyField", QueryDataType.INT, "__key.__keyField")));
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("this", QueryDataType.VARCHAR, "this.name"), KvMetadataResolversTest.field("thisField", QueryDataType.VARCHAR, "this.thisField")));
        List fields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), (Map)options, this.nodeEngine);
        Assertions.assertThat((List)fields).containsExactly((Object[])new MappingField[]{KvMetadataResolversTest.field("keyField", QueryDataType.INT, "__key.__keyField"), KvMetadataResolversTest.field("thisField", QueryDataType.VARCHAR, "this.thisField")});
    }

    @Test
    public void when_keyClashesWithValue_then_keyIsChosen() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("field", QueryDataType.INT, "__key.field")));
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("field", QueryDataType.VARCHAR, "this.field")));
        List fields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), (Map)options, this.nodeEngine);
        Assertions.assertThat((List)fields).containsExactly((Object[])new MappingField[]{KvMetadataResolversTest.field("field", QueryDataType.INT, "__key.field")});
    }

    @Test
    public void when_keyFieldsEmpty_then_doesNotFail() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.empty());
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("this", QueryDataType.INT)));
        List fields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), (Map)options, this.nodeEngine);
        Assertions.assertThat((List)fields).containsExactly((Object[])new MappingField[]{KvMetadataResolversTest.field("this", QueryDataType.INT)});
    }

    @Test
    public void when_valueFieldsEmpty_then_doesNotFail() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.of(KvMetadataResolversTest.field("__key", QueryDataType.INT)));
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.empty());
        List fields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), (Map)options, this.nodeEngine);
        Assertions.assertThat((List)fields).containsExactly((Object[])new MappingField[]{KvMetadataResolversTest.field("__key", QueryDataType.INT)});
    }

    @Test
    public void when_keyAndValueFieldsEmpty_then_throws() {
        ImmutableMap options = ImmutableMap.of((Object)"keyFormat", (Object)"java", (Object)"valueFormat", (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)true), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.empty());
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(ArgumentMatchers.eq((boolean)false), (List)ArgumentMatchers.eq(Collections.emptyList()), (Map)ArgumentMatchers.eq((Object)options), (InternalSerializationService)ArgumentMatchers.eq((Object)this.ss))).willReturn(Stream.empty());
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$when_keyAndValueFieldsEmpty_then_throws$3((Map)options)).isInstanceOf(QueryException.class)).hasMessageContaining("The resolved field list is empty");
    }

    @Test
    public void when_formatIsMissingInOptionsWhileResolvingFields_then_throws() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.emptyList(), Collections.emptyMap(), this.nodeEngine)).isInstanceOf(QueryException.class)).hasMessageContaining("Missing 'keyFormat' option");
    }

    @Test
    @Parameters(value={"true", "false"})
    public void test_resolveMetadata(boolean key) {
        ImmutableMap options = ImmutableMap.of((Object)(key ? "keyFormat" : "valueFormat"), (Object)"java");
        BDDMockito.given((Object)this.resolver.resolveMetadata(key, Collections.emptyList(), (Map)options, this.ss)).willReturn((Object)((KvMetadata)Mockito.mock(KvMetadata.class)));
        KvMetadata metadata = this.resolvers.resolveMetadata(key, Collections.emptyList(), (Map)options, this.ss);
        Assertions.assertThat((Object)metadata).isNotNull();
    }

    @Test
    @Parameters(value={"true", "false"})
    public void when_formatIsMissingInOptionsWhileResolvingMetadata_then_throws(boolean key) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resolvers.resolveMetadata(key, Collections.emptyList(), Collections.emptyMap(), this.ss)).isInstanceOf(QueryException.class)).hasMessageMatching("Missing '(key|value)Format' option");
    }

    private static MappingField field(String name, QueryDataType type) {
        return KvMetadataResolversTest.field(name, type, name);
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }

    private /* synthetic */ void lambda$when_keyAndValueFieldsEmpty_then_throws$3(Map options) throws Throwable {
        this.resolvers.resolveAndValidateFields(Collections.emptyList(), options, this.nodeEngine);
    }
}

