/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.keyvalue;

import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadata;
import com.hazelcast.jet.sql.impl.connector.keyvalue.KvMetadataAvroResolver;
import com.hazelcast.jet.sql.impl.extract.AvroQueryTargetDescriptor;
import com.hazelcast.jet.sql.impl.inject.AvroUpsertTargetDescriptor;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.map.MapTableField;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class KvMetadataAvroResolverTest {
    @Parameterized.Parameter(value=0)
    public boolean isKey;
    @Parameterized.Parameter(value=1)
    public String prefix;

    @Parameterized.Parameters(name="{1}")
    public static Object[] parameters() {
        return new Object[][]{{true, "__key"}, {false, "this"}};
    }

    @Test
    public void test_resolveFields() {
        Stream fields = KvMetadataAvroResolver.INSTANCE.resolveAndValidateFields(this.isKey, List.of(this.field("field", QueryDataType.INT)), Collections.emptyMap(), null);
        Assertions.assertThat((Stream)fields).containsExactly((Object[])new MappingField[]{this.field("field", QueryDataType.INT)});
    }

    @Test
    public void when_noKeyOrThisPrefixInExternalName_then_usesValue() {
        Object[] objectArray;
        KvMetadata metadata = KvMetadataAvroResolver.INSTANCE.resolveMetadata(this.isKey, List.of(KvMetadataAvroResolverTest.field("field", QueryDataType.INT, "extField")), Collections.emptyMap(), null);
        ListAssert listAssert = Assertions.assertThat((List)metadata.getFields());
        if (this.isKey) {
            Object[] objectArray2 = new MapTableField[1];
            objectArray = objectArray2;
            objectArray2[0] = new MapTableField("__key", QueryDataType.OBJECT, true, QueryPath.KEY_PATH);
        } else {
            MapTableField[] mapTableFieldArray = new MapTableField[2];
            mapTableFieldArray[0] = new MapTableField("field", QueryDataType.INT, false, new QueryPath("extField", false));
            objectArray = mapTableFieldArray;
            mapTableFieldArray[1] = new MapTableField("this", QueryDataType.OBJECT, true, QueryPath.VALUE_PATH);
        }
        listAssert.containsExactly(objectArray);
    }

    @Test
    public void when_duplicateExternalName_then_throws() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> KvMetadataAvroResolver.INSTANCE.resolveAndValidateFields(this.isKey, List.of(KvMetadataAvroResolverTest.field("field1", QueryDataType.INT, this.prefix + ".field"), KvMetadataAvroResolverTest.field("field2", QueryDataType.VARCHAR, this.prefix + ".field")), Collections.emptyMap(), null)).isInstanceOf(QueryException.class)).hasMessageMatching("Duplicate external name: (__key|this).field");
    }

    @Test
    public void when_schemaIsNotRecord_then_throws() {
        Assertions.assertThatThrownBy(() -> KvMetadataAvroResolver.INSTANCE.resolveAndValidateFields(this.isKey, List.of(this.field("field", QueryDataType.INT)), Map.of(this.isKey ? "keyAvroSchema" : "valueAvroSchema", Schema.create((Schema.Type)Schema.Type.INT).toString()), null)).hasMessage("Schema must be an Avro record");
    }

    @Test
    public void when_inlineSchemaUsedWithSchemaRegistry_then_throws() {
        Assertions.assertThatThrownBy(() -> KvMetadataAvroResolver.INSTANCE.resolveAndValidateFields(this.isKey, List.of(this.field("field", QueryDataType.INT)), Map.of(this.isKey ? "keyAvroSchema" : "valueAvroSchema", ((Schema)SchemaBuilder.record((String)"jet.sql").fields().optionalInt("field").endRecord()).toString(), "schema.registry.url", "http://localhost:8081"), null)).hasMessage("Inline schema cannot be used with schema registry");
    }

    @Test
    public void when_schemaHasUnsupportedType_then_fieldResolutionFails() {
        List<Schema> unsupportedSchemaTypes = List.of(Schema.create((Schema.Type)Schema.Type.BYTES), (Schema)SchemaBuilder.array().items(Schema.create((Schema.Type)Schema.Type.INT)), (Schema)SchemaBuilder.map().values(Schema.create((Schema.Type)Schema.Type.INT)), (Schema)SchemaBuilder.enumeration((String)"enum").symbols(new String[]{"symbol"}), (Schema)SchemaBuilder.fixed((String)"fixed").size(0));
        for (Schema schema : unsupportedSchemaTypes) {
            Assertions.assertThatThrownBy(() -> KvMetadataAvroResolver.INSTANCE.resolveAndValidateFields(this.isKey, Collections.emptyList(), Map.of(this.isKey ? "keyAvroSchema" : "valueAvroSchema", ((Schema)SchemaBuilder.record((String)"jet.sql").fields().name("field").type(schema).noDefault().endRecord()).toString()), null).toArray()).hasMessage("Unsupported schema type: " + String.valueOf(schema.getType()));
        }
    }

    @Test
    public void test_resolveMetadata() {
        KvMetadata metadata = KvMetadataAvroResolver.INSTANCE.resolveMetadata(this.isKey, List.of(this.field("string", QueryDataType.VARCHAR), this.field("boolean", QueryDataType.BOOLEAN), this.field("byte", QueryDataType.TINYINT), this.field("short", QueryDataType.SMALLINT), this.field("int", QueryDataType.INT), this.field("long", QueryDataType.BIGINT), this.field("float", QueryDataType.REAL), this.field("double", QueryDataType.DOUBLE), this.field("decimal", QueryDataType.DECIMAL), this.field("time", QueryDataType.TIME), this.field("date", QueryDataType.DATE), this.field("timestamp", QueryDataType.TIMESTAMP), this.field("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME), this.field("object", QueryDataType.OBJECT)), Collections.emptyMap(), null);
        Assertions.assertThat((List)metadata.getFields()).containsExactly((Object[])new TableField[]{new MapTableField("string", QueryDataType.VARCHAR, false, QueryPath.create((String)(this.prefix + ".string"))), new MapTableField("boolean", QueryDataType.BOOLEAN, false, QueryPath.create((String)(this.prefix + ".boolean"))), new MapTableField("byte", QueryDataType.TINYINT, false, QueryPath.create((String)(this.prefix + ".byte"))), new MapTableField("short", QueryDataType.SMALLINT, false, QueryPath.create((String)(this.prefix + ".short"))), new MapTableField("int", QueryDataType.INT, false, QueryPath.create((String)(this.prefix + ".int"))), new MapTableField("long", QueryDataType.BIGINT, false, QueryPath.create((String)(this.prefix + ".long"))), new MapTableField("float", QueryDataType.REAL, false, QueryPath.create((String)(this.prefix + ".float"))), new MapTableField("double", QueryDataType.DOUBLE, false, QueryPath.create((String)(this.prefix + ".double"))), new MapTableField("decimal", QueryDataType.DECIMAL, false, QueryPath.create((String)(this.prefix + ".decimal"))), new MapTableField("time", QueryDataType.TIME, false, QueryPath.create((String)(this.prefix + ".time"))), new MapTableField("date", QueryDataType.DATE, false, QueryPath.create((String)(this.prefix + ".date"))), new MapTableField("timestamp", QueryDataType.TIMESTAMP, false, QueryPath.create((String)(this.prefix + ".timestamp"))), new MapTableField("timestampTz", QueryDataType.TIMESTAMP_WITH_TZ_OFFSET_DATE_TIME, false, QueryPath.create((String)(this.prefix + ".timestampTz"))), new MapTableField("object", QueryDataType.OBJECT, false, QueryPath.create((String)(this.prefix + ".object"))), new MapTableField(this.prefix, QueryDataType.OBJECT, true, QueryPath.create((String)this.prefix))});
        Assertions.assertThat((Object)metadata.getQueryTargetDescriptor()).isEqualTo((Object)AvroQueryTargetDescriptor.INSTANCE);
        Assertions.assertThat((Object)metadata.getUpsertTargetDescriptor()).isEqualToComparingFieldByField((Object)new AvroUpsertTargetDescriptor((Schema)SchemaBuilder.record((String)"jet.sql").fields().optionalString("string").optionalBoolean("boolean").optionalInt("byte").optionalInt("short").optionalInt("int").optionalLong("long").optionalFloat("float").optionalDouble("double").optionalString("decimal").optionalString("time").optionalString("date").optionalString("timestamp").optionalString("timestampTz").name("object").type(KvMetadataAvroResolver.Schemas.OBJECT_SCHEMA).withDefault(null).endRecord()));
    }

    private MappingField field(String name, QueryDataType type) {
        return new MappingField(name, type, this.prefix + "." + name);
    }

    private static MappingField field(String name, QueryDataType type, String externalName) {
        return new MappingField(name, type, externalName);
    }
}

