/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.mysql;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcTable;
import com.hazelcast.jet.sql.impl.connector.jdbc.mysql.MySQLUpsertQueryBuilder;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlDialect;
import com.hazelcast.shaded.org.apache.calcite.sql.dialect.MysqlSqlDialect;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MySQLUpsertQueryBuilderTest {
    @Mock
    JdbcTable jdbcTable;
    SqlDialect dialect = MysqlSqlDialect.DEFAULT;

    MySQLUpsertQueryBuilderTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)this.jdbcTable.getExternalNameList()).thenReturn(Collections.singletonList("table1"));
        Mockito.when((Object)this.jdbcTable.dbFieldNames()).thenReturn(Arrays.asList("field1", "field2"));
    }

    @Test
    void appendInsertClause() {
        MySQLUpsertQueryBuilder builder = new MySQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendInsertClause(sb);
        String insertClause = sb.toString();
        Assertions.assertThat((String)insertClause).isEqualTo("INSERT INTO `table1` (`field1`,`field2`)");
    }

    @Test
    void appendValuesClause() {
        MySQLUpsertQueryBuilder builder = new MySQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendValuesClause(sb);
        String valuesClause = sb.toString();
        Assertions.assertThat((String)valuesClause).isEqualTo("VALUES (?,?)");
    }

    @Test
    void appendOnDuplicateClause() {
        MySQLUpsertQueryBuilder builder = new MySQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        StringBuilder sb = new StringBuilder();
        builder.appendOnDuplicateClause(sb);
        String valuesClause = sb.toString();
        Assertions.assertThat((String)valuesClause).isEqualTo("ON DUPLICATE KEY UPDATE `field1` = VALUES(`field1`),`field2` = VALUES(`field2`)");
    }

    @Test
    void query() {
        MySQLUpsertQueryBuilder builder = new MySQLUpsertQueryBuilder(this.jdbcTable, this.dialect);
        String result = builder.query();
        Assertions.assertThat((String)result).isEqualTo("INSERT INTO `table1` (`field1`,`field2`) VALUES (?,?) ON DUPLICATE KEY UPDATE `field1` = VALUES(`field1`),`field2` = VALUES(`field2`)");
    }
}

