/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc.join;

import com.hazelcast.jet.sql.impl.connector.jdbc.join.FullScanResultSetIterator;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

class FullScanResultSetIteratorTest {
    private static final String EMPTY_RESULT = "EMPTY_RESULT";
    private static final H2DatabaseProvider h2DatabaseProvider = new H2DatabaseProvider();
    private static String dbConnectionUrl;

    FullScanResultSetIteratorTest() {
    }

    @BeforeAll
    static void beforeAll() {
        dbConnectionUrl = h2DatabaseProvider.createDatabase(FullScanResultSetIteratorTest.class.getName());
    }

    @AfterAll
    static void afterAll() {
        h2DatabaseProvider.shutdown();
    }

    @Test
    void testEmptyResultSetMapperIsCalled() throws SQLException {
        try (Connection connection = DriverManager.getConnection(dbConnectionUrl);){
            String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'table_does_not_exist'";
            FullScanResultSetIterator iterator = new FullScanResultSetIterator(connection, sql, this::rowMapper, () -> EMPTY_RESULT);
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                tableNameList.add((String)iterator.next());
            }
            Assertions.assertThat(tableNameList).containsExactly((Object[])new String[]{EMPTY_RESULT});
            Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            Assertions.assertThatThrownBy(() -> ((FullScanResultSetIterator)iterator).next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Test
    void testEmptyResultSetMapperReturnsNull() throws SQLException {
        try (Connection connection = DriverManager.getConnection(dbConnectionUrl);){
            String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'table_does_not_exist'";
            FullScanResultSetIterator iterator = new FullScanResultSetIterator(connection, sql, this::rowMapper, () -> null);
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                tableNameList.add((String)iterator.next());
            }
            Assertions.assertThat(tableNameList).isEmpty();
            Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            Assertions.assertThatThrownBy(() -> ((FullScanResultSetIterator)iterator).next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    @Test
    void testRowMapperIsCalled() throws SQLException {
        List<String> expectedTables = List.of("VIEWS", "TABLES", "ROLES", "USERS");
        try (Connection connection = DriverManager.getConnection(dbConnectionUrl);){
            String sql = "SELECT * FROM INFORMATION_SCHEMA.TABLES";
            FullScanResultSetIterator<String> iterator = this.createIterator(connection, sql);
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (iterator.hasNext()) {
                tableNameList.add((String)iterator.next());
            }
            Assertions.assertThat(tableNameList).containsAll(expectedTables);
            Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
            Assertions.assertThatThrownBy(() -> iterator.next()).isInstanceOf(NoSuchElementException.class);
        }
    }

    private FullScanResultSetIterator<String> createIterator(Connection connection, String sql) {
        return new FullScanResultSetIterator(connection, sql, this::rowMapper, () -> EMPTY_RESULT);
    }

    private String rowMapper(ResultSet resultSet) {
        try {
            return resultSet.getString("TABLE_NAME");
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

