/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.Collection;
import java.util.List;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SelectJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        SelectJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = SelectJdbcSqlConnectorTest.randomTableName();
        SelectJdbcSqlConnectorTest.createTable(this.tableName);
        SelectJdbcSqlConnectorTest.insertItems(this.tableName, 5);
        SelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void selectAllFromTable() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    @Test
    public void selectColumnFromTable() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT id AS c FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0), new SqlTestSupport.Row(1), new SqlTestSupport.Row(2), new SqlTestSupport.Row(3), new SqlTestSupport.Row(4)}));
    }

    @Test
    public void selectConcatExpressionFromTable() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT id||'-'||name AS c FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("0-name-0"), new SqlTestSupport.Row("1-name-1"), new SqlTestSupport.Row("2-name-2"), new SqlTestSupport.Row("3-name-3"), new SqlTestSupport.Row("4-name-4")}));
    }

    @Test
    public void selectColumnAsFromTable() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT id AS person_id FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0), new SqlTestSupport.Row(1), new SqlTestSupport.Row(2), new SqlTestSupport.Row(3), new SqlTestSupport.Row(4)}));
    }

    @Test
    public void selectColumnWithExternalNameFromTable() throws Exception {
        this.tableName = SelectJdbcSqlConnectorTest.randomTableName();
        SelectJdbcSqlConnectorTest.createTable(this.tableName);
        SelectJdbcSqlConnectorTest.insertItems(this.tableName, 5);
        SelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT id,fullName FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    @Test
    public void selectAllFromTableWhereIdColumn() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " WHERE id = ?", (List<Object>)Lists.newArrayList((Object[])new Object[]{0}), (Collection<SqlTestSupport.Row>)Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0")}));
    }

    @Test
    public void selectFromTableWhereColumnWithExternalName() throws Exception {
        this.tableName = SelectJdbcSqlConnectorTest.randomTableName();
        SelectJdbcSqlConnectorTest.createTable(this.tableName);
        SelectJdbcSqlConnectorTest.insertItems(this.tableName, 5);
        SelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " WHERE fullName = 'name-0'", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0")}));
    }

    @Test
    public void selectColumnDifferentTypeInMappingAndTable() throws Exception {
        this.tableName = SelectJdbcSqlConnectorTest.randomTableName();
        SelectJdbcSqlConnectorTest.createTable(this.tableName);
        SelectJdbcSqlConnectorTest.insertItems(this.tableName, 5);
        SelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id VARCHAR,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName, Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("0", "name-0"), new SqlTestSupport.Row("1", "name-1"), new SqlTestSupport.Row("2", "name-2"), new SqlTestSupport.Row("3", "name-3"), new SqlTestSupport.Row("4", "name-4")}));
    }

    @Test
    public void selectAllFromTableWhereIdIn() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " WHERE id IN (?, ?, ?) ", (List<Object>)Lists.newArrayList((Object[])new Object[]{0, 1, 2}), (Collection<SqlTestSupport.Row>)Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2")}));
    }

    @Test
    public void selectFromEmptyTable() throws Exception {
        String emptyTableName = SelectJdbcSqlConnectorTest.randomTableName();
        SelectJdbcSqlConnectorTest.createTable(emptyTableName);
        SelectJdbcSqlConnectorTest.execute("CREATE MAPPING " + emptyTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + emptyTableName, Lists.emptyList());
    }

    @Test
    public void selectFromTableWhereClauseDoesNotMatchAnyResult() {
        SelectJdbcSqlConnectorTest.assertRowsAnyOrder("SELECT * FROM " + this.tableName + " WHERE id = ?", (List<Object>)Lists.newArrayList((Object[])new Object[]{42}), (Collection<SqlTestSupport.Row>)Lists.emptyList());
    }
}

