/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.dataconnection.impl.JdbcDataConnection;
import com.hazelcast.dataconnection.impl.JdbcDataConnectionTest;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcInnerEquiJoinTest
extends JdbcSqlTestSupport {
    private static final int ITEM_COUNT = 5;
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        JdbcInnerEquiJoinTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(this.tableName);
        JdbcInnerEquiJoinTest.insertItems(this.tableName, 5);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    private static String getInsertSQL(String tableName, int id, String workerName) {
        return String.format("INSERT INTO %s VALUES(%d, '%s')", tableName, id, workerName);
    }

    @Test
    public void joinWithTableValuedFunction_traverser_is_closed() throws Exception {
        String jdbcDataConnection = "jdbc_data_connection";
        JdbcInnerEquiJoinTest.execute("CREATE DATA CONNECTION " + jdbcDataConnection + " TYPE Jdbc OPTIONS('jdbcUrl'= '" + dbConnectionUrl + "', 'maximumPoolSize'='64')", new Object[0]);
        int count = 10000;
        String tableName0 = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(tableName0);
        JdbcInnerEquiJoinTest.insertItems(tableName0, count);
        DataSource dataSource0 = JdbcInnerEquiJoinTest.getDataSource(0, jdbcDataConnection);
        DataSource dataSource1 = JdbcInnerEquiJoinTest.getDataSource(1, jdbcDataConnection);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + tableName0 + " ( id INT,  name VARCHAR ) DATA CONNECTION " + jdbcDataConnection, new Object[0]);
        List<SqlRow> actualList = this.getRows("SELECT n.id, n.name, t.v FROM (SELECT v FROM TABLE(generate_stream(1000)) WHERE v > 0) t JOIN " + tableName0 + " n ON n.id % t.v = 0 LIMIT 2");
        Assertions.assertThat(actualList).hasSize(2);
        JdbcInnerEquiJoinTest.execute("DROP DATA CONNECTION " + jdbcDataConnection, new Object[0]);
        JdbcInnerEquiJoinTest.assertTrueEventually((String)"dataSources should be closed", () -> {
            Assertions.assertThat((boolean)JdbcDataConnectionTest.isClosed((DataSource)dataSource0)).isTrue();
            Assertions.assertThat((boolean)JdbcDataConnectionTest.isClosed((DataSource)dataSource1)).isTrue();
        }, (long)10L);
    }

    private static DataSource getDataSource(int instanceNumber, String dataConnectionName) {
        JdbcDataConnection jdbcDataConnection = (JdbcDataConnection)JdbcInnerEquiJoinTest.getDataConnectionService((HazelcastInstance)JdbcInnerEquiJoinTest.instances()[instanceNumber]).getAndRetainDataConnection(dataConnectionName, JdbcDataConnection.class);
        DataSource dataSource = JdbcDataConnectionTest.pooledDataSource((JdbcDataConnection)jdbcDataConnection);
        jdbcDataConnection.release();
        return dataSource;
    }

    @Test
    public void joinWithOtherJdbc() throws SQLException {
        String otherTableName = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName);
        JdbcInnerEquiJoinTest.insertItems(otherTableName, 5);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.id = t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    private String getDummyTable1Sql(String tableName, int id, String name) {
        return String.format("INSERT INTO %s (id,name) VALUES(%d,%s)", tableName, id, name);
    }

    @Test
    public void joinWithOtherJdbc_Right_Side_Has_Different_Mapping_Order() throws SQLException {
        String otherTableName1 = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName1, "id INT PRIMARY KEY", "name VARCHAR(10)", "dummy1 VARCHAR(10) DEFAULT 'dummy1'", "dummy2 VARCHAR(10) DEFAULT 'dummy2'");
        String sql = this.getDummyTable1Sql(otherTableName1, 1, "'Alice'");
        JdbcInnerEquiJoinTest.executeJdbc(sql);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName1 + " ( id INT,  dummy1 VARCHAR , dummy2 VARCHAR , name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        sql = this.getDummyTable1Sql(otherTableName1, 2, "'Bob'");
        JdbcInnerEquiJoinTest.executeJdbc(sql);
        String otherTableName2 = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName2, "id INT PRIMARY KEY", "dummy1 VARCHAR(10) DEFAULT 'dummy1'", "dummy2 VARCHAR(10) DEFAULT 'dummy2'", "name VARCHAR(10)");
        sql = this.getDummyTable1Sql(otherTableName2, 1, "'Alice'");
        JdbcInnerEquiJoinTest.executeJdbc(sql);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName2 + " ( name VARCHAR , id INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.dummy1, t1.dummy2, t1.id, t2.name FROM " + otherTableName1 + " t1 JOIN " + otherTableName2 + " t2    ON t1.id = t2.id AND t1.name = t2.name", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("dummy1", "dummy2", 1, "Alice")}));
    }

    @Test
    public void joinWithOtherJdbcWhereClause() throws SQLException {
        String otherTableName = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName);
        JdbcInnerEquiJoinTest.insertItems(otherTableName, 5);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.id = t2.id AND t1.name = t2.name WHERE t1.id > 0", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    @Test
    public void joinWithOtherJdbcWhereClauseOnRightSideColumn() throws SQLException {
        String otherTableName = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName);
        JdbcInnerEquiJoinTest.insertItems(otherTableName, 5);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.id = t2.id AND t1.name = t2.name WHERE t2.id > 0", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    @Test
    public void joinWithOtherJdbc_right_Side_Has_Less_Rows() throws SQLException {
        String otherTableName = JdbcInnerEquiJoinTest.randomTableName();
        JdbcInnerEquiJoinTest.createTable(otherTableName);
        String sql = JdbcInnerEquiJoinTest.getInsertSQL(otherTableName, 1, "name-1");
        JdbcInnerEquiJoinTest.executeJdbc(sql);
        sql = JdbcInnerEquiJoinTest.getInsertSQL(otherTableName, 3, "name-1");
        JdbcInnerEquiJoinTest.executeJdbc(sql);
        JdbcInnerEquiJoinTest.execute("CREATE MAPPING " + otherTableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.name, t1.id, t2.id FROM " + this.tableName + " t1 JOIN " + otherTableName + " t2    ON t1.name = t2.name", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row("name-1", 1, 1), new SqlTestSupport.Row("name-1", 1, 3)}));
    }

    @Test
    public void joinWithOtherJdbcNonDefaultSchema() throws SQLException {
        String schemaName = JdbcInnerEquiJoinTest.randomName();
        JdbcInnerEquiJoinTest.executeJdbc("CREATE SCHEMA " + schemaName);
        String fullyQualifiedTable = JdbcInnerEquiJoinTest.quote(schemaName, this.tableName);
        JdbcInnerEquiJoinTest.createTableNoQuote(fullyQualifiedTable);
        JdbcInnerEquiJoinTest.insertItemsNoQuote(fullyQualifiedTable, 5);
        String mappingName = JdbcInnerEquiJoinTest.randomTableName();
        String fullyQualifiedExternalName = QueryUtils.quoteCompoundIdentifier((String[])new String[]{schemaName, this.tableName});
        JdbcInnerEquiJoinTest.createMapping(fullyQualifiedExternalName, mappingName);
        JdbcInnerEquiJoinTest.assertRowsAnyOrder("SELECT t1.id, t2.name FROM " + this.tableName + " t1 JOIN \"" + mappingName + "\" t2    ON t1.id = t2.id", Lists.newArrayList((Object[])new SqlTestSupport.Row[]{new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4")}));
    }

    private List<SqlRow> getRows(String sql) {
        ArrayList<SqlRow> actualList = new ArrayList<SqlRow>();
        try (SqlResult sqlResult = sqlService.execute(sql, new Object[0]);){
            Iterator iterator = sqlResult.iterator();
            iterator.forEachRemaining(actualList::add);
        }
        return actualList;
    }
}

