/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.genericrecord.GenericRecord;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class JdbcIMapTest
extends JdbcSqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        JdbcIMapTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Test
    public void insertIntoIMapSelectFromJdbc() throws Exception {
        String tableName = JdbcIMapTest.randomTableName();
        JdbcIMapTest.createTable(tableName);
        JdbcIMapTest.insertItems(tableName, 5);
        JdbcIMapTest.execute("CREATE MAPPING " + tableName + " ( id INT,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        JdbcIMapTest.execute("CREATE MAPPING my_map ( __key INT, id INT, name VARCHAR ) TYPE IMap OPTIONS (    'keyFormat' = 'int',    'valueFormat' = 'compact',\n    'valueCompactTypeName' = 'person')", new Object[0]);
        JdbcIMapTest.execute("INSERT INTO my_map SELECT id AS __key,id,name FROM " + tableName, new Object[0]);
        IMap map = JdbcIMapTest.instance().getMap("my_map");
        Assertions.assertThat((Map)map).hasSize(5);
        GenericRecord record = (GenericRecord)map.get(1);
        Assertions.assertThat((int)record.getInt32("id")).isEqualTo(1);
        Assertions.assertThat((String)record.getString("name")).isEqualTo("name-1");
    }
}

