/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class InsertJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    protected String tableName;

    @BeforeClass
    public static void beforeClass() {
        InsertJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = InsertJdbcSqlConnectorTest.randomTableName();
        String schemaName = InsertJdbcSqlConnectorTest.randomName();
        InsertJdbcSqlConnectorTest.executeJdbc("CREATE SCHEMA " + schemaName);
    }

    @Test
    public void insertIntoTable() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.createMapping(this.tableName);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void insertIntoTableWithExternalName() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        String mappingName = "mapping_" + InsertJdbcSqlConnectorTest.randomName();
        InsertJdbcSqlConnectorTest.createMapping(this.tableName, mappingName);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + mappingName + " VALUES (0, 'name-0')", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void insertIntoTableColumnHasExternalName() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }

    @Test
    public void insertIntoTableWithColumns() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.createMapping(this.tableName);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " (name, id) VALUES ('name-0', 0), ('name-1', 1)", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void insertIntoTableWithColumnsColumnHasExternalName() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name) DATA CONNECTION testDatabaseRef", new Object[0]);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " (fullName, id) VALUES ('name-0', 0), ('name-1', 1)", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void insertIntoTableMultipleValues() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.createMapping(this.tableName);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " SELECT v,'name-' || v FROM TABLE(generate_series(0,4))", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"), new SqlTestSupport.Row(1, "name-1"), new SqlTestSupport.Row(2, "name-2"), new SqlTestSupport.Row(3, "name-3"), new SqlTestSupport.Row(4, "name-4"));
    }

    @Test
    public void insertIntoTableSameValues() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName);
        InsertJdbcSqlConnectorTest.createMapping(this.tableName);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0]);
        Assertions.assertThatThrownBy(() -> InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " VALUES (0, 'name-0')", new Object[0])).isInstanceOf(HazelcastSqlException.class);
    }

    @Test
    public void insertIntoTableReverseColumnOrder() throws Exception {
        InsertJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(10)");
        InsertJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        InsertJdbcSqlConnectorTest.execute("INSERT INTO " + this.tableName + " (name, id) VALUES ('name-0', 0)", new Object[0]);
        InsertJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(0, "name-0"));
    }
}

