/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeletePredicatePushDownJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    private static final String JSON = "{\"value\":42}";
    private String tableName;

    @BeforeClass
    public static void beforeClass() {
        DeletePredicatePushDownJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = DeletePredicatePushDownJdbcSqlConnectorTest.randomTableName();
        DeletePredicatePushDownJdbcSqlConnectorTest.createTable(this.tableName, "id INT PRIMARY KEY", "name VARCHAR(100)", "age INT", "data VARCHAR(100)");
        DeletePredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeletePredicatePushDownJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 'name-0', 0, '{\"value\":42}')");
        DeletePredicatePushDownJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeletePredicatePushDownJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 'name-1', 1, '{\"value\":42}')");
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  name VARCHAR,  age INT,  data VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
    }

    @Test
    public void noParameterNoPredicate() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName, new Object[0]);
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, new SqlTestSupport.Row[0]);
    }

    @Test
    public void noParameterPredicateCanPushDown() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = 0", new Object[0]);
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void noParameterPredicateCanNotPushDown() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = 0 AND JSON_QUERY(data, '$.value') = '42'", new Object[0]);
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePredicateCanPushDown() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = ?", 0);
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePredicateCanPushDownCastColumn() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE CAST(age as VARCHAR(100)) = ?", "0");
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePredicateCanPushDownCastParameter() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = CAST(? as INTEGER)", "0");
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClausePredicateCanNotPushDown() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = ? AND JSON_QUERY(data, '$.value') = '42'", 0);
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }

    @Test
    public void parameterInWhereClauseAndPredicatePredicateCanNotPushDown() throws Exception {
        DeletePredicatePushDownJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE age = ? AND JSON_QUERY(data, '$.value') = ?", 0, "42");
        DeletePredicatePushDownJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class, Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1", 1, JSON));
    }
}

