/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.jdbc;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.jdbc.JdbcSqlTestSupport;
import com.hazelcast.test.jdbc.H2DatabaseProvider;
import com.hazelcast.test.jdbc.TestDatabaseProvider;
import org.assertj.core.util.Lists;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class DeleteJdbcSqlConnectorTest
extends JdbcSqlTestSupport {
    protected String tableName;

    @BeforeClass
    public static void beforeClass() {
        DeleteJdbcSqlConnectorTest.initialize((TestDatabaseProvider)new H2DatabaseProvider());
    }

    @Before
    public void setUp() throws Exception {
        this.tableName = DeleteJdbcSqlConnectorTest.randomTableName();
    }

    @Test
    public void deleteFromTable() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        DeleteJdbcSqlConnectorTest.createMapping(this.tableName);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName, new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, new SqlTestSupport.Row[0]);
    }

    @Test
    public void deleteFromTableWhereId() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        DeleteJdbcSqlConnectorTest.createMapping(this.tableName);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE id = 0", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void deleteFromTableWhereIdColumnWithExternalName() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        DeleteJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( person_id INT EXTERNAL NAME id,  name VARCHAR ) DATA CONNECTION testDatabaseRef", new Object[0]);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE person_id = 0", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void deleteFromTableWhereOnNonPKColumn() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        DeleteJdbcSqlConnectorTest.createMapping(this.tableName);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE name = 'name-0'", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void deleteFromTableWhereOnNonPKColumnWithExternalNme() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        DeleteJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  fullName VARCHAR EXTERNAL NAME name ) DATA CONNECTION testDatabaseRef", new Object[0]);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE fullName = 'name-0'", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, String.class}), new SqlTestSupport.Row(1, "name-1"));
    }

    @Test
    public void deleteFromTableUsingMappingName() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName);
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 2);
        String mappingName = "mapping_" + DeleteJdbcSqlConnectorTest.randomName();
        DeleteJdbcSqlConnectorTest.createMapping(this.tableName, mappingName);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + mappingName, new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, new SqlTestSupport.Row[0]);
    }

    @Test
    public void deleteFromWithMultiplePKColumns() throws Exception {
        DeleteJdbcSqlConnectorTest.createTableNoQuote(DeleteJdbcSqlConnectorTest.quote(this.tableName), DeleteJdbcSqlConnectorTest.quote("id") + " INT", DeleteJdbcSqlConnectorTest.quote("id2") + " INT", DeleteJdbcSqlConnectorTest.quote("name") + " VARCHAR(10)", "PRIMARY KEY(" + DeleteJdbcSqlConnectorTest.quote("id") + ", " + DeleteJdbcSqlConnectorTest.quote("id2") + ")");
        DeleteJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeleteJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 0, 'name-0')");
        DeleteJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeleteJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(1, 0, 'name-1')");
        DeleteJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeleteJdbcSqlConnectorTest.quote(this.tableName) + " VALUES(0, 1, 'name-2')");
        DeleteJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( id INT,  id2 INT,  name VARCHAR) DATA CONNECTION testDatabaseRef", new Object[0]);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE id = 0 AND id2 = 1", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{Integer.class, Integer.class, String.class}), new SqlTestSupport.Row(0, 0, "name-0"), new SqlTestSupport.Row(1, 0, "name-1"));
    }

    @Test
    public void deleteFromWithReverseColumnOrder() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName, "name VARCHAR(10)", "id INT PRIMARY KEY");
        DeleteJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeleteJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('name-0', 0)");
        DeleteJdbcSqlConnectorTest.executeJdbc("INSERT INTO " + DeleteJdbcSqlConnectorTest.quote(this.tableName) + " VALUES('name-1', 1)");
        DeleteJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " ( name VARCHAR,  id INT ) DATA CONNECTION testDatabaseRef", new Object[0]);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE id = 0", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, Lists.newArrayList((Object[])new Class[]{String.class, Integer.class}), new SqlTestSupport.Row("name-1", 1));
    }

    @Test
    public void deleteFromWithQuotedColumnInWhere() throws Exception {
        DeleteJdbcSqlConnectorTest.createTable(this.tableName, "person-id INT PRIMARY KEY", "name VARCHAR(100)");
        DeleteJdbcSqlConnectorTest.insertItems(this.tableName, 1);
        DeleteJdbcSqlConnectorTest.execute("CREATE MAPPING " + this.tableName + " DATA CONNECTION testDatabaseRef", new Object[0]);
        DeleteJdbcSqlConnectorTest.execute("DELETE FROM " + this.tableName + " WHERE \"person-id\" = 0", new Object[0]);
        DeleteJdbcSqlConnectorTest.assertJdbcRowsAnyOrder(this.tableName, new SqlTestSupport.Row[0]);
    }
}

