/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.generator;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.sql.SqlService;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlSeriesGeneratorTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlSeriesGeneratorTest.initialize((int)1, null);
        sqlService = SqlSeriesGeneratorTest.instance().getSql();
    }

    @Test
    public void test_generateSeriesAscending() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(-5, 5, 5))", Arrays.asList(new SqlTestSupport.Row(-5), new SqlTestSupport.Row(0), new SqlTestSupport.Row(5)));
    }

    @Test
    public void test_generateSeriesDescending() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(5, -5, -5))", Arrays.asList(new SqlTestSupport.Row(5), new SqlTestSupport.Row(0), new SqlTestSupport.Row(-5)));
    }

    @Test
    public void test_generateSeriesWithDefaultStep() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(0, 2))", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1), new SqlTestSupport.Row(2)));
    }

    @Test
    public void test_generateSeriesArgumentExpression() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(0, CAST('4' AS INTEGER), 1 + 1))", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(2), new SqlTestSupport.Row(4)));
    }

    @Test
    public void test_generateSeriesNamedArguments() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(step => 1 + 1, stop => 4, \"start\" => 1))", Arrays.asList(new SqlTestSupport.Row(1), new SqlTestSupport.Row(3)));
    }

    @Test
    public void test_generateSeriesNamedArgumentsAndDefaultStep() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(stop => 2 + 1, \"start\" => 1))", Arrays.asList(new SqlTestSupport.Row(1), new SqlTestSupport.Row(2), new SqlTestSupport.Row(3)));
    }

    @Test
    public void test_generateSeriesNamedArgumentsAndExplicitNull() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(stop => null, \"start\" => null))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_SERIES - null argument(s)");
    }

    @Test
    public void test_generateSeriesNamedArgumentsAndExplicitNullStep() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(stop => 2 + 1, \"start\" => 1, step => null))", Arrays.asList(new SqlTestSupport.Row(1), new SqlTestSupport.Row(2), new SqlTestSupport.Row(3)));
    }

    @Test
    public void test_generateSeriesFilterAndProject() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT v * 2 FROM TABLE(GENERATE_SERIES(0, 5)) WHERE v > 0 AND v < 5", Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateSeriesWithDynamicParameters() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT v * ? FROM TABLE(GENERATE_SERIES(0, ?)) WHERE v > ? AND v < 5", Arrays.asList(2, 5, 0), Arrays.asList(new SqlTestSupport.Row(2L), new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateSeriesWithNamedArgumentsAndDynamicParameters() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT v * ? FROM TABLE(GENERATE_SERIES(stop => ?, \"start\" => ?)) WHERE v > ? AND v < 5", Arrays.asList(2, 5, 0, 1), Arrays.asList(new SqlTestSupport.Row(4L), new SqlTestSupport.Row(6L), new SqlTestSupport.Row(8L)));
    }

    @Test
    public void test_generateSeriesWithDynamicParametersAndArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(0, ?))", new Object[]{"1"})).hasMessageContaining("Parameter at position 0 must be of INTEGER type, but VARCHAR was found");
    }

    @Test
    public void test_generateSeriesWithNamedArgumentsDynamicParametersAndArgumentTypeMismatch() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(stop => 10, \"start\" => ?))", new Object[]{"1"})).hasMessageContaining("Parameter at position 0 must be of INTEGER type, but VARCHAR was found");
    }

    @Test
    public void when_startIsGreaterThanStopAndStepIsPositive_then_returnsEmpty() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(2, 1, 1))", Collections.emptyList());
    }

    @Test
    public void when_startIsLessThanStopAndStepIsNegative_then_returnsEmpty() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(-2, -1, -1))", Collections.emptyList());
    }

    @Test
    public void when_stepIsZero_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(0, 5, 0))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_SERIES - step cannot be equal to zero");
    }

    @Test
    public void when_coercionIsRequired_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(0, '1'))", new Object[0])).hasMessageContaining("consider adding an explicit CAST");
    }

    @Test
    public void test_nullArgument() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(null, null))", new Object[0]).iterator().next()).hasMessageContaining("GENERATE_SERIES - null argument(s)");
    }

    @Test
    public void when_notInFromClause_then_throws() {
        SqlSeriesGeneratorTest.createMapping("m", Integer.TYPE, Integer.TYPE);
        SqlSeriesGeneratorTest.instance().getMap("m").put((Object)42, (Object)43);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT GENERATE_SERIES(null, null) FROM m", new Object[0])).hasMessage("Cannot call table function here: 'GENERATE_SERIES'");
    }

    @Test
    public void when_unknownIdentifier_then_throws() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(GENERATE_SERIES(\"start\" => 0, stop => 1, non_existing => 0))", new Object[0])).hasMessageContaining("Unknown argument name 'non_existing'");
    }

    @Test
    public void test_planCache() {
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(0, 1))", Arrays.asList(new SqlTestSupport.Row(0), new SqlTestSupport.Row(1)));
        Assertions.assertThat((int)SqlSeriesGeneratorTest.planCache(SqlSeriesGeneratorTest.instance()).size()).isEqualTo(1);
        SqlSeriesGeneratorTest.assertRowsAnyOrder("SELECT * FROM TABLE(GENERATE_SERIES(1, 2))", Arrays.asList(new SqlTestSupport.Row(1), new SqlTestSupport.Row(2)));
        Assertions.assertThat((int)SqlSeriesGeneratorTest.planCache(SqlSeriesGeneratorTest.instance()).size()).isEqualTo(2);
    }
}

