/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.file.FileSqlConnector;
import com.hazelcast.jet.sql.impl.connector.file.FileUtil;
import com.hazelcast.sql.SqlService;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlAvroTest
extends SqlTestSupport {
    private static final File AVRO_FILE = FileUtil.createAvroFile(FileUtil.AVRO_RECORD);
    private static final File AVRO_NULLABLE_FILE = FileUtil.createAvroFile(FileUtil.AVRO_NULLABLE_RECORD);
    private static final File AVRO_NULL_FILE = FileUtil.createAvroFile(FileUtil.AVRO_NULL_RECORD);
    private static final File AVRO_COMPLEX_FILE = FileUtil.createAvroFile(FileUtil.AVRO_COMPLEX_TYPES);
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlAvroTest.initializeWithClient((int)2, null, null);
        sqlService = SqlAvroTest.instance().getSql();
    }

    private static SqlTestSupport.SqlMapping fileMapping(String name, File file) {
        return (SqlTestSupport.SqlMapping)new SqlTestSupport.SqlMapping(name, FileSqlConnector.class).options(new Object[]{"format", "avro", "path", file.getParent(), "glob", file.getName(), "sharedFileSystem", true});
    }

    @Test
    public void test_nulls() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, AVRO_FILE).fields(new String[]{"nonExistingField VARCHAR"})).create();
        SqlAvroTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_fieldsMapping() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, AVRO_FILE).fields(new String[]{"id TINYINT EXTERNAL NAME byte", "name VARCHAR EXTERNAL NAME string"})).create();
        SqlAvroTest.assertRowsAnyOrder("SELECT id, name FROM " + name, List.of(new SqlTestSupport.Row((byte)127, "string")));
    }

    @Test
    public void test_allSqlTypes() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, AVRO_FILE).fields(new String[]{"string VARCHAR", "\"boolean\" BOOLEAN", "byte TINYINT", "short SMALLINT", "\"int\" INT", "long BIGINT", "\"float\" REAL", "\"double\" DOUBLE", "\"decimal\" DECIMAL", "\"time\" TIME", "\"date\" DATE", "\"timestamp\" TIMESTAMP", "timestampTz TIMESTAMP WITH TIME ZONE", "object OBJECT"})).create();
        SqlAvroTest.assertRowsAnyOrder("SELECT * FROM " + name, List.of(new SqlTestSupport.Row("string", true, (byte)127, (short)Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), LocalTime.of(12, 23, 34), LocalDate.of(2020, 4, 15), LocalDateTime.of(2020, 4, 15, 12, 23, 34, 1000000), OffsetDateTime.of(2020, 4, 15, 12, 23, 34, 200000000, ZoneOffset.UTC), new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"object").fields().endRecord()).build())));
    }

    @Test
    public void test_complexAvroTypes() {
        String name = SqlAvroTest.randomName();
        SqlAvroTest.fileMapping(name, AVRO_COMPLEX_FILE).create();
        List<SqlTestSupport.Row> rows = List.of(new SqlTestSupport.Row(SqlAvroTest.getAllValues(FileUtil.AVRO_COMPLEX_TYPES)));
        SqlAvroTest.assertRowsAnyOrder(SqlAvroTest.instances()[1], "SELECT * FROM " + name, rows);
        SqlAvroTest.assertRowsAnyOrder(SqlAvroTest.client(), "SELECT * FROM " + name, rows);
    }

    @Test
    public void test_schemaDiscovery() {
        this.test_schemaDiscovery(AVRO_FILE);
    }

    @Test
    public void test_schemaDiscovery_nullableFields() {
        this.test_schemaDiscovery(AVRO_NULLABLE_FILE);
    }

    @Test
    public void test_schemaDiscovery_nulls() {
        this.test_schemaDiscovery(AVRO_NULL_FILE);
    }

    private void test_schemaDiscovery(File avroFile) {
        String name = SqlAvroTest.randomName();
        SqlAvroTest.fileMapping(name, avroFile).create();
        SqlAvroTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\", \"null\", object FROM " + name, List.of(avroFile == AVRO_NULL_FILE ? new SqlTestSupport.Row(new Object[15]) : new SqlTestSupport.Row("string", true, 127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z", null, new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"object").fields().endRecord()).build())));
    }

    @Test
    public void test_tableFunction() {
        this.test_tableFunction(AVRO_FILE);
    }

    @Test
    public void test_tableFunction_nullableFields() {
        this.test_tableFunction(AVRO_NULLABLE_FILE);
    }

    @Test
    public void test_tableFunction_nulls() {
        this.test_tableFunction(AVRO_NULL_FILE);
    }

    private void test_tableFunction(File file) {
        SqlAvroTest.assertRowsAnyOrder("SELECT string, \"boolean\", byte, short, \"int\", long, \"float\", \"double\", \"decimal\", \"time\", \"date\", \"timestamp\", \"timestampTz\", \"null\", object FROM TABLE(" + SqlAvroTest.avroFile("path", file.getParent(), "sharedFileSystem", true) + ")", List.of(file == AVRO_NULL_FILE ? new SqlTestSupport.Row(new Object[15]) : new SqlTestSupport.Row("string", true, 127, Short.MAX_VALUE, Integer.MAX_VALUE, Long.MAX_VALUE, Float.valueOf(1.234568E9f), 1.234512345678901E14, "9223372036854775.123", "12:23:34", "2020-04-15", "2020-04-15T12:23:34.001", "2020-04-15T12:23:34.200Z", null, new GenericRecordBuilder((Schema)SchemaBuilder.record((String)"object").fields().endRecord()).build())));
    }

    @Test
    public void when_conversionFails_then_queryFails() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, AVRO_FILE).fields(new String[]{"string INT"})).create();
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).hasMessageContaining("Cannot parse VARCHAR value to INTEGER");
    }

    @Test
    public void when_columnsSpecified_then_fileNotAccessed() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, new File("/non-existent-directory/foo.avro")).fields(new String[]{"field INT"})).create();
    }

    @Test
    public void when_fileDoesNotExist_then_fails() {
        String name = SqlAvroTest.randomName();
        Assertions.assertThatThrownBy(() -> SqlAvroTest.fileMapping(name, new File(AVRO_FILE.getParent(), "foo.avro")).create()).hasMessageContaining("matches no files");
    }

    @Test
    public void when_fileDoesNotExistAndIgnoreFileNotFound_then_returnNoResults() {
        String name = SqlAvroTest.randomName();
        ((SqlTestSupport.SqlMapping)((SqlTestSupport.SqlMapping)SqlAvroTest.fileMapping(name, new File(AVRO_FILE.getParent(), "foo.avro")).fields(new String[]{"field INT"})).options(new Object[]{"ignoreFileNotFound", true})).create();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)sqlService.execute("SELECT * FROM " + name, new Object[0]).iterator().hasNext()).describedAs("no results from non existing file", new Object[0])).isFalse();
    }

    @Test
    public void when_directoryDoesNotExist_then_tableFunctionThrowsException() {
        String path = SqlAvroTest.hadoopNonExistingPath();
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(" + SqlAvroTest.avroFile("path", path) + ")", new Object[0])).hasMessageContaining("The directory '" + path + "' does not exist");
    }

    @Test
    public void when_fileDoesNotExist_then_tableFunctionThrowsException() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM TABLE(" + SqlAvroTest.avroFile("path", AVRO_FILE.getParent(), "glob", "foo.avro") + ")", new Object[0])).hasMessageContaining("matches no files");
    }

    private static String avroFile(Object ... params) {
        return IntStream.range(0, params.length / 2).mapToObj(i -> String.valueOf(params[2 * i]) + " => '" + String.valueOf(params[2 * i + 1]) + "'").collect(Collectors.joining(", ", "AVRO_FILE(", ")"));
    }

    private static Object[] getAllValues(GenericRecord record) {
        return IntStream.range(0, record.getSchema().getFields().size()).mapToObj(arg_0 -> ((GenericRecord)record).get(arg_0)).toArray();
    }
}

