/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.connector.file;

import com.hazelcast.jet.sql.impl.connector.file.Metadata;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolver;
import com.hazelcast.jet.sql.impl.connector.file.MetadataResolvers;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MetadataResolversTest {
    private static final String FORMAT = "some-format";
    private MetadataResolvers resolvers;
    @Mock
    private MetadataResolver<?> resolver;
    @Mock
    private Metadata metadata;

    @Before
    public void setUp() {
        BDDMockito.given((Object)this.resolver.supportedFormat()).willReturn((Object)FORMAT);
        this.resolvers = new MetadataResolvers(new MetadataResolver[]{this.resolver});
    }

    @Test
    public void when_formatIsMissing_then_throws() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.emptyList(), Collections.emptyMap())).isInstanceOf(QueryException.class)).hasMessageContaining("Missing 'format");
    }

    @Test
    public void when_pathIsMissing_then_throws() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.emptyList(), Collections.singletonMap("format", FORMAT))).isInstanceOf(QueryException.class)).hasMessageContaining("Missing 'path");
    }

    @Test
    public void when_formatIsNotSupported_then_throws() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.resolvers.resolveAndValidateFields(Collections.emptyList(), Map.of("format", "some-other-format", "path", "/path"))).isInstanceOf(QueryException.class)).hasMessageContaining("Unsupported serialization format");
    }

    @Test
    public void test_resolveAndValidateFields() {
        Map<String, String> options = Map.of("format", FORMAT, "path", "/path", "glob", "*");
        BDDMockito.given((Object)this.resolver.resolveAndValidateFields(Collections.emptyList(), options)).willReturn(Collections.singletonList(new MappingField("field", QueryDataType.VARCHAR)));
        List resolvedFields = this.resolvers.resolveAndValidateFields(Collections.emptyList(), options);
        Assertions.assertThat((List)resolvedFields).containsOnly((Object[])new MappingField[]{new MappingField("field", QueryDataType.VARCHAR)});
    }

    @Test
    public void test_resolveMetadata() {
        List<MappingField> resolvedFields = Collections.singletonList(new MappingField("field", QueryDataType.VARCHAR));
        Map<String, String> options = Map.of("format", FORMAT, "path", "/path", "glob", "*");
        BDDMockito.given((Object)this.resolver.resolveMetadata(resolvedFields, options)).willReturn((Object)this.metadata);
        Metadata metadata = this.resolvers.resolveMetadata(resolvedFields, options);
        Assertions.assertThat((Object)metadata).isNotNull();
    }
}

