/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.jet.Traverser;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.core.SlidingWindowPolicy;
import com.hazelcast.jet.sql.impl.aggregate.WindowUtils;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class WindowUtilsTest {
    @Test
    public void test_addWindowBounds() {
        this.check_addWindowBounds(9, 4L, 4L, 8, 12);
        this.check_addWindowBounds(10, 4L, 4L, 8, 12);
        this.check_addWindowBounds(11, 4L, 4L, 8, 12);
        this.check_addWindowBounds(12, 4L, 4L, 12, 16);
        this.check_addWindowBounds(9, 4L, 2L, 6, 10, 8, 12);
        this.check_addWindowBounds(10, 4L, 2L, 8, 12, 10, 14);
        this.check_addWindowBounds(11, 4L, 2L, 8, 12, 10, 14);
        this.check_addWindowBounds(11, 6L, 2L, 6, 12, 8, 14, 10, 16);
        this.check_addWindowBounds(Long.MAX_VALUE, 1L, 1L, new Object[0]);
        this.check_addWindowBounds(Long.MIN_VALUE, 1L, 1L, Long.MIN_VALUE, -9223372036854775807L);
        this.check_addWindowBounds(Long.MIN_VALUE, 2L, 1L, new Object[0]);
        this.check_addWindowBounds(Long.MIN_VALUE, 2L, 2L, Long.MIN_VALUE, -9223372036854775806L);
        this.check_addWindowBounds((byte)127, 4L, 2L, (byte)124, (byte)-128, (byte)126, (byte)-126);
        this.check_addWindowBounds((byte)-128, 4L, 2L, (byte)126, (byte)-126, (byte)-128, (byte)-124);
    }

    private void check_addWindowBounds(Object timestamp, long windowSize, long slideBy, Object ... outputWindows) {
        Assert.assertTrue((outputWindows.length % 2 == 0 ? 1 : 0) != 0);
        Traverser traverser = WindowUtils.addWindowBounds((JetSqlRow)new JetSqlRow((SerializationService)JetTestSupport.TEST_SS, new Object[]{timestamp}), (int)0, (SlidingWindowPolicy)SlidingWindowPolicy.slidingWinPolicy((long)windowSize, (long)slideBy));
        for (int i = 0; i < outputWindows.length; i += 2) {
            Object[] expected = new Object[]{timestamp, outputWindows[i], outputWindows[i + 1]};
            Assert.assertArrayEquals((Object[])expected, (Object[])((JetSqlRow)traverser.next()).getValues());
        }
        Assert.assertNull((Object)traverser.next());
    }
}

