/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.SqlColumnType;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.time.LocalDate;
import java.util.Arrays;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class SqlInsertWindowBoundsTest
extends SqlTestSupport {
    private SqlService sqlService;

    @BeforeClass
    public static void beforeClass() throws Exception {
        SqlInsertWindowBoundsTest.initialize((int)1, null);
    }

    @Before
    public void before() throws Exception {
        this.sqlService = SqlInsertWindowBoundsTest.instance().getSql();
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_TINYINT() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TINYINT, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row((byte)1, "Alice"), SqlInsertWindowBoundsTest.row((byte)10, null));
        String interval = "1";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.TINYINT);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.TINYINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.TINYINT);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.TINYINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.TINYINT);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.TINYINT.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_SMALLINT() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.SMALLINT, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row((short)1, "Alice"), SqlInsertWindowBoundsTest.row((short)10, null));
        String interval = "1";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.SMALLINT);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.SMALLINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.SMALLINT);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.SMALLINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.SMALLINT);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.SMALLINT.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_INT() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.INTEGER, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(1, "Alice"), SqlInsertWindowBoundsTest.row(10, null));
        String interval = "1";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.INTEGER);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.INTEGER.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.INTEGER);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.INTEGER.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.INTEGER);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.INTEGER.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_BIGINT() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.BIGINT, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(1L, "Alice"), SqlInsertWindowBoundsTest.row(10L, null));
        String interval = "1";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.BIGINT);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.BIGINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.BIGINT);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.BIGINT.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.BIGINT);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.BIGINT.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_TIME() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIME, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestamp(0L).toLocalTime().toString(), "Alice"), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestamp(10L).toLocalTime().toString(), null));
        String interval = "INTERVAL '0.001' SECOND";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.TIME);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.TIME.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.TIME);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.TIME.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.TIME);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.TIME.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_DATE() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.DATE, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(LocalDate.of(1970, 1, 1).toString(), "Alice"), SqlInsertWindowBoundsTest.row(LocalDate.of(1970, 1, 5).toString(), null));
        String interval = "INTERVAL '1' DAY";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.DATE);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.DATE.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.DATE);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.DATE.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.DATE);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.DATE.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_TIMESTAMP() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestamp(0L), "Alice"), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestamp(15L), null));
        String interval = "INTERVAL '0.001' SECOND";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(SqlColumnType.TIMESTAMP.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(SqlColumnType.TIMESTAMP.getValueClass());
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(SqlColumnType.TIMESTAMP.getValueClass());
    }

    @Test
    public void test_windowBoundsSameTypeAsDescriptor_TIMESTAMP_TZ() {
        String name = SqlInsertWindowBoundsTest.randomName();
        TestStreamSqlConnector.create(this.sqlService, name, Arrays.asList("ts", "name"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestampTz(0L).toString(), "Alice"), SqlInsertWindowBoundsTest.row(SqlInsertWindowBoundsTest.timestampTz(10L).toString(), null));
        String interval = "INTERVAL '0.001' SECOND";
        SqlRow row = (SqlRow)SqlInsertWindowBoundsTest.instance().getSql().execute(this.sql(name, interval), new Object[0]).iterator().next();
        SqlRowMetadata metadata = row.getMetadata();
        Class valueClass = SqlColumnType.TIMESTAMP_WITH_TIME_ZONE.getValueClass();
        Assertions.assertThat((Comparable)metadata.getColumn(0).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        Assertions.assertThat((Object)row.getObject(0)).isInstanceOf(valueClass);
        Assertions.assertThat((Comparable)metadata.getColumn(1).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        Assertions.assertThat((Object)row.getObject(1)).isInstanceOf(valueClass);
        Assertions.assertThat((Comparable)metadata.getColumn(2).getType()).isEqualTo((Object)SqlColumnType.TIMESTAMP_WITH_TIME_ZONE);
        Assertions.assertThat((Object)row.getObject(2)).isInstanceOf(valueClass);
    }

    private String sql(String name, String interval) {
        return "SELECT ts, window_start, window_end FROM TABLE(TUMBLE(  (SELECT * FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), " + interval + ")))  , DESCRIPTOR(ts)  , " + interval + ")) GROUP BY window_start, window_end, ts, name";
    }
}

