/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestAllTypesSqlConnector;
import com.hazelcast.sql.SqlService;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlAggregateTest_TypeCoercion
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void beforeClass() {
        SqlAggregateTest_TypeCoercion.initialize((int)1, null);
        sqlService = SqlAggregateTest_TypeCoercion.instance().getSql();
    }

    @Before
    public void before() {
        TestAllTypesSqlConnector.create(sqlService, "allTypesTable");
    }

    @Test
    public void test_groupBy() {
        TestAllTypesSqlConnector.create(sqlService, "t");
        String allFields = TestAllTypesSqlConnector.FIELD_LIST.stream().map(f -> "\"" + f.name() + "\"").collect(Collectors.joining(", "));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("SELECT " + allFields + " FROM t GROUP BY 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15", Collections.singletonList(TestAllTypesSqlConnector.ALL_TYPES_ROW));
    }

    @Test
    public void test_count() {
        String allFields = TestAllTypesSqlConnector.FIELD_LIST.stream().map(f -> "COUNT(\"" + f.name() + "\")").collect(Collectors.joining(", "));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("select " + allFields + ", count(null) from allTypesTable", Collections.singleton(new SqlTestSupport.Row(1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 1L, 0L, 0L)));
    }

    @Test
    public void test_sum_numberTypes() {
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("select sum(byte), sum(short), sum(\"int\"), sum(long), sum(\"float\"), sum(\"double\"), sum(\"decimal\"),sum(null) from allTypesTable", Collections.singleton(new SqlTestSupport.Row(127L, 32767L, Integer.MAX_VALUE, new BigDecimal(Long.MAX_VALUE), Float.valueOf(1.234568E9f), 1.234512345678901E14, new BigDecimal("9223372036854775.123"), null)));
    }

    @Test
    public void test_sum_otherTypes() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(string) from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [VARCHAR]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"boolean\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [BOOLEAN]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"time\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [TIME]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"date\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [DATE]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"timestamp\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [TIMESTAMP]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"timestampTz\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [TIMESTAMP WITH TIME ZONE]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select sum(\"object\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'SUM' function to [OBJECT]");
    }

    @Test
    public void test_avg_numericTypes() {
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("select avg(byte), avg(short), avg(\"int\"), avg(long), avg(\"float\"), avg(\"double\"), avg(\"decimal\"),avg(null) from allTypesTable", Collections.singleton(new SqlTestSupport.Row(BigDecimal.valueOf(127L), BigDecimal.valueOf(32767L), BigDecimal.valueOf(Integer.MAX_VALUE), BigDecimal.valueOf(Long.MAX_VALUE), 1.234567936E9, 1.234512345678901E14, new BigDecimal("9223372036854775.123"), null)));
    }

    @Test
    public void test_avg_otherTypes() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(string) from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [VARCHAR]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"boolean\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [BOOLEAN]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"time\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [TIME]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"date\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [DATE]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"timestamp\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [TIMESTAMP]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"timestampTz\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [TIMESTAMP WITH TIME ZONE]");
        Assertions.assertThatThrownBy(() -> sqlService.execute("select avg(\"object\") from allTypesTable", new Object[0])).hasMessageContaining("Cannot apply 'AVG' function to [OBJECT]");
    }

    @Test
    public void test_min() {
        TestAllTypesSqlConnector.create(sqlService, "t");
        String allFields = TestAllTypesSqlConnector.FIELD_LIST.stream().map(f -> "MIN(\"" + f.name() + "\")").collect(Collectors.joining(", "));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("SELECT " + allFields + "FROM t", Collections.singletonList(TestAllTypesSqlConnector.ALL_TYPES_ROW));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("select min(null) from allTypesTable", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_max() {
        TestAllTypesSqlConnector.create(sqlService, "t");
        String allFields = TestAllTypesSqlConnector.FIELD_LIST.stream().map(f -> "MAX(\"" + f.name() + "\")").collect(Collectors.joining(", "));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("SELECT " + allFields + "FROM t", Collections.singletonList(TestAllTypesSqlConnector.ALL_TYPES_ROW));
        SqlAggregateTest_TypeCoercion.assertRowsAnyOrder("select max(null) from allTypesTable", Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }
}

