/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.aggregate;

import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.connector.test.TestBatchSqlConnector;
import com.hazelcast.jet.sql.impl.connector.test.TestStreamSqlConnector;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import junitparams.JUnitParamsRunner;
import junitparams.Parameters;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=JUnitParamsRunner.class)
public class SqlAggregateTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlAggregateTest.initialize((int)2, null);
        sqlService = SqlAggregateTest.instance().getSql();
    }

    @Test
    public void test_groupBy() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {null, "1"}, {"Alice", "1"}, {null, "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name FROM " + name + " GROUP BY 1", Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row(new Object[]{null})));
        SqlAggregateTest.assertRowsAnyOrder("SELECT distance, name FROM " + name + " GROUP BY distance, name", Arrays.asList(new SqlTestSupport.Row(1, "Alice"), new SqlTestSupport.Row(2, "Alice"), new SqlTestSupport.Row(1, "Bob"), new SqlTestSupport.Row(1, null)));
    }

    @Test
    public void test_groupByEmpty() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT name FROM " + name + " GROUP BY name", Collections.emptyList());
    }

    @Test
    public void test_groupByNotSelectedField() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Alice", "4"}, {"Alice", "2"}, {"Joey", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name FROM " + name + " GROUP BY name, distance", Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void test_groupByExpression() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, (distance * 2) d FROM " + name + " GROUP BY name, distance * 2", Arrays.asList(new SqlTestSupport.Row("Alice", 2L), new SqlTestSupport.Row("Alice", 4L), new SqlTestSupport.Row("Bob", 2L)));
    }

    @Test
    public void test_groupByHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, distance FROM " + name + " GROUP BY name, distance HAVING distance < 2", Arrays.asList(new SqlTestSupport.Row("Alice", 1), new SqlTestSupport.Row("Bob", 1)));
    }

    @Test
    public void test_groupByExpressionHavingExpression() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Alice", "4"}, {"Alice", "2"}, {"Joey", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, (distance * 2) d FROM " + name + " GROUP BY name, d HAVING d > 2", Arrays.asList(new SqlTestSupport.Row("Alice", 4L), new SqlTestSupport.Row("Alice", 8L), new SqlTestSupport.Row("Joey", 4L)));
    }

    @Test
    public void test_distinct() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Alice", "4"}, {"Alice", "2"}, {"Joey", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT DISTINCT name FROM " + name, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void test_all() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Alice", "4"}, {"Alice", "2"}, {"Joey", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT ALL name FROM " + name, Arrays.asList(new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Alice"), new SqlTestSupport.Row("Bob"), new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void test_count() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {null, "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(name) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(2L)));
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(*) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(3L)));
    }

    @Test
    public void test_emptyCount() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(*) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(0L)));
    }

    @Test
    public void test_emptyCountGroupBy() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(*) FROM " + name + " GROUP BY name", Collections.emptyList());
    }

    @Test
    public void test_distinctCount() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(DISTINCT distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(2L)));
    }

    @Test
    public void test_groupCount() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, COUNT(*) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 3L), new SqlTestSupport.Row("Bob", 1L)));
    }

    @Test
    public void test_groupDistinctCount() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, COUNT(DISTINCT distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 2L), new SqlTestSupport.Row("Bob", 1L)));
    }

    @Test
    public void test_groupExpressionCount() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"}, {"Joey", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, (distance * 2) d, COUNT(*) FROM " + name + " GROUP BY name, d", Arrays.asList(new SqlTestSupport.Row("Alice", 2L, 2L), new SqlTestSupport.Row("Alice", 4L, 1L), new SqlTestSupport.Row("Bob", 2L, 1L), new SqlTestSupport.Row("Joey", 2L, 1L)));
    }

    @Test
    public void test_groupCountExpression() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"}, {"Joey", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, 2 * COUNT(*) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 6L), new SqlTestSupport.Row("Bob", 2L), new SqlTestSupport.Row("Joey", 2L)));
    }

    @Test
    public void test_groupCountHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, COUNT(*) c FROM " + name + " GROUP BY name, distance HAVING c < 2", Arrays.asList(new SqlTestSupport.Row("Alice", 1L), new SqlTestSupport.Row("Bob", 1L)));
    }

    @Test
    public void test_groupCountHavingAggregation() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, COUNT(*) FROM " + name + " GROUP BY name, distance HAVING COUNT(*) < 2", Arrays.asList(new SqlTestSupport.Row("Alice", 1L), new SqlTestSupport.Row("Bob", 1L)));
    }

    @Test
    public void test_groupExpressionCountHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, (distance * 2) d, COUNT(*) c FROM " + name + " GROUP BY name, d HAVING c < 2", Arrays.asList(new SqlTestSupport.Row("Alice", 4L, 1L), new SqlTestSupport.Row("Bob", 2L, 1L)));
    }

    @Test
    public void test_min() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT MIN(name), MIN(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row("Alice", 1)));
    }

    @Test
    public void test_emptyMin() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT MIN(name), MIN(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(null, null)));
    }

    @Test
    public void test_groupMin() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MIN(distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 1), new SqlTestSupport.Row("Bob", 2)));
    }

    @Test
    public void test_distinctMin() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT MIN(DISTINCT name) FROM " + name, Collections.singletonList(new SqlTestSupport.Row("Alice")));
    }

    @Test
    public void test_groupExpressionMin() {
        String name = SqlAggregateTest.createTable({"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MIN(distance * 2) m FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 2L), new SqlTestSupport.Row("Bob", 2L)));
    }

    @Test
    public void test_groupMinHaving() {
        String name = SqlAggregateTest.createTable({"Joey", "3"}, {"Alice", "2"}, {"Bob", "2"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MIN(distance) m FROM " + name + " GROUP BY name HAVING m > 1", Arrays.asList(new SqlTestSupport.Row("Bob", 2), new SqlTestSupport.Row("Joey", 3)));
    }

    @Test
    public void test_groupExpressionMinHaving() {
        String name = SqlAggregateTest.createTable({"Joey", "3"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MIN(distance * 2) m FROM " + name + " GROUP BY name HAVING m < 5", Arrays.asList(new SqlTestSupport.Row("Alice", 2L), new SqlTestSupport.Row("Bob", 2L)));
    }

    @Test
    public void test_max() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT MAX(name), MAX(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row("Joey", 2)));
    }

    @Test
    public void test_emptyMax() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT MAX(name), MAX(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(null, null)));
    }

    @Test
    public void test_groupMax() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MAX(distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 2), new SqlTestSupport.Row("Bob", 2)));
    }

    @Test
    public void test_distinctMax() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT MAX(DISTINCT name) FROM " + name, Collections.singletonList(new SqlTestSupport.Row("Joey")));
    }

    @Test
    public void test_groupExpressionMax() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MAX(distance * 2) m FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 4L), new SqlTestSupport.Row("Bob", 2L)));
    }

    @Test
    public void test_groupMaxHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MAX(distance) m FROM " + name + " GROUP BY name HAVING m > 1", Arrays.asList(new SqlTestSupport.Row("Alice", 2), new SqlTestSupport.Row("Joey", 3)));
    }

    @Test
    public void test_groupExpressionMaxHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Bob", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, MAX(distance * 2) m FROM " + name + " GROUP BY name HAVING m < 5", Arrays.asList(new SqlTestSupport.Row("Alice", 4L), new SqlTestSupport.Row("Bob", 4L)));
    }

    @Test
    public void test_sum() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT SUM(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(3L)));
    }

    @Test
    public void test_emptySum() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT SUM(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_almostEmptySum() {
        String name = SqlAggregateTest.createTable(new String[][]{{"Alice", null}});
        SqlAggregateTest.assertRowsAnyOrder("SELECT SUM(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_distinctSum() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT SUM(DISTINCT distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(3L)));
    }

    @Test
    public void test_groupSum() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, SUM(distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 3L), new SqlTestSupport.Row("Bob", 2L)));
    }

    @Test
    public void test_groupDistinctSum() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, SUM(DISTINCT distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", 3L), new SqlTestSupport.Row("Bob", 1L)));
    }

    @Test
    public void test_groupExpressionSum() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, SUM(distance * 2) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", new BigDecimal(6)), new SqlTestSupport.Row("Bob", new BigDecimal(2))));
    }

    @Test
    public void test_groupSumHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, SUM(distance) s FROM " + name + " GROUP BY name HAVING s > 2", Arrays.asList(new SqlTestSupport.Row("Alice", 3L), new SqlTestSupport.Row("Joey", 3L)));
    }

    @Test
    public void test_groupExpressionSumHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Bob", "1"}, {"Alice", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, SUM(distance * 2) s FROM " + name + " GROUP BY name HAVING s > 4", Arrays.asList(new SqlTestSupport.Row("Alice", new BigDecimal(6)), new SqlTestSupport.Row("Joey", new BigDecimal(6))));
    }

    private Object[] sum_types() {
        return new Object[]{new Object[]{QueryDataTypeFamily.TINYINT, QueryDataType.BIGINT}, new Object[]{QueryDataTypeFamily.SMALLINT, QueryDataType.BIGINT}, new Object[]{QueryDataTypeFamily.INTEGER, QueryDataType.BIGINT}, new Object[]{QueryDataTypeFamily.BIGINT, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.DECIMAL, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.REAL, QueryDataType.REAL}, new Object[]{QueryDataTypeFamily.DOUBLE, QueryDataType.DOUBLE}};
    }

    @Test
    @Parameters(method="sum_types")
    public void test_orderBySum(QueryDataTypeFamily columnType, QueryDataType expectedResultType) {
        String name = SqlAggregateTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("name", "distance"), Arrays.asList(QueryDataTypeFamily.VARCHAR, columnType), Arrays.asList({"A", "1"}, {"B", "2"}, {"A", "3"}, {"B", "4"}));
        SqlAggregateTest.assertRowsOrdered("SELECT name, SUM(distance) total_distance FROM " + name + " GROUP BY name ORDER BY total_distance DESC", Arrays.asList(new SqlTestSupport.Row("B", expectedResultType.convert((Object)6)), new SqlTestSupport.Row("A", expectedResultType.convert((Object)4))));
    }

    @Test
    public void test_avg() {
        String name = SqlAggregateTest.createTable({"Alice", "4"}, {"Bob", "2"}, {"Joey", null});
        SqlAggregateTest.assertRowsAnyOrder("SELECT AVG(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new BigDecimal("3"))));
    }

    @Test
    public void test_emptyAvg() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        SqlAggregateTest.assertRowsAnyOrder("SELECT AVG(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new Object[]{null})));
    }

    @Test
    public void test_distinctAvg() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT AVG(DISTINCT distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(new BigDecimal("1.5"))));
    }

    @Test
    public void test_groupAvg() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, AVG(distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", new BigDecimal("1.5")), new SqlTestSupport.Row("Bob", new BigDecimal("2"))));
    }

    @Test
    public void test_groupDistinctAvg() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Alice", "2"}, {"Bob", "1"}, {"Alice", "1"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, AVG(DISTINCT distance) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", new BigDecimal("1.5")), new SqlTestSupport.Row("Bob", new BigDecimal("1"))));
    }

    @Test
    public void test_groupExpressionAvg() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "1"}, {"Alice", "2"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, AVG(distance * 2) FROM " + name + " GROUP BY name", Arrays.asList(new SqlTestSupport.Row("Alice", new BigDecimal("3")), new SqlTestSupport.Row("Bob", new BigDecimal("2"))));
    }

    @Test
    public void test_groupAvgHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"}, {"Bob", "3"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, AVG(distance) s FROM " + name + " GROUP BY name HAVING s > 2", Arrays.asList(new SqlTestSupport.Row("Bob", new BigDecimal("2.5")), new SqlTestSupport.Row("Joey", new BigDecimal("3"))));
    }

    @Test
    public void test_groupExpressionAvgHaving() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"}, {"Bob", "3"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT name, AVG(distance * 2) s FROM " + name + " GROUP BY name HAVING s > 4", Arrays.asList(new SqlTestSupport.Row("Bob", new BigDecimal("5")), new SqlTestSupport.Row("Joey", new BigDecimal("6"))));
    }

    private Object[] avg_types() {
        return new Object[]{new Object[]{QueryDataTypeFamily.TINYINT, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.SMALLINT, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.INTEGER, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.BIGINT, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.DECIMAL, QueryDataType.DECIMAL}, new Object[]{QueryDataTypeFamily.REAL, QueryDataType.DOUBLE}, new Object[]{QueryDataTypeFamily.DOUBLE, QueryDataType.DOUBLE}};
    }

    @Test
    @Parameters(method="avg_types")
    public void test_orderByAvg(QueryDataTypeFamily columnType, QueryDataType expectedResultType) {
        String name = SqlAggregateTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("name", "distance"), Arrays.asList(QueryDataTypeFamily.VARCHAR, columnType), Arrays.asList({"A", "1"}, {"B", "2"}, {"A", "3"}, {"B", "4"}));
        SqlAggregateTest.assertRowsOrdered("SELECT name, AVG(distance) avg_distance FROM " + name + " GROUP BY name ORDER BY avg_distance DESC", Arrays.asList(new SqlTestSupport.Row("B", expectedResultType.convert((Object)3)), new SqlTestSupport.Row("A", expectedResultType.convert((Object)2))));
    }

    @Test
    public void test_multipleAggregateFunctions() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(*), MIN(distance), MAX(distance), SUM(distance), AVG(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(3L, 1, 3, 6L, new BigDecimal("2"))));
    }

    @Test
    public void test_expressionFromAggregates() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT COUNT(*) * SUM(distance) FROM " + name, Collections.singletonList(new SqlTestSupport.Row(18L)));
    }

    @Test
    public void test_nestedAggregation() {
        String name = SqlAggregateTest.createTable({"Alice", "1"}, {"Bob", "2"}, {"Alice", "2"}, {"Bob", "3"}, {"Joey", "3"});
        SqlAggregateTest.assertRowsAnyOrder("SELECT MAX(avg_dist) FROM (SELECT name, AVG(distance) avg_dist FROM " + name + " GROUP BY name)", Collections.singletonList(new SqlTestSupport.Row(new BigDecimal("3"))));
    }

    @Test
    public void test_aggregatingNonOrderedStreamingSource() {
        String name = SqlAggregateTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.BIGINT), new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM " + name, new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_aggregatingNonOrderedStreamingFunction() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM TABLE(GENERATE_STREAM(1))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_distinctNonOrderedStreamingSource() {
        String name = SqlAggregateTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Collections.singletonList("v"), Collections.singletonList(QueryDataTypeFamily.BIGINT), new Object[0][]);
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT DISTINCT v FROM " + name, new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_distinctNonOrderedStreamingFunction() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT DISTINCT v FROM TABLE(GENERATE_STREAM(1))", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    @Test
    public void test_rollup() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM " + name + " GROUP BY ROLLUP(name, distance)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("ROLLUP not supported");
    }

    @Test
    public void test_cube() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM " + name + " GROUP BY CUBE(name, distance)", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("CUBE not supported");
    }

    @Test
    public void test_groupingSet() {
        String name = SqlAggregateTest.createTable(new String[0][]);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(*) FROM " + name + " GROUP BY GROUPING SETS ((name), (distance))", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("GROUPING SETS not supported");
    }

    @Test
    public void test_streamAggregationWithoutWindowFunction() {
        String name = SqlAggregateTest.randomName();
        TestStreamSqlConnector.create(sqlService, name, Arrays.asList("ts", "name", "distance"), Arrays.asList(QueryDataTypeFamily.TIMESTAMP_WITH_TIME_ZONE, QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), new Object[][]{{SqlAggregateTest.timestampTz(0L), "Alice", 1}});
        Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT COUNT(name) FROM TABLE(IMPOSE_ORDER(TABLE " + name + ", DESCRIPTOR(ts), INTERVAL '0.002' SECOND)) GROUP BY ts", new Object[0])).hasRootCauseMessage("Streaming aggregation is supported only for window aggregation, with imposed order, grouping by a window bound (see TUMBLE/HOP and IMPOSE_ORDER functions)");
    }

    private static String createTable(String[] ... values) {
        String name = SqlAggregateTest.randomName();
        TestBatchSqlConnector.create(sqlService, name, Arrays.asList("name", "distance"), Arrays.asList(QueryDataTypeFamily.VARCHAR, QueryDataTypeFamily.INTEGER), Arrays.asList(values));
        return name;
    }
}

