/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.core.JetTestSupport;
import com.hazelcast.jet.core.JobStatus;
import com.hazelcast.jet.datamodel.Tuple2;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.SqlEndToEndTestSupport;
import com.hazelcast.jet.sql.impl.misc.Pojo;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.Accessors;
import com.hazelcast.test.HazelcastParametrizedRunner;
import com.hazelcast.test.HazelcastSerialParametersRunnerFactory;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=HazelcastParametrizedRunner.class)
@Parameterized.UseParametersRunnerFactory(value=HazelcastSerialParametersRunnerFactory.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class SqlPrunedMemberLeftTest
extends JetTestSupport {
    private static final int MAP_ENTRIES = 6144;
    private static final int CLUSTER_SIZE = 5;
    private static final int CONSTANT = 2;
    private static final String MAP_NAME = "map";
    private HazelcastInstance[] hz;
    private NodeEngine masterNodeEngine;
    private Map<Address, HazelcastInstance> addrToInstanceMap;
    @Parameterized.Parameter
    public boolean analyze;
    @Parameterized.Parameter(value=1)
    public boolean graceful;

    @Parameterized.Parameters(name="analyze={0}, graceful={1}")
    public static Collection<Object[]> parameters() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (boolean analyze : Arrays.asList(false, true)) {
            for (boolean graceful : Arrays.asList(false, true)) {
                params.add(new Object[]{analyze, graceful});
            }
        }
        return params;
    }

    @Before
    public void setUp() throws Exception {
        this.hz = new HazelcastInstance[5];
        this.addrToInstanceMap = new LinkedHashMap<Address, HazelcastInstance>();
        for (int i = 0; i < 5; ++i) {
            this.hz[i] = this.createHazelcastInstance(SqlPrunedMemberLeftTest.regularInstanceConfig());
            this.addrToInstanceMap.put(this.hz[i].getCluster().getLocalMember().getAddress(), this.hz[i]);
        }
        this.masterNodeEngine = Accessors.getNodeEngineImpl((HazelcastInstance)this.hz[0]);
        this.prepareMap();
        SqlTestSupport.createMapping(this.hz[0], MAP_NAME, Pojo.class, Integer.class);
    }

    @Test
    public void test_queryDoesNotTerminateWhenPrunedMemberLeavesCluster() {
        String query = (this.analyze ? "ANALYZE " : "") + "SELECT * FROM map WHERE f0 = 2";
        HazelcastInstance prunedInstanceToTerminate = (HazelcastInstance)this.findPrunedAndNonPrunedInstance().f0();
        HazelcastInstance nonPrunedInstance = (HazelcastInstance)this.findPrunedAndNonPrunedInstance().f1();
        int cnt = 0;
        for (SqlRow row : nonPrunedInstance.getSql().execute(query, new Object[0])) {
            if (cnt == 0) {
                if (this.graceful) {
                    prunedInstanceToTerminate.shutdown();
                } else {
                    prunedInstanceToTerminate.getLifecycleService().terminate();
                }
                SqlPrunedMemberLeftTest.assertClusterSizeEventually((int)4, (Collection)Arrays.stream(this.hz).filter(i -> i != prunedInstanceToTerminate).collect(Collectors.toList()));
                ((ListAssert)Assertions.assertThat((List)nonPrunedInstance.getJet().getJobs()).as("The query should be still running", new Object[0])).anyMatch(j -> j.getStatus() == JobStatus.RUNNING);
            }
            ++cnt;
        }
        Assert.assertEquals((long)6144L, (long)cnt);
    }

    private Tuple2<HazelcastInstance, HazelcastInstance> findPrunedAndNonPrunedInstance() {
        Tuple2<Set<Address>, Set<Integer>> expectedPartitionsAndParticipants = SqlEndToEndTestSupport.calculateExpectedPartitions(this.masterNodeEngine, SqlPrunedMemberLeftTest.getPartitionAssignment((HazelcastInstance)this.hz[0]), true, 1, 2);
        HashSet<Address> addresses = new HashSet<Address>(this.addrToInstanceMap.keySet());
        Assert.assertNotNull((Object)expectedPartitionsAndParticipants.f0());
        Assert.assertTrue((boolean)addresses.removeAll((Collection)expectedPartitionsAndParticipants.f0()));
        Address toRemove = (Address)addresses.iterator().next();
        return Tuple2.tuple2((Object)this.addrToInstanceMap.get(toRemove), (Object)this.addrToInstanceMap.get(((Set)expectedPartitionsAndParticipants.f0()).iterator().next()));
    }

    private void prepareMap() {
        MapConfig mapConfig = new MapConfig(MAP_NAME).setPartitioningAttributeConfigs(Collections.singletonList(new PartitioningAttributeConfig("f0")));
        this.hz[0].getConfig().addMapConfig(mapConfig);
        IMap map = this.hz[0].getMap(MAP_NAME);
        for (int i = 0; i < 6144; ++i) {
            map.put((Object)new Pojo(2, i, i), (Object)i);
        }
    }
}

